#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.oh/discovery/intg/scripts/coherenceOH_discovery.pl /main/3 2011/12/27 00:12:29 hmodawel Exp $
#
# coherence_discovery.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      coherence_discovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/26/11 - remove fix for 12907385
#    prbhoj      11/15/11 - Added Coherence OH discovery logic
#    hmodawel    11/12/11 - Creation
# 
#!/usr/local/bin/perl
use Net::Domain qw(hostname hostfqdn hostdomain);
use File::Spec;
use strict;
use OH_Target;
use emdcommon_ocm;
use ias::propertiesFileParser;

# Below is just a sample of creating single Oracle Home target but integrators may print 
# a list of target in similar fashion.

# By default, this script gets three args by the caller script
#1) mw_home
#2) onHost
#3) homeType

unless (caller) {
    &printTarget(@ARGV);
}


sub printTarget {
  my $mwHome = shift;
  my $onHost = shift;
  my $homeType = shift;

  return 1 if ( !(defined $mwHome) || !(defined $onHost) || !(defined $homeType) );

  # Coherence discovery needs to do a bit more to find the coherence Oracle Home
  # Determine commEnv.sh file to get COHERENCE_HOME environment variable value

  #my $wlsHome = LL_OH_Utilities::getWLSOracleHome($mwHome);
  #my $commEnvFileName = File::Spec->catfile($wlsHome, "common", "bin", "commEnv.sh");

  #emdcommon_ocm::EMD_PERL_DEBUG("COH OH: WLS Common Enviroment file is $commEnvFileName");

  my $coherenceHome;

  # Look for COHERENCE_HOME property in commEnv.sh. Use this if one is available
  # otherwise use mwHome/coherence if present else use mwHome/coherence_<ver> if present
  #if (-e $commEnvFileName)
  #{
    #my %configProperties =  parsePropertiesFile($commEnvFileName);

    #for my $propName (keys %configProperties)
    #{
        #my $cohProp = "COHERENCE_HOME";
        #if ($propName eq $cohProp)
        #{
            #$coherenceHome = $configProperties{$propName}; #this is full path
        #}
    #}
  #}

  # Look for existence of mwhome/coherence_<ver> directory. 
  if (!defined($coherenceHome))
  {
    my $coherenceDir = File::Spec->catfile($mwHome, "coherence");
    if (!-d $coherenceDir) {
        opendir(DIR, $mwHome) || return 1;
        my @coherenceFiles = grep{/^coherence_/} readdir(DIR); #TODO : Preeti : ignore case ?? windows ??
        closedir(DIR);
        # this is the coherhence_version dir
        $coherenceHome = File::Spec->catfile($mwHome, $coherenceFiles[0]) if defined($coherenceFiles[0]);
    }
    else {
        $coherenceHome = $coherenceDir;
    }
  }

  #$coherenceHome =~ tr/"//d; # only required if we read from commEnv.sh

  if (defined($coherenceHome)) # check in case there is no coherence or coherence_ver dir
  {
    emdcommon_ocm::EMD_PERL_DEBUG("COH OH: Coherence home is $coherenceHome");
    # Initialize oracle_home target properties
    my $ohProps = new OH_Target_Props(
         HOME_TYPE => $homeType, # determined by the OH discovery caller
         INSTALL_LOCATION => $coherenceHome, 
         #OracleHome => $coherenceHome, # new requirement from MOS, bug 12907385
         MW_HOME => $mwHome,  # determined by the OH discovery caller
         INVENTORY => '',     #to be determined by impl (this script) (empty for non_oui installations)
         OcmProxyOracleHome => $coherenceHome); #to be determined by impl (this script)

    # initialize the oracle_home target object
    # one may wish to overwrite the host in case the OH target resides on remote host
    # Target Name Target Type combination should be unique on EM, one might want to append 
    # host name to the same OR one can overwrite with something like below
    my $host = hostname(); #short host name
    
    #For now we are setting target name to Path
    my $target_name = $coherenceHome;
    # But this would create problems if this code will run in GC (target name conflict)
    # in those cases, please use the below two lines ..
    #  my $target_name = $coherenceHome."_".$host; 
    # and set OLD_NAME property for target to "$coherenceHome

    my $ohTarget = new OH_Target(NAME => $target_name,
                             DISPLAY_NAME => 'Coherence Home',
                             ON_HOST => $onHost,
                             PROPS => $ohProps);

    # Print the target xml snippet to be included in discovery result.
    $ohTarget->printXml();
  }
}

1;
