#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.oh/discovery/intg/scripts/elOH_discovery.pl /main/1 2011/12/30 10:50:41 sasachde Exp $
#
# elOH_discovery.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      elOH_discovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    12/22/11 - Creation
# 

use Net::Domain qw(hostname hostfqdn hostdomain);
use strict;
use OH_Target;
use emdcommon_ocm;

# By default, this script gets three args by the caller script
#1) mw_home
#2) onHost
#3) homeType

unless (caller) {
  &printTarget(@ARGV);
}

sub printTarget {
  my $mwHome = shift;
  my $onHost = shift;
  my $homeType = shift;

  if ( !(defined $mwHome) || !(defined $onHost) || !(defined $homeType) )
  {
    emdcommon_ocm::EMD_PERL_DEBUG("EL OH: MWHome and/or ON_HOST and/or HomeType not defined. OracleHome target will not be discovered");
    return 1;
  }

  my $elHome = "/opt/exalogic";

  if (! -d $elHome)
  {
    emdcommon_ocm::EMD_PERL_DEBUG("EL OH: EL OracleHome path does not exist. OracleHome target will not be discovered");
    return 1;
  }

  # Initialize EL oracle_home target properties
  my $elOHProps = new OH_Target_Props(
         HOME_TYPE => $homeType, # determined by the OH discovery caller
         INSTALL_LOCATION => $elHome,
         MW_HOME => $mwHome,  # determined by the OH discovery caller
         INVENTORY => '',     #empty for non_oui installations
         OcmProxyOracleHome => $elHome);

  #host name
  my $host = hostname();

  #setting OH path as target name
  my $target_name = $elHome;
  # But this would create problems if this code will run in GC (target name conflict)
  # in those cases, please use the below two lines ..
  #  my $target_name = $elHome."_".$host;
  # and set OLD_NAME property for target to "$elHome

  # initialize the oracle_home target object
  my $elOHTarget = new OH_Target(NAME => $target_name,
                             DISPLAY_NAME => '',
                             ON_HOST => $onHost,
                             PROPS => $elOHProps);

  # Print the target xml snippet to be included in discovery result.
  $elOHTarget->printXml();
}

1;
