#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.oh/discovery/intg/scripts/jrockitOH_discovery.pl /main/3 2011/12/27 00:12:29 hmodawel Exp $
#
# jrockit_discovery.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      jrockit_discovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hmodawel    12/26/11 - remove fix for 12907385
#    hmodawel    11/12/11 - Add jrockit OH discovery logic
#    nvarma      10/20/11 - Creation
# 

#!/usr/local/bin/perl
use Net::Domain qw(hostname hostfqdn hostdomain);
use File::Spec;
use strict;
use OH_Target;
use emdcommon_ocm;

# Below is just a sample of creating single Oracle Home target but integrators may print 
# a list of target in similar fashion.

# By default, this script gets three args by the caller script
#1) mwHome
#2) onHost
#3) homeType

unless (caller) {
    &printTarget(@ARGV);
}

sub printTarget {
  my $mwHome = shift;
  my $onHost = shift;
  my $homeType = shift;

  return 1 if ( !(defined $mwHome) || !(defined $onHost) || !(defined $homeType) );

  opendir(DIR, $mwHome) || return 1;
  my @jrockitDirs = grep{/^jrockit/i} readdir(DIR);
  closedir(DIR); 

  my $host = hostname(); #short host name
  foreach my $jrockitdir (@jrockitDirs)
  {
    my $jrockitHome = File::Spec->catfile($mwHome , $jrockitdir);
    # Initialize oracle_home target properties
    my $ohProps = new OH_Target_Props(
           HOME_TYPE => $homeType, # determined by the OH discovery caller
           INSTALL_LOCATION => $jrockitHome , #to be determined by impl (this script)
           #OracleHome => $jrockitHome,  # new requirement from MOS, bug 12907385
           MW_HOME => $mwHome,  # determined by the OH discovery caller
           INVENTORY => '',     #to be determined by impl (this script) (empty for non_oui installations)
           OcmProxyOracleHome => $jrockitHome ); #to be determined by impl (this script)
  
    # initialize the oracle_home target object
    # one may wish to overwrite the host in case the OH target resides on remote host
    # Target Name Target Type combination should be unique on EM, one might want to append 
    # host name to the same OR one can overwrite with something like below
    #my $target_name = $jrockitHome. "_" . $host; # put pathname of mwhome for uniqueness

    #For now we are setting target name to Path
    my $target_name = $jrockitHome;       
    # But this would create problems if this code will run in GC (target name conflict)
    # in those cases, please use the below two lines ..
    #  my $target_name = $jrockitHome."_".$host; 
    # and set OLD_NAME property for target to "$jrockitHome

    my $ohTarget = new OH_Target(NAME => $target_name,
                               DISPLAY_NAME => 'JRockit Home',
                               ON_HOST => $onHost,
                               PROPS => $ohProps);
  
    # Print the target xml snippet to be included in discovery result.
    $ohTarget->printXml();
  }
}

1;  
