#!/usr/local/bin/perl
# 
# $Header: emcore/builtin_target_types/oracle.sysman.oh/discovery/intg/scripts/sample_intg_discovery.pl /main/1 2011/11/30 12:01:32 hmodawel Exp $
#
# sample_intg_discovery.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      sample_intg_discovery.pl - Sample Discovery Script for OH Discovery Integrators
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ravpatel    09/28/11 - Sample Discovery Script for OH Discovery
#                           Integrators
#    ravpatel    09/28/11 - Creation
#

use Getopt::Long;
use strict;
use OH_Target;

# Below is just a sample of creating single Oracle Home target but integrators may print 
# a list of target in similar fashion.

# By default, this script gets three args by the caller script
#1) --mw_home $BEA_HOME
#2) --on_host $host
#3) --home_type $homeType


my $mw_home;
my $host;
my $homeType;

my $result = GetOptions ( 'mw_home=s' => \$mwhome,
                          'on_host=s' => \$host,
                          'home_type=s' => \$homeType);


# Initialize oracle_home target properties
my $ohProps = new OH_Target_Props(
         HOME_TYPE => $homeType, # determined by the OH discovery caller
         INSTALL_LOCATION => '/scratch/ravpatel/bea1/jrockit-1.5', #to be determined by impl (this script)
         MW_HOME => $mwhome,  # determined by the OH discovery caller
         INVENTORY => '',     #to be determined by impl (this script) (empty for non_oui installations)
         OcmProxyOracleHome => '/scratch/ravpatel/bea1/jrockit-1.5'); #to be determined by impl (this script)

# initialize the oracle_home target object
# one may wish to overwrite the host in case the OH target resides on remote host
# Target Name Target Type combination should be unique on EM, one might want to append 
# host name to the same OR one can overwrite with something like below
$host = hostname(); #short host name
my $target_name = 'Jrokit_1_5_home' . '_' . $host;
my $ohTarget = new OH_Target(NAME => $target_name,
                             DISPLAY_NAME => 'JRockit 1.5 Home',
                             ON_HOST => $host,
                             PROPS => $ohProps);

# Print the target xml snippet to be included in discovery result.
$ohTarget->printXml();

