#!/usr/local/bin/perl
# 
# $Header: empp/emvt/plugin_dist/agent/scripts/Associations.pl /main/1 2011/06/30 02:44:24 chkaushi Exp $
#
# Associations.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Associations.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    chkaushi    05/25/11 - Getting associations
#    chkaushi    05/25/11 - Creation
#

use strict;
use warnings;
use XML::Parser;
use File::Spec;

package VSParser;

## mandatory arguments
my $beaHome = $ENV{BEA_HOME};
my $ovmcfgHome = $ENV{OVM_CFG_HOME};

my %zones = () ;
my %servPools = ();
my %servers = ();
my %vms = ();

my $zonesTag = "F";
my $zoneTag = "F";
my $servPoolsTag = "F";
my $servPoolTag = "F";
my $serversTag = "F";
my $serverTag = "F";
my $vmsTag = "F" ;
my $vmTag = "F";
my $vnicTag = "F";
my $vnicsTag = "F";

my $EM_RESULT="em_result=";
my $parseFailure=0;

my $zoneToParse;
my $servPoolToParse;
my $vmToParse;
my $servToParse;
my $zone;
my $servPool;
my $server;
my $vm;

my $zoneFound= 0 ;
my $servPoolFound = 0;
my $vmFound = 0;
my $servFound = 0;

# Expat built-in encodings are UTF-8, iso-8859-1 [west european], UTF-16, and US-ASCII
# the remainder are from the various .enc files included with our perl distribution
my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);

my ( $tgtName , $elType ) = @ARGV;
my $fileToParse = filetoParse();

if (!($fileToParse eq ''))
{
  if(-r  $fileToParse)
  {
    my $p = new XML::Parser(ErrorContext => 2 ) ;

    $p->setHandlers(Start => \&parseStart,
                         End => \&parseEnd  );
    $p->parsefile($fileToParse) ;

    if($@)
    {
        foreach $_ (@encTable)
        {
            %zones = () ;
            %servPools = ();
            %servers = ();
            %vms = ();


            eval '$p->parsefile($fileToParse, ProtocolEncoding => $_)' ;

            if(!$@)
            {
                last;
            }

        }
    }
    if($@)
    {
        print "$fileToParse failed Validation\n";
        $parseFailure = 1;
        print STDERR "em_error=$fileToParse parse failed.\n";
        exit 0;
    }
    if($elType eq "SERVPOOL_ASSOC")
    {
        foreach $vm(sort keys %vms)
        {
            if(defined($vms{$vm}->{_VSP_UUID}) && ($vms{$vm}->{_VSP_UUID} eq $tgtName))
            {
                my $ref = $vms{$vm} ;
                print $EM_RESULT .
                      "contains" . "|".
                      ""  . "|".
                      "oracle_vm_guest" . "|".
                      (defined($ref->{_GVM_UUID}) ? $ref->{_GVM_UUID} : "" ) . "\n";
            }
        }
        foreach $servPool(sort keys %servPools)
        {
            if(defined($servPools{$servPool}->{_VSP_UUID}) && ($servPools{$servPool}->{_VSP_UUID} eq $tgtName))
            {
                my $ref = $servPools{$servPool} ;
                my $zoneUUID = $ref->{_ZONE_UUID};
      
                my $zoneRef;
                foreach $zone(sort keys %zones)
                {
                    if((defined($zones{$zone}->{_ZONE_UUID})) && (defined($zoneUUID))&& ($zones{$zone}->{_ZONE_UUID} eq $zoneUUID))
                    {
                       $zoneRef = $zones{$zone};
                       print $EM_RESULT .
                             "member_of" . "|".
                             ""  . "|".
                             "oracle_vm_zone" . "|".
                             (defined($ref->{_ZONE_UUID}) ? $ref->{_ZONE_UUID} : "" ) . "\n";

                    }

                }
            }
        }
    }
    elsif($elType eq "SERV_ASSOC")
    {
        foreach $server(sort keys %servers)
        {
            if(defined($servers{$server}->{_VS_UUID}) && ($servers{$server}->{_VS_UUID} eq $tgtName))
            {
                my $ref = $servers{$server} ;
                my $servPUUID = $ref->{_VSP_UUID} ; 
                
                my $servPref ;
                foreach $servPool(sort keys %servPools)
                {
                    if((defined($servPools{$servPool}->{_VSP_UUID})) && (defined($servPUUID))&& ($servPools{$servPool}->{_VSP_UUID} eq $servPUUID))
                    {
                       $servPref = $servPools{$servPool};
                       print $EM_RESULT .
                             "member_of" . "|".
                             ""  . "|".
                             "oracle_vm_server_pool" . "|".
                             (defined($ref->{_VSP_UUID}) ? $ref->{_VSP_UUID} : "" ) . "\n";
                       
                    }
                }
            }
        }
    
        foreach $vm(sort keys %vms)
        {
            if((defined($vms{$vm}->{_VS_UUID})) && ($vms{$vm}->{_VS_UUID} eq $tgtName))
            {
                my $ref = $vms{$vm} ;
                print $EM_RESULT .
                      "contains" . "|".
                      ""  . "|".
                      "oracle_vm_guest" . "|".
                      (defined($ref->{_GVM_UUID}) ? $ref->{_GVM_UUID} : "" ) . "\n";
            }
        }
    }
    elsif($elType eq "GVM_HOST")
    {
        foreach $vm(sort keys %vms)
        {
            if(defined($vms{$vm}->{_GVM_UUID}) && ($vms{$vm}->{_GVM_UUID} eq $tgtName) && (defined($vms{$vm}->{_MAC_ADDR})))
            {
                my $ref = $vms{$vm} ;
                print $EM_RESULT .
                      "contains" . "|".
                      ""  . "|".
                      "host" . "|".
                      (defined($ref->{_MAC_ADDR}) ? $ref->{_MAC_ADDR} : "" ) . "\n";
            }
        }
    }
    else
    {
        print STDERR "em_error=Invalid Tag Passed.\n";
        exit 0;
    }
  }
  else
  {
    print "em_warning=$fileToParse exists but does not have read permissions \n";
    exit 0;
  }

}

## File Location can be any of $BEA_HOME/state/virtualdata.xml
## or $OVM_CFG_HOME/virtualdata.xml or /tmp/virtualdata.xml
## We look for these files in this order 
## $OVM_CFG_HOME dir , then $BEA_HOME and then /tmp
## This is being done to have flexibility of file location where OVM dumps the data and OCM finds it.

sub filetoParse
{
     my $fileName = File::Spec->catfile($beaHome , "state", "virtualdata.xml");
    my $fileNameOvm = File::Spec->catfile($ovmcfgHome, "virtualdata.xml");
    my $fileNameTmp = File::Spec->catfile("" , "tmp", "virtualdata.xml");

    if(-e $fileNameOvm)
    {
        return $fileNameOvm;
    }
    elsif(-e $fileName)
    {
        return  $fileName;
    }
    elsif(-e $fileNameTmp)
    {
        return  $fileNameTmp;
    }
    return '';
}

sub parseStart
{
    my $p = shift;
    my $el = shift;

    if($el eq "zones")
    {
        $zonesTag = "T";
    }
    elsif($el eq "zone")
    {
        $zoneTag = "T";
        if($zonesTag eq "T")
        {
            my $zoneNew = $zones{$zoneFound};
            if(not defined($zoneNew))
            {
                $zones{$zoneFound} = $zoneNew = new Zone;
                $zoneFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "zone-uuid")
                {
                    $zoneNew->{_ZONE_UUID} = $val;
                }
                elsif($att eq "name")
                {
                    $zoneNew->{_NAME} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $zoneNew->{_OVMM_UUID} = $val;
                }
            }
        }
    }
    elsif($el eq "servers")
    {
        $serversTag = "T";
    }
    elsif($el eq "server")
    {
        $serverTag = "T";
        if($serversTag eq "T")
        {
            my $servNew = $servers{$servFound};
            if(not defined($servNew))
            {
                $servers{$servFound} = $servNew = new Server;
                $servFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "zone-uuid")
                {
                    $servNew->{_ZONE_UUID} = $val;
                }
                elsif($att eq "name")
                {
                    $servNew->{_NAME} = $val;
                }
                elsif($att eq "vs-uuid")
                {
                    $servNew->{_VS_UUID} = $val;
                }
                elsif($att eq "vsp-uuid")
                {
                    $servNew->{_VSP_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $servNew->{_OVMM_UUID} = $val;
                }

            }
        }
    }
    elsif($el eq "server-pools")
    {
        $servPoolsTag = "T";
    }
    elsif($el eq "server-pool")
    {
        $servPoolTag = "T";
        if($servPoolsTag eq "T")
        {
            my $servPoolNew = $servPools{$servPoolFound};
            if(not defined($servPoolNew))
            {
                $servPools{$servPoolFound} = $servPoolNew = new ServPool;
                $servPoolFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "zone-uuid")
                {
                    $servPoolNew->{_ZONE_UUID} = $val;
                }
                elsif($att eq "name")
                {
                    $servPoolNew->{_NAME} = $val;
                }
                elsif($att eq "vsp-uuid")
                {
                    $servPoolNew->{_VSP_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $servPoolNew->{_OVMM_UUID} = $val;
                }

            }
        }
    }
    elsif($el eq "virtual-machines")
    {
        $vmsTag = "T";
    }
    elsif($el eq "virtual-machine")
    {
        $vmTag = "T";
        if($vmsTag eq "T")
        {
            my $vmNew = $vms{$vmFound};
            if(not defined($vmNew))
            {
                $vms{$vmFound} = $vmNew = new VM;
                $vmFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "zone-uuid")
                {
                    $vmNew->{_ZONE_UUID} = $val;
                }
                elsif($att eq "name")
                {
                    $vmNew->{_NAME} = $val;
                }
                elsif($att eq "vs-uuid")
                {
                    $vmNew->{_VS_UUID} = $val;
                }
                elsif($att eq "vsp-uuid")
                {
                    $vmNew->{_VSP_UUID} = $val;
                }
                elsif($att eq "guest-uuid")
                {
                    $vmNew->{_GVM_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $vmNew->{_OVMM_UUID} = $val;
                }
            }
        }
    }
    elsif($el eq "virtual-nics")
    {
        $vnicsTag = "T";
    }
    elsif($el eq "virtual-nic")
    {
        $vnicTag = "T";
        if(($vmsTag eq "T") && ($vmTag eq "T") && ($vnicsTag eq "T"))
        {
            my $vmNew = $vms{$vmFound};
            if(not defined($vmNew))
            {
                $vms{$vmFound} = $vmNew = new VM;
                $vmFound++;
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "mac-address")
                {
                    $vmNew->{_MAC_ADDR} = $val;
                }
            }
        }
    }
}

sub parseEnd
{
    my $p = shift;
    my $el = shift ;

    if($el eq "zones")
    {
        $zonesTag = "F";
    }
    elsif($el eq "zone")
    {
        $zoneTag ="F";
    }
    if($el eq "server-pools")
    {
        $servPoolsTag = "F";
    }
    elsif($el eq "server-pool")
    {
        $servPoolTag ="F";
    }
    if($el eq "servers")
    {
        $serversTag = "F";
    }
    elsif($el eq "server")
    {
        $serverTag ="F";
    }
    if($el eq "virtual-machines")
    {
        $vmsTag = "F";
    }
    elsif($el eq "virtual-machine")
    {
        $vmTag ="F";
    }
    elsif($el eq "virtual-nics")
    {
        $vnicsTag = "F";
    }
    elsif($el eq "virtual-nic")
    {    
        $vnicTag = "F";
    }
}

package Zone;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
} 

package VM;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package Server;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package ServPool;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

