#!/usr/local/bin/perl
# 
# $Header: empp/emvt/plugin_dist/agent/scripts/GuestParser.pl /main/2 2011/07/20 07:02:25 sasinsin Exp $
#
# GuestParser.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      GuestParser.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    chkaushi    03/22/11 - Parses OVM Guest Machine
#    chkaushi    03/22/11 - Creation
#

use strict;
use warnings;
use XML::Parser;
use File::Spec;
package VSParser;
## require 'emd_common.pl';

## mandatory arguments
my $beaHome = $ENV{BEA_HOME};
my $ovmcfgHome = $ENV{OVM_CFG_HOME};

my %vms = () ;
my %vnics = ();
my %vmdisks = ();

my $vmsTag = "F";
my $vmTag = "F";
my $vnicsTag = "F";
my $vnicTag = "F";
my $vmdisksTag = "F";
my $vmdiskTag = "F";

my $EM_RESULT="em_result=";
my $parseFailure=0;

my $vmToParse;

my $vmFound=0;
my $vnicFound=0;
my $vmdiskFound=0;
my ($vm, $vnic, $vmdisk);

# Expat built-in encodings are UTF-8, iso-8859-1 [west european], UTF-16, and US-ASCII
# the remainder are from the various .enc files included with our perl distribution
my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);

my ( $vmName , $elType ) = @ARGV;
my $fileToParse = filetoParse();

if (!($fileToParse eq ''))
{
  if(-r  $fileToParse)
  {
    my $p = new XML::Parser(ErrorContext => 2 ) ;

    $p->setHandlers(Start => \&parseStart,
                         End => \&parseEnd  );
    $p->parsefile($fileToParse) ;
     
    if($@)
    {
        foreach $_ (@encTable)
        {
            %vms = () ;
            %vnics = () ;

            eval '$p->parsefile($fileToParse, ProtocolEncoding => $_)' ;

            if(!$@)
            {
                last;
            }

        }
    }
    if($@)
    {
        print "$fileToParse failed Validation\n";
        $parseFailure = 1;
        print STDERR "em_error=$fileToParse parse failed.\n";
        exit 0;
    }

    foreach $vm(sort keys %vms)
    {
        if($vms{$vm}->{_GUEST_UUID} eq $vmName)
        {

            $vmToParse = $vm;
        }
    }

    if($elType eq "VMCONFIG")
    {
        my $ref = $vms{$vmToParse};
        print $EM_RESULT .
              (defined($ref->{_BOOT_TYPE}) ? $ref->{_BOOT_TYPE} : "" ) . "|".
              (defined($ref->{_CPU_COUNT}) ? $ref->{_CPU_COUNT} : "" ) . "|".
              (defined($ref->{_CPU_PRIORITY}) ? $ref->{_CPU_PRIORITY} : "" ) . "|".
              (defined($ref->{_CPU_UTL_CAP}) ? $ref->{_CPU_UTL_CAP} : "" ) . "|".
              (defined($ref->{_DOMAIN_TYPE}) ? $ref->{_DOMAIN_TYPE} : "" ) . "|".
              (defined($ref->{_HA_FLAG}) ? $ref->{_HA_FLAG} : "" ) . "|".
              (defined($ref->{_MEM_REQD_MB}) ? $ref->{_MEM_REQD_MB} : "" ) . "|".
              (defined($ref->{_MOUSE_TYPE}) ? $ref->{_MOUSE_TYPE} : "" ) . "|".
              (defined($ref->{_REBOOT_LIMIT}) ? $ref->{_REBOOT_LIMIT} : "" ) . "|".
              (defined($ref->{_ALLOC_MEM_MB}) ? $ref->{_ALLOC_MEM_MB} : "" ) . "|".
              (defined($ref->{_ALLOC_DISK_MB}) ? $ref->{_ALLOC_DISK_MB} : "" ) . "\n";
    }
    elsif($elType eq "VMCONFIGSW")
    {
        my $ref = $vms{$vmToParse};
        print $EM_RESULT .
              (defined($ref->{_OS_NAME}) ? $ref->{_OS_NAME} : "" ) . "|".
              (defined($ref->{_KERNEL_VER}) ? $ref->{_KERNEL_VER} : "" ) . "|".
              (defined($ref->{_USE_VS_TOOLS}) ? $ref->{_USE_VS_TOOLS} : "" ) . "|".
              (defined($ref->{_VS_TOOLS_OS}) ? $ref->{_VS_TOOLS_OS} : "" ) . "|".
              (defined($ref->{_VS_TOOLS_VER}) ? $ref->{_VS_TOOLS_VER} : "" ) . "|". 
              (defined($ref->{_GUEST_UUID}) ? $ref->{_GUEST_UUID} : "" ) . "|".
              (defined($ref->{_VS_UUID}) ? $ref->{_VS_UUID} : "" ) . "|".
              (defined($ref->{_VSP_UUID}) ? $ref->{_VSP_UUID} : "" ) . "|".
              (defined($ref->{_OVMM_UUID}) ? $ref->{_OVMM_UUID} : "" ) . "|".
              (defined($ref->{_OVM_DISPLAY_NAME}) ? $ref->{_OVM_DISPLAY_NAME} : "" ) . "\n";
           
    }
    elsif($elType eq "VMVNIC")
    {
        foreach $vnic(sort keys %vnics)
        {
            my $ref = $vnics{$vnic};
            if(($ref->{_VM}) == $vmToParse)
            {
                print $EM_RESULT .
                      (defined($ref->{_MAC_ADDRESS}) ? $ref->{_MAC_ADDRESS} : "" ) . "|".
                      (defined($ref->{_ETH_NET}) ? $ref->{_ETH_NET} : "" ) . "|".
                      (defined($ref->{_IP_ADDRESS}) ? $ref->{_IP_ADDRESS} : "" ) . "|".
                      (defined($ref->{ADDRESS_TYPE}) ? $ref->{ADDRESS_TYPE} : "" ) . "\n";
            }
        }
    }
    elsif($elType eq "VMDISK")
    {
        foreach $vmdisk(sort keys %vmdisks)
        {
            my $ref = $vmdisks{$vmdisk};
            if(($ref->{_VM}) == $vmToParse)
            {
                print $EM_RESULT .
                      (defined($ref->{_UUID}) ? $ref->{_UUID} : "" ) . "|".
                      (defined($ref->{_NAME}) ? $ref->{_NAME} : "" ) . "|".
                      (defined($ref->{_SIZE_MB}) ? $ref->{_SIZE_MB} : "" ) . "|".
                      (defined($ref->{_TYPE}) ? $ref->{_TYPE} : "" ) . "|".
                      (defined($ref->{_SHAREABLE}) ? $ref->{_SHAREABLE} : "" ) . "|".
                      (defined($ref->{_REPO}) ? $ref->{_REPO} : "" ) . "|".
                      (defined($ref->{_DISK_MODE}) ? $ref->{_DISK_MODE} : "" ) . "\n";
            }
        }
    }
    else
    {
        print STDERR "em_error=Invalid Tag Passed.\n";
        exit 0;
    }
  }
  else
  {
    print "em_warning=$fileToParse exists but does not have read permissions \n";
    exit 0;
  }
}

## File Location can be any of $BEA_HOME/state/virtualdata.xml
## or $OVM_CFG_HOME/virtualdata.xml or /tmp/virtualdata.xml
## We look for these files in this order 
## $OVM_CFG_HOME dir , then $BEA_HOME and then /tmp
## This is being done to have flexibility of file location where OVM dumps the data and OCM finds it.

sub filetoParse
{
    my $fileName = File::Spec->catfile($beaHome , "state", "virtualdata.xml");
    my $fileNameOvm = File::Spec->catfile($ovmcfgHome, "virtualdata.xml");
    my $fileNameTmp = File::Spec->catfile("" , "tmp", "virtualdata.xml");

    if(-e $fileNameOvm)
    { 
        return $fileNameOvm;
    } 
    elsif(-e $fileName)
    {
        return  $fileName;
    } 
    elsif(-e $fileNameTmp) 
    { 
        return  $fileNameTmp;
    }
    return '';
}

sub parseStart
{
    my $p = shift;
    my $el = shift;


    if($el eq "virtual-machines")
    {
        $vmsTag = "T";
    }
    elsif($el eq "virtual-machine")
    {
        $vmTag = "T";
        if($vmsTag eq "T")
        {
            my $vmNew = $vms{$vmFound};
            if(not defined($vmNew))
            {
                $vms{$vmFound} = $vmNew = new Guest;
                $vmFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "boot-type")
                {
                    $vmNew->{_BOOT_TYPE} = $val;
                }
                elsif($att eq "cpu-count")
                {
                    $vmNew->{_CPU_COUNT} = $val;
                }
                elsif($att eq "cpu-priority")
                {
                    $vmNew->{_CPU_PRIORITY} = $val;
                }
                elsif($att eq "cpu-utl-cap")
                {
                    $vmNew->{_CPU_UTL_CAP} = $val;
                }
                elsif($att eq "domain-type")
                {
                    $vmNew->{_DOMAIN_TYPE} = $val;
                }
                elsif($att eq "ha-flag")
                {
                    $vmNew->{_HA_FLAG} = $val;
                } 
                elsif($att eq "mem-reqd-mb")
                {
                    $vmNew->{_MEM_REQD_MB} = $val;
                }
                elsif($att eq "mouse-type")
                {
                    $vmNew->{_MOUSE_TYPE} = $val;
                }
                elsif($att eq "reboot-limit")
                {
                    $vmNew->{_REBOOT_LIMIT} = $val;
                }
                elsif($att eq "alloc-mem-mb")
                {
                    $vmNew->{_ALLOC_MEM_MB} = $val;
                }
                elsif($att eq "alloc-disk-mb")
                {
                    $vmNew->{_ALLOC_DISK_MB} = $val;
                }
                elsif($att eq "os-name")
                {
                    $vmNew->{_OS_NAME} = $val;
                }
                elsif($att eq "kernel-ver")
                {
                    $vmNew->{_KERNEL_VER} = $val;
                }
                elsif($att eq "use-vs-tools")
                {
                    $vmNew->{_USE_VS_TOOLS} = $val;
                }
                elsif($att eq "vs-tools-os")
                {
                    $vmNew->{_VS_TOOLS_OS} = $val;
                }
                elsif($att eq "vs-tools-ver")
                {
                    $vmNew->{_VS_TOOLS_VER} = $val;
                }
                elsif($att eq "guest-uuid")
                {
                    $vmNew->{_GUEST_UUID} = $val;
                }
                elsif($att eq "vs-uuid")
                {
                    $vmNew->{_VS_UUID} = $val;
                }
                elsif($att eq "vsp-uuid")
                {
                    $vmNew->{_VSP_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $vmNew->{_OVMM_UUID} = $val;
                }
                elsif($att eq "ovm-display-name")
                {
                    $vmNew->{_OVM_DISPLAY_NAME} = $val;
                }
            }
        }   
    }
    elsif($el eq "virtual-nics")
    {
        $vnicsTag = "T";
    }
    elsif($el eq "virtual-nic")
    {
        $vnicTag = "T";
        if(($vmsTag eq "T") && ($vmTag eq "T") && ($vnicsTag eq "T"))
        {
            my $vnicNew = $vnics{$vnicFound};
            if(not defined($vnicNew))
            { 
                $vnics{$vnicFound} = $vnicNew = new VNIC;
                $vnicFound++
            }
            $vnicNew->{_VM} = $vmFound -1 ;
            my($att, $val);
            while(@_) 
            { 
                $att = shift;
                $val = shift;
                if($att eq "eth-net")
                { 
                    $vnicNew->{_ETH_NET} = $val;
                } 
                elsif($att eq "mac-address")
                {
                    $vnicNew->{_MAC_ADDRESS} = $val;
                }
                elsif($att eq "ip-address")
                {
                    $vnicNew->{_IP_ADDRESS} = $val;
                }
                elsif($att eq "address-type")
                {
                    $vnicNew->{ADDRESS_TYPE} = $val;
                }
            }
        }
    }
    elsif($el eq "vdisks")
    {
        $vmdisksTag="T";
    }
    elsif($el eq "vdisk")
    {
        $vmdiskTag = "T";
        if(($vmsTag eq "T") && ($vmTag eq "T") && ($vmdisksTag eq "T"))
        {
            my $vdiskNew = $vmdisks{$vmdiskFound};
            if(not defined($vdiskNew))
            {
                $vmdisks{$vmdiskFound} = $vdiskNew = new VDISK;
                $vmdiskFound++
            }
            $vdiskNew->{_VM} = $vmFound -1 ;
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "uuid")
                {
                    $vdiskNew->{_UUID} = $val;
                }
                elsif($att eq "name")
                {
                    $vdiskNew->{_NAME} = $val;
                }
                elsif($att eq "size-mb")
                {
                    $vdiskNew->{_SIZE_MB} = $val;
                }
                elsif($att eq "type")
                {
                    $vdiskNew->{_TYPE} = $val;
                }
                elsif($att eq "shareable")
                {
                    $vdiskNew->{_SHAREABLE} = $val;
                }
                elsif($att eq "repo")
                {
                    $vdiskNew->{_REPO} = $val;
                }
                elsif($att eq "disk-mode")
                {
                    $vdiskNew->{_DISK_MODE} = $val;
                }
            }
        }
    }
}

sub parseEnd
{
    my $p = shift;
    my $el = shift ;

    if($el eq "virtual-machines")
    {
        $vmsTag = "F";
    }
    elsif($el eq "virtual-machine")
    {
        $vmTag ="F";

    }
    elsif($el eq "virtual-nics")
    {
        $vnicsTag ="F";
    }
    elsif($el eq "virtual-nic")
    {
        $vnicTag ="F";
    }
    elsif($el eq "vdisks")
    {
        $vmdisksTag ="F";
    }
    elsif($el eq "vdisk")
    {
        $vmdiskTag ="F";
    }

}

package Guest;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}
 

package VNIC;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package VDISK;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

 
