#!/usr/local/bin/perl
# 
# $Header: empp/emvt/plugin_dist/agent/scripts/ServerParser.pl /main/4 2011/07/25 05:32:47 saukumar Exp $
#
# ServerParser.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ServerParser.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    saukumar    07/23/11 - repository-name to repository
#    chkaushi    04/19/11 - Changing tag names for repository and fileserver
#    chkaushi    03/22/11 - Parses OVM Virtual Server
#    chkaushi    03/22/11 - Creation
#

use strict;
use warnings;
use XML::Parser;
use File::Spec;

package VSParser;

##require 'emd_common.pl'; 

## mandatory arguments
my $beaHome = $ENV{BEA_HOME};
my $ovmcfgHome = $ENV{OVM_CFG_HOME};

## Hashes to store various Metric Data

my %servers = () ;
my %processors = () ;
my %hwConfigs = () ;
my %swConfigs = () ; 
my %opticalDisks = (); 
my %servAttributes = ();
my %fsMounts = ();
my %hypervisors = (); 
my %networkPorts = () ;
my %repositories = ();
my %fileservers = ();

## Tags of xml 

my $swConfigTag = "F";
my $hwConfigTag = "F" ;
my $serverTag = "F";
my $serversTag = "F" ;
my $processorsTag = "F";
my $processorTag = "F";
my $opticalDiskTag = "F";
my $attributesTag = "F"; 
my $fsMountTag = "F" ;
my $hypervisorTag = "F";
my $fsMountsTag = "F";
my $opticalDisksTag = "F";
my $networkPortsTag = "F";
my $networkPortTag = "F";
my $fileServersTag = "F";
my $fileServerTag = "F";
my $repositoriesTag = "F";
my $repositoryTag = "F";

## Counts

my $serverFound = 0 ;
my $processorsFound = 0;
my $swConfigFound = 0;
my $hwConfigFound = 0;
my $hypervisorsFound = 0;
my $fsMountsFound = 0;
my $opticalDisksFound = 0;
my $networkPortsFound = 0;
my $repositoriesFound = 0;
my $fileserversFound = 0 ;

my $EM_RESULT="em_result=";

my $parseFailure=0;

my $serverToParse;

# Expat built-in encodings are UTF-8, iso-8859-1 [west european], UTF-16, and US-ASCII
# the remainder are from the various .enc files included with our perl distribution
my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);


my ( $serverName , $elType ) = @ARGV;
my $swConfig;
my $fsMount;
my $hwConfig;
my $hypervisor;
my $opticalDisk;
my $processor;
my $server;
my $networkPort;
my $fileserver;
my $repository;

my $fileToParse = filetoParse();

if (!($fileToParse eq ''))
{	
  if(-r  $fileToParse)
  {    
    my $p = new XML::Parser(ErrorContext => 2 ) ;
 
    $p->setHandlers(Start => \&parseStart,
			 End => \&parseEnd  );
    $p->parsefile($fileToParse) ;

    if($@)
    {
        foreach $_ (@encTable)
	{
	    %servers = () ;
	    %processors = ();
	    %hwConfigs = () ;
	    %swConfigs = ();
	    %opticalDisks = () ;
	    %servAttributes = ();
	    %fsMounts = () ;
	    %hypervisors = ();
            %networkPorts = ();
            %fileservers = ();
            %repositories = ();

            eval '$p->parsefile($fileToParse, ProtocolEncoding => $_)' ;
			
	    if(!$@)
	    {
	        last;
	    }

        }   
    }   
    if($@)
    {
        print "$fileToParse failed Validation\n";
	$parseFailure = 1;
        print STDERR "em_error=$fileToParse parse failed.\n";
        exit 0;
    }

    foreach $server (sort keys %servers)
    {
        if($servers{$server}->{_UUID} eq $serverName)
	{
	    $serverToParse = $server;
	}
    }

    if($elType eq "SERVER") 
    { 
        my $ref = $servers{$serverToParse};
	print $EM_RESULT .
              (defined($ref->{_ATTRIBUTES}->{_IS_MASTER_SERVER}) ? $ref->{_ATTRIBUTES}->{_IS_MASTER_SERVER} : "" ) . "\n";
    } 
    elsif($elType eq "HYPERVISOR")
    { 
        foreach $hypervisor(sort keys %hypervisors)
        { 
            my $ref = $hypervisors{$hypervisor};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
                print $EM_RESULT .
                      (defined($ref->{_VERSION}) ? $ref->{_VERSION} : "" ) . "|" .
                      (defined($ref->{_HVM_CAPABLE}) ? $ref->{_HVM_CAPABLE} : "" ) . "|" . 
                      (defined($ref->{_CAPABILITY}) ? $ref->{_CAPABILITY} : "" ) . "\n";
	    }
        } 
    } 
    elsif($elType eq "SERVERCONFIGSW")
    { 
        foreach $swConfig(sort keys %swConfigs)
        { 
            my $ref = $swConfigs{$swConfig};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
	        my $servref = $servers{$serverToParse};
                print $EM_RESULT .
		      (defined($ref->{_AGENT_PORT}) ? $ref->{_AGENT_PORT} : "" ) . "|" .
                      (defined($ref->{_AGENT_VERSION}) ? $ref->{_AGENT_VERSION} : "" ) . "|" .
	              (defined($ref->{_OVM_VERSION}) ? $ref->{_OVM_VERSION} : "" ) . "|" .
                      (defined($ref->{_CONSOLE_SHELL_FLAG}) ? $ref->{_CONSOLE_SHELL_FLAG} : "" ) . "|".
                      (defined($ref->{_DISABLE_USB_FLAG}) ? $ref->{_DISABLE_USB_FLAG} : "" ) . "|".
	              (defined($ref->{_HALT_ON_ERROR_FLAG}) ? $ref->{_HALT_ON_ERROR_FLAG} : "" ) . "|".
        	      (defined($ref->{_KERNEL_RELEASE}) ? $ref->{_KERNEL_RELEASE} : "" ) . "|".
                      (defined($ref->{_KERNEL_VERSION}) ? $ref->{_KERNEL_VERSION} : "" ) . "|".
	              (defined($ref->{_ASSOC_CLUSTER}) ? $ref->{_ASSOC_CLUSTER} : "" ) . "|".
        	      (defined($ref->{_PROTECTED_FLAG}) ? $ref->{_PROTECTED_FLAG} : "" ) . "|".
                      (defined($ref->{_PYTHON_BIND_VERSION}) ? $ref->{_PYTHON_BIND_VERSION} : "" ) . "|".
                      (defined($ref->{_RPM_VERSION}) ? $ref->{_RPM_VERSION} : "" ) . "|".
                      (defined($servref->{_UUID}) ? $servref->{_UUID} : "" ) . "|".
                      (defined($servref->{_VSP_UUID}) ? $servref->{_VSP_UUID} : "" ) . "|".
                      (defined($servref->{_OVMM_UUID}) ? $servref->{_OVMM_UUID} : "" ) . "|".
                      (defined($servref->{_OVM_DISPLAY_NAME}) ? $servref->{_OVM_DISPLAY_NAME} : "" ) . "\n";
	    }
        } 
    } 
    elsif($elType eq "SERVERCONFIGHW")
    { 
        foreach $hwConfig(sort keys %hwConfigs)
        {
            my $ref = $hwConfigs{$hwConfig};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
	        print $EM_RESULT .
        	      (defined($ref->{_VENDOR}) ? $ref->{_VENDOR} : "" ) . "|" .
                      (defined($ref->{_PROCESSOR_SPEED}) ? $ref->{_PROCESSOR_SPEED} : "" ) . "|" .
                      (defined($ref->{_PROCESSOR_TYPE}) ? $ref->{_PROCESSOR_TYPE} : "" ) . "|" .
	              (defined($ref->{_NO_EXECUTE_FLAG}) ? $ref->{_NO_EXECUTE_FLAG} : "" ) . "|" .
        	      (defined($ref->{_NUM_POP_PROC_SOCKS}) ? $ref->{_NUM_POP_PROC_SOCKS} : "" ) . "|" .
                      (defined($ref->{_NUM_PROC_SOCKS}) ? $ref->{_NUM_PROC_SOCKS} : "" ) . "|" .
                      (defined($ref->{_NUM_THREADS_PER_CORE}) ? $ref->{_NUM_THREADS_PER_CORE} : "" ) . "|" .
	              (defined($ref->{_BIOS_RELEASE_DATE}) ? $ref->{_BIOS_RELEASE_DATE} : "" ) . "|" .
        	      (defined($ref->{_BIOS_VENDOR}) ? $ref->{_BIOS_VENDOR} : "" ) . "|" .
                      (defined($ref->{_BIOS_VERSION}) ? $ref->{_BIOS_VERSION} : "" ) . "|" .
                      (defined($ref->{_MEMORY_MB}) ? $ref->{_MEMORY_MB} : "" ) . "|" .
                      (defined($ref->{_AVAILABLE_MEMORY_MB}) ? $ref->{_AVAILABLE_MEMORY_MB} : "" ) . "|" .
                      (defined($ref->{_MEMORY_OVERHEAD_MB}) ? $ref->{_MEMORY_OVERHEAD_MB} : "" ) . "|" .
                      (defined($ref->{_USABLE_MEMORY_MB}) ? $ref->{_USABLE_MEMORY_MB} : "" ) . "|" .
                      (defined($ref->{_SWAP_SPACE_MB}) ? $ref->{_SWAP_SPACE_MB} : "" ) . "|".
                      (defined($ref->{_ADDR_LENGTH_BITS}) ? $ref->{_ADDR_LENGTH_BITS} : "" ) . "|".
	              (defined($ref->{_LOCAL_DISK_GB}) ? $ref->{_LOCAL_DISK_GB} : "" ) . "|" .
        	      (defined($ref->{_ENABLED_PROCESSORS}) ? $ref->{_ENABLED_PROCESSORS} : "" ) . "|" .
                      (defined($ref->{_ENABLED_CORES}) ? $ref->{_ENABLED_CORES} : "" ) . "|" .
                      (defined($ref->{_NUM_VCPUS}) ? $ref->{_NUM_VCPUS} : "" ) . "\n";
	    }
        }
    }
    elsif($elType eq "PROCESSORS")
    {
        foreach $processor(sort keys %processors)
        {
            my $ref = $processors{$processor};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
	        print $EM_RESULT .
        	      (defined($ref->{_PROC_ID}) ?  $ref->{_PROC_ID} : "" ) . "|" .
                      (defined($ref->{_CPU_FAMILY}) ? $ref->{_CPU_FAMILY} : "" ) . "|" .
                      (defined($ref->{_CPU_MODEL}) ? $ref->{_CPU_MODEL} : "" ) . "|" .
	              (defined($ref->{_FAMILY}) ? $ref->{_FAMILY} : "" ) . "|" .
        	      (defined($ref->{_FLAGS}) ? $ref->{_FLAGS} : "" ) . "|" .
                      (defined($ref->{_L1CACHE_KB}) ? $ref->{_L1CACHE_KB} : "" ) . "|" .
                      (defined($ref->{_L2CACHE_KB}) ? $ref->{_L2CACHE_KB} : "" ) . "|" .
	              (defined($ref->{_L3CACHE_KB}) ? $ref->{_L3CACHE_KB} : "" ) . "|" .
        	      (defined($ref->{_MANUFACTURER}) ? $ref->{_MANUFACTURER} : "" ) . "|" .
                      (defined($ref->{_MODEL_NAME}) ? $ref->{_MODEL_NAME} : "" ) . "|" .
                      (defined($ref->{_VENDOR_ID}) ? $ref->{_VENDOR_ID} : "" ) . "\n";
	    }
        }
    }
    elsif($elType eq "FILE_SYSTEM_MOUNTS")
    {
        foreach $fsMount(sort keys %fsMounts)
        {
            my $ref = $fsMounts{$fsMount};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
	        print $EM_RESULT .
                      (defined($ref->{_FILESERVER_UUID}) ? $ref->{_FILESERVER_UUID} : "" ) . "|" .
        	      (defined($ref->{_MOUNT_POINT}) ? $ref->{_MOUNT_POINT} : "" ) . "|" .
                      (defined($ref->{_REMOTE_PATH}) ? $ref->{_REMOTE_PATH} : "" ) . "|" .
                      (defined($ref->{_OPTIONS}) ? $ref->{_OPTIONS} : "" ) . "|" .
                      (defined($ref->{_SIZE}) ? $ref->{_SIZE} : "" ) . "\n";
	    }

        }
    }
    elsif($elType eq "OPTICAL_DISKS")
    {
        $opticalDisksTag = "F";
        foreach $opticalDisk(sort keys %opticalDisks)
        {
            my $ref = $opticalDisks{$opticalDisk};
	    if(($ref->{_SERV}) == $serverToParse)
	    {
	        print $EM_RESULT .
        	      (defined($ref->{_NAME}) ? $ref->{_NAME} : "" ) . "|" .
                      (defined($ref->{_ACTIVATION_FLAG}) ? $ref->{_ACTIVATION_FLAG} : "" ) . "\n";
	    }

        }
    }
    elsif($elType eq "NETWORK_PORTS")
    {
        foreach $networkPort(sort keys %networkPorts)
        {
            my $ref = $networkPorts{$networkPort};
            if(($ref->{_SERV}) == $serverToParse)
            {
                print $EM_RESULT .
                      (defined($ref->{_MAC_ADDRESS}) ? $ref->{_MAC_ADDRESS} : "" ) . "|" .
                      (defined($ref->{_IP_ADDRESS}) ? $ref->{_IP_ADDRESS} : "" ) . "|" .
                      (defined($ref->{_INTERFACE_NAME}) ? $ref->{_INTERFACE_NAME} : "" ) . "|" .
                      (defined($ref->{_MTU}) ? $ref->{_MTU} : "" ) . "|" .
                      (defined($ref->{_BANDWIDTH_MBPS}) ? $ref->{_BANDWIDTH_MBPS} : "" ) . "|" .
                      (defined($ref->{_NETMASK}) ? $ref->{_NETMASK} : "" ) . "|" .
                      (defined($ref->{_ADDRESS_TYPE}) ? $ref->{_ADDRESS_TYPE} : "" ) . "\n";
            }
        }
    }
    elsif($elType eq "FILESERVERS")
    {
        foreach $fileserver (sort keys %fileservers)
        {
            my $ref = $fileservers{$fileserver};
            if(($ref->{_SERV}) == $serverToParse)
            {
                print $EM_RESULT .
                      (defined($ref->{_FILESERVER_UUID}) ? $ref->{_FILESERVER_UUID} : "" ) . "|" .
                      (defined($ref->{_FILESERVER}) ? $ref->{_FILESERVER} : "" ) . "|" .
                      (defined($ref->{_FSNAME}) ? $ref->{_FSNAME} : "" ) . "|" .
                      (defined($ref->{_FSTYPE}) ? $ref->{_FSTYPE} : "" ) . "\n";
            }
        }
    }
    elsif($elType eq "REPOSITORY")
    {
        foreach $repository (sort keys %repositories)
        {
            my $ref = $repositories{$repository};
            if(($ref->{_SERV}) == $serverToParse)
            {
                print $EM_RESULT .
                      (defined($ref->{_FILESERVER_UUID}) ? $ref->{_FILESERVER_UUID} : "" ) . "|" .
                      (defined($ref->{_MOUNT_POINT}) ? $ref->{_MOUNT_POINT} : "" ) . "|" .
                      (defined($ref->{_REPOSITORY_UUID}) ? $ref->{_REPOSITORY_UUID} : "" ) . "|" .
                      (defined($ref->{_REPOSITORY}) ? $ref->{_REPOSITORY} : "" ) . "\n";
            }
        }
    }
    else
    {
        print STDERR "em_error=Invalid Tag Passed.\n";
        exit 0;
    }
  }
  else
  {
    print "em_warning=$fileToParse exists but does not have read permissions \n";
    exit 0;
  }

}	

## File Location can be any of $BEA_HOME/state/virtualdata.xml
## or $OVM_CFG_HOME/virtualdata.xml or /tmp/virtualdata.xml
## We look for these files in this order 
## $OVM_CFG_HOME dir , then $BEA_HOME and then /tmp
## This is being done to have flexibility of file location where OVM dumps the data and OCM finds it.

sub filetoParse
{
    my $fileName = File::Spec->catfile($beaHome , "state", "virtualdata.xml");
    my $fileNameOvm = File::Spec->catfile($ovmcfgHome, "virtualdata.xml");
    my $fileNameTmp = File::Spec->catfile("" , "tmp", "virtualdata.xml");

    if(-e $fileNameOvm)
    {
        return $fileNameOvm;
    }
    elsif(-e $fileName)
    {
        return  $fileName;
    }
    elsif(-e $fileNameTmp)
    {
        return  $fileNameTmp;
    }
    return '';
}

sub parseStart
{
    my $p = shift;
    my $el = shift;

        
    if($el eq "servers")
    {
        $serversTag = "T";
    }
    elsif($el eq "server")
    {
        $serverTag = "T";
        if($serversTag eq "T")
        {
	    my $serv = $servers{$serverFound};
	    if(not defined($serv))
	    {
	        $servers{$serverFound} = $serv = new Server;
	        $serverFound++
	    }
	    my($att, $val);
	    while(@_)
	    {
	        $att = shift;
	        $val = shift;
	        if($att eq "is-master-server")
	        {
	            $serv->{_ATTRIBUTES}->{_IS_MASTER_SERVER} = $val;
	        }
	        elsif($att eq "uuid")
	        {
	            $serv->{_UUID} = $val;
	        }
                elsif($att eq "vsp-uuid")
                {
                    $serv->{_VSP_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $serv->{_OVMM_UUID} = $val;
                }
                elsif($att eq "ovm-display-name")
                {
                    $serv->{_OVM_DISPLAY_NAME} = $val;
                }

	    }
        }
    }
    elsif($el eq "ServerConfigSW")
    {
        $swConfigTag = "T";
        if(($serversTag eq "T") && ($serverTag eq "T"))
        {
	    my $swConfig = $swConfigs{$swConfigFound};
	    if(not defined($swConfig))
	    {
	        $swConfigs{$swConfigFound} = $swConfig = new SWConfig;
	        $swConfigFound++;
	    }
	    $swConfig->{_SERV} = $serverFound -1 ;
	    my($att,$val);
	    while(@_)
	    {
	        $att = shift;
	        $val = shift;
	        if($att eq "ovm-version")
	        {
	            $swConfig->{_OVM_VERSION} = $val;
	        }
	        elsif($att eq "console-shell-flag")
	        {
	            $swConfig->{_CONSOLE_SHELL_FLAG} = $val;
	        }
	        elsif($att eq "kernel-version")
                {
                    $swConfig->{_KERNEL_VERSION} = $val;
                }
 	        elsif($att eq "kernel-release")
                {
                    $swConfig->{_KERNEL_RELEASE} = $val;
                }
	        elsif($att eq "halt-on-error-flag")
	        {
	            $swConfig->{_HALT_ON_ERROR_FLAG} = $val;
	        }
	        elsif($att eq "disable-usb-flag")
                {
                    $swConfig->{_DISABLE_USB_FLAG} = $val;
                }
	        elsif($att eq "agent-port")
                {
                    $swConfig->{_AGENT_PORT} = $val;
                }
	        elsif($att eq "agent-version")
                {
                    $swConfig->{_AGENT_VERSION} = $val;
                }
	        elsif($att eq "assoc-cluster")
	        {
	            $swConfig->{_ASSOC_CLUSTER} = $val;
	        }
	        elsif($att eq "protected-flag")
	        {
	            $swConfig->{_PROTECTED_FLAG} = $val;
	        }
	        elsif($att eq "python-binding-version")
	        {
	            $swConfig->{_PYTHON_BIND_VERSION} = $val;
	        }
	        elsif($att eq "rpm-version")
	        {
	            $swConfig->{_RPM_VERSION} = $val;
                }
	    }
        }
    }
    elsif($el eq "ServerConfigHW")
    {
        $hwConfigTag = "T";
        if(($serversTag eq "T") && ($serverTag eq "T"))
        {
            my $hwConfig = $hwConfigs{$hwConfigFound};
            if(not defined($hwConfig))
            {
                $hwConfigs{$hwConfigFound} = $hwConfig = new HWConfig;
                $hwConfigFound++;
            }
            $hwConfig->{_SERV} = $serverFound -1 ;
            my($att,$val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "processor-speed")
                {
                    $hwConfig->{_PROCESSOR_SPEED} = $val;
                } 
                elsif($att eq "processor-type")
                {
                    $hwConfig->{_PROCESSOR_TYPE} = $val;
                }
                elsif($att eq "no-execute-flag")
                {
                    $hwConfig->{_NO_EXECUTE_FLAG} = $val;
                }
                elsif($att eq "num-pop-proc-sockets")
                {
                    $hwConfig->{_NUM_POP_PROC_SOCKS} = $val;
                }
                elsif($att eq "num-proc-sockets")
                {
                    $hwConfig->{_NUM_PROC_SOCKS} = $val;
                }
                elsif($att eq "num-threads-per-core")
                {
                    $hwConfig->{_NUM_THREADS_PER_CORE} = $val;
                }
                elsif($att eq "memory-mb")
                {
                    $hwConfig->{_MEMORY_MB} = $val;
                }
                elsif($att eq "memory-overhead-mb")
                {
                    $hwConfig->{_MEMORY_OVERHEAD_MB} = $val;
                }
                elsif($att eq "usable-memory-mb")
                {
                    $hwConfig->{_USABLE_MEMORY_MB} = $val;
                }
                elsif($att eq "available-memory-mb")
                {
                    $hwConfig->{_AVAILABLE_MEMORY_MB} = $val;
                }
                elsif($att eq "swap-space-mb")
                {
                    $hwConfig->{_SWAP_SPACE_MB} = $val;
                }
                elsif($att eq "addr-length-bits")
                {
                    $hwConfig->{_ADDR_LENGTH_BITS} = $val;
                }
                elsif($att eq "local-disk-gb")
                {
                    $hwConfig->{_LOCAL_DISK_GB} = $val;
                }
                elsif($att eq "enabled-processors")
                {
                    $hwConfig->{_ENABLED_PROCESSORS} = $val;
                }
                elsif($att eq "enabled-cores")
                {
                    $hwConfig->{_ENABLED_CORES} = $val;
                }
                elsif($att eq "num-vcpus")
                { 
                    $hwConfig->{_NUM_VCPUS} = $val;
                }
	        elsif($att eq "bios-release-date")
                {
                    $hwConfig->{_BIOS_RELEASE_DATE} = $val;
                }
	        elsif($att eq "bios-vendor")
                {
                    $hwConfig->{_BIOS_VENDOR} = $val;
                }
	        elsif($att eq "bios-version")
                {
                    $hwConfig->{_BIOS_VERSION} = $val;
                }
            }
        }
    }
    elsif($el eq "processors")
    {
        $processorsTag = "T";
    }
    elsif($el eq "processor")
    {
	$processorTag = "T";
        if(($processorsTag eq "T") && ($serversTag eq "T") && ($serverTag eq "T"))
        {
	    my $processor = $processors{$processorsFound};
	    if(not defined($processor))
	    {
	        $processors{$processorsFound} = $processor = new Processor;
	        $processorsFound++;
	    }
	    $processor->{_SERV} = $serverFound - 1;
	    my ($att,$val);
	    while(@_)
	    {
	        $att = shift ;
	        $val = shift;
	        if($att eq "cpu-family")
	        {
		    $processor->{_CPU_FAMILY} = $val;
	        }
	        elsif($att eq "cpu-model")
                {
                    $processor->{_CPU_MODEL} = $val;
                }
	        elsif($att eq "proc-id")
                {
                    $processor->{_PROC_ID} = $val;
                }
	        elsif($att eq "l1-cache-kb")
                {
                    $processor->{_L1CACHE_KB} = $val;
                }
	        elsif($att eq "l2-cache-kb")
                {
                    $processor->{_L2CACHE_KB} = $val;
                }
	        elsif($att eq "l3-cache-kb")
                {
                    $processor->{_L3CACHE_KB} = $val;
                }
	        elsif($att eq "family")
                {
                    $processor->{_FAMILY} = $val;
                }
	        elsif($att eq "flags")
                {
                    $processor->{_FLAGS} = $val;
                }
	        elsif($att eq "manufacturer")
                {
                    $processor->{_MANUFACTURER} = $val;
                } 
	        elsif($att eq "model-name")
                { 
                    $processor->{_MODEL_NAME} = $val;
                }
	        elsif($att eq "vendor-id")
                {
                    $processor->{_VENDOR_ID} = $val;
                }
            }
        }
    }
    elsif($el eq "hypervisor")
    {
        $hypervisorTag = "T";
        if(($serversTag eq "T") && ($serverTag eq "T"))
        {
	    my $hypervisor = $hypervisors{$hypervisorsFound};
	    if(not defined($hypervisor))
	    {
	        $hypervisors{$hypervisorsFound} = $hypervisor = new Hypervisor;
	        $hypervisorsFound++;
	    }
	    $hypervisor->{_SERV} = $serverFound - 1;
	    my($att,$val);
	    while(@_)
	    {
	        $att = shift;
	        $val = shift;
	        if($att eq "hvm-capable")
	        {
	            $hypervisor->{_HVM_CAPABLE} = $val;
	        }
	        elsif($att eq "version") 
                { 
                    $hypervisor->{_VERSION} = $val;
                }
                elsif($att eq "capability")
                {
                    $hypervisor->{_CAPABILITY} = $val;
                }

	    }
        }
    }
    elsif($el eq "file-system-mounts")
    {
	$fsMountsTag = "T";
    }
    elsif($el eq "file-system-mount")
    {
	$fsMountTag = "T";
	if(($fsMountsTag eq "T") && ($serversTag eq "T") && ($serverTag eq "T"))
	{
	    my $fsMount = $fsMounts{$fsMountsFound};
	    if(not defined($fsMount))
	    {
		$fsMounts{$fsMountsFound} = $fsMount = new FSMount;
		$fsMountsFound++;
	    }
	    $fsMount->{_SERV} = $serverFound-1;
	    my ($att, $val);
	    while(@_)
	    {
	        $att = shift;
		$val = shift;
                if($att eq "fileserver-uuid")
                {
                    $fsMount->{_FILESERVER_UUID} = $val;
                }
		if($att eq "mount-point")
		{
		    $fsMount->{_MOUNT_POINT} = $val;
		}
		elsif($att eq "remote-path")
		{
		    $fsMount->{_REMOTE_PATH} = $val;
		}
		elsif($att eq "size")
		{
		    $fsMount->{_SIZE} = $val;
		}
		elsif($att eq "options")
		{
		    $fsMount->{_OPTIONS} = $val;
		}
	    }
	}
    }
    elsif($el eq "optical-disks")
    {
	$opticalDisksTag = "T";
    }
    elsif($el eq "optical-disk")
    {
	$opticalDiskTag = "T";
	if(($opticalDisksTag eq "T") && ($serversTag eq "T") && ($serverTag eq "T"))
	{
	    my $opticalDisk = $opticalDisks{$opticalDisksFound};
	    if(not defined($opticalDisk))
	    {
	        $opticalDisks{$opticalDisksFound} = $opticalDisk = new OpticalDisk; 
		$opticalDisksFound++;
	    }
	    $opticalDisk->{_SERV} = $serverFound-1;
	    my ($att, $val);
	    while(@_)
	    {
	        $att = shift;
		$val = shift;
		if($att eq "name")
		{
		    $opticalDisk->{_NAME} = $val;
		}
		elsif($att eq "activation-flag")
		{
		    $opticalDisk->{_ACTIVATION_FLAG} = $val;
		}
	    }
	}
    }
    elsif($el eq "repositories")
    {
        $repositoriesTag = "T";
    }
    elsif($el eq "repository")
    {
        $repositoryTag = "T";
        if(($repositoriesTag eq "T") && ($serversTag eq "T") && ($serverTag eq "T"))
        {
            my $repository = $repositories{$repositoriesFound};
            if(not defined($repository))
            {
                $repositories{$repositoriesFound} = $repository = new Repository;
                $repositoriesFound++;
            }
            $repository->{_SERV} = $serverFound-1;
            my ($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "fileserver-uuid")
                {
                    $repository->{_FILESERVER_UUID} = $val;
                }
                elsif($att eq "mount-point")
                {
                    $repository->{_MOUNT_POINT} = $val;
                }
                elsif($att eq "repository-uuid")
                {
                    $repository->{_REPOSITORY_UUID} = $val;
                }
                elsif($att eq "repository")
                {
                    $repository->{_REPOSITORY} = $val;
                }
            }
        }
    }
    elsif($el eq "fileservers")
    {
        $fileServersTag = "T";
    }
    elsif($el eq "fileserver")
    {
        $fileServerTag = "T";
        if(($fileServersTag eq "T") && ($serversTag eq "T") && ($serverTag eq "T"))
        {
            my $fileserver = $fileservers{$fileserversFound};
            if(not defined($fileserver))
            {
                $fileservers{$fileserversFound} = $fileserver = new FileServer;
                $fileserversFound++;
            }
            $fileserver->{_SERV} = $serverFound-1;
            my ($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "fileserver-uuid")
                {
                    $fileserver->{_FILESERVER_UUID} = $val;
                }
                elsif($att eq "fileserver")
                {
                    $fileserver->{_FILESERVER} = $val;
                }
                elsif($att eq "fsname")
                {
                    $fileserver->{_FSNAME} = $val;
                }
                elsif($att eq "fstype")
                {
                    $fileserver->{_FSTYPE} = $val;
                }
            } 
        }
    }
    elsif($el eq "network-ports")
    {
        $networkPortsTag = "T";
    }
    elsif($el eq "network-port")
    {
        $networkPortTag = "T";
        if($networkPortsTag eq "T")
        {
            my $networkPort = $networkPorts{$networkPortsFound};
            if(not defined($networkPort))
            {
                $networkPorts{$networkPortsFound} = $networkPort = new NetworkPort;
                $opticalDisksFound++;
            }
            $networkPort->{_SERV} = $serverFound-1;
            my ($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "mac-address")
                {
                    $networkPort->{_MAC_ADDRESS} = $val;
                }
                elsif($att eq "ip-address")
                {
                    $networkPort->{_IP_ADDRESS} = $val;
                }
                elsif($att eq "interface-name")
                {
                    $networkPort->{_INTERFACE_NAME} = $val;
                }
                elsif($att eq "mtu")
                {
                    $networkPort->{_MTU} = $val;
                }
		elsif($att eq "bandwidth-mbps")
                {
                    $networkPort->{_BANDWIDTH_MBPS} = $val;
                }
		elsif($att eq "netmask")
                {
                    $networkPort->{_NETMASK} = $val;
                }
		elsif($att eq "address-type")
                {
                    $networkPort->{_ADDRESS_TYPE} = $val;
                }
            }
        }
    }
}

sub parseEnd
{
    my $p = shift;
    my $el = shift ;
	
    if($el eq "servers")
    {
        $serversTag = "F";
    }
    elsif($el eq "server")
    {   
        $serverTag ="F";
    }
    elsif($el eq "hypervisor")
    {
        $hypervisorTag = "F";
    }
    elsif($el eq "ServerConfigSW")
    {
        $swConfigTag = "F" ;
    }
    elsif($el eq "ServerConfigHW")
    {
        $hwConfigTag = "F" ;
    }
    elsif($el eq "processors")
    {
        $processorsTag = "F";
    }
    elsif($el eq "processor")
    {
        $processorTag = "F";
    }
    elsif($el eq "file-system-mounts")
    {
        $fsMountsTag = "F";
    }
    elsif($el eq "file-system-mount")
    {
        $fsMountTag = "F";
    }
    elsif($el eq "optical-disks")	
    {
        $opticalDisksTag = "F";
    }
    elsif($el eq "optical-disk")
    {
        $opticalDiskTag = "F" ;
    }  
    elsif($el eq "repositories")
    {
        $repositoriesTag = "F";
    }
    elsif($el eq "repository")
    {
        $repositoryTag = "F" ;
    }
    elsif($el eq "fileservers")
    {
        $fileServersTag = "F";
    }
    elsif($el eq "fileserver")
    {
        $fileServerTag = "F" ;
    }
    elsif($el eq "network-ports")
    {
        $networkPortsTag = "F" ; 
    }
    elsif($el eq "network-port")
    {
        $networkPortTag = "F" ; 
    }
 
}



package Hypervisor;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package Processor;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package Server;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package SWConfig;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package HWConfig;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}


package Capability;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}


package FSMount;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package OpticalDisk;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package Repository;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

package FileServer;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}


package NetworkPort;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

