#!/usr/local/bin/perl
# 
# $Header: empp/emvt/plugin_dist/agent/scripts/ZoneParser.pl /main/2 2011/07/20 07:02:25 sasinsin Exp $
#
# ZoneParser.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ZoneParser.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    chkaushi    03/22/11 - Parses OVM Zone
#    chkaushi    03/22/11 - Creation
#
 
use strict;
use warnings;
use XML::Parser;
use File::Spec;
package VSParser;
##require 'emd_common.pl';

## mandatory arguments
my $beaHome = $ENV{BEA_HOME};
my $ovmcfgHome = $ENV{OVM_CFG_HOME};

my %zones = () ;

my $zonesTag = "F";
my $zoneTag = "F";


my $EM_RESULT="em_result=";
my $parseFailure=0;

my $zoneToParse;
my $zone;

my $zoneFound= 0 ;

# Expat built-in encodings are UTF-8, iso-8859-1 [west european], UTF-16, and US-ASCII
# the remainder are from the various .enc files included with our perl distribution
my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);

my ( $zoneName , $elType ) = @ARGV;
my $fileToParse = filetoParse();

if (!($fileToParse eq ''))
{
  if(-r  $fileToParse)
  {
    my $p = new XML::Parser(ErrorContext => 2 ) ;

    $p->setHandlers(Start => \&parseStart,
                         End => \&parseEnd  );
    $p->parsefile($fileToParse) ;

    if($@)
    {
        foreach $_ (@encTable)
        {
            %zones = () ;

            eval '$p->parsefile($fileToParse, ProtocolEncoding => $_)' ;

            if(!$@)
            {
                last;
            }

        }
    }
    if($@)
    {
        print "$fileToParse failed Validation\n";
        $parseFailure = 1;
        print STDERR "em_error=$fileToParse parse failed.\n";
        exit 0;
    }
    foreach $zone(sort keys %zones)
    {
        if($zones{$zone}->{_ZONE_UUID} eq $zoneName)
        {

            $zoneToParse = $zone;
        }
    }

    if($elType eq "ZONE")
    {
        my $ref = $zones{$zoneToParse};
        print $EM_RESULT .
              (defined($ref->{_TOTAL_MEMORY_MB}) ? $ref->{_TOTAL_MEMORY_MB} : "" ) . "|".
              (defined($ref->{_TOTAL_DISKSPACE_MB}) ? $ref->{_TOTAL_DISKSPACE_MB} : "" ) . "|".
              (defined($ref->{_TOTAL_PHYSICAL_CPUS}) ? $ref->{_TOTAL_PHYSICAL_CPUS} : "" ) . "|".
              (defined($ref->{_TOTAL_NICS}) ? $ref->{_TOTAL_NICS} : "" ) . "|".
              (defined($ref->{_ZONE_UUID}) ? $ref->{_ZONE_UUID} : "" ) . "|".
              (defined($ref->{_OVMM_UUID}) ? $ref->{_OVMM_UUID} : "" ) . "|".
              (defined($ref->{_OVM_DISPLAY_NAME}) ? $ref->{_OVM_DISPLAY_NAME} : "" ) . "\n";
    }
    else
    {
        print STDERR "em_error=Invalid Tag Passed.\n";
        exit 0;
    }
  }
  else
  {
    print "em_warning=$fileToParse exists but does not have read permissions \n";
    exit 0;
  }

}

## File Location can be any of $BEA_HOME/state/virtualdata.xml
## or $OVM_CFG_HOME/virtualdata.xml or /tmp/virtualdata.xml
## We look for these files in this order 
## $OVM_CFG_HOME dir , then $BEA_HOME and then /tmp
## This is being done to have flexibility of file location where OVM dumps the data and OCM finds it.

sub filetoParse
{
    my $fileName = File::Spec->catfile($beaHome , "state", "virtualdata.xml");
    my $fileNameOvm = File::Spec->catfile($ovmcfgHome, "virtualdata.xml");
    my $fileNameTmp = File::Spec->catfile("" , "tmp", "virtualdata.xml");

    if(-e $fileNameOvm)
    {
        return $fileNameOvm;
    }
    elsif(-e $fileName)
    {
        return  $fileName;
    }
    elsif(-e $fileNameTmp)
    {
        return  $fileNameTmp;
    }
    return '';
}

sub parseStart
{
    my $p = shift;
    my $el = shift;


    if($el eq "zones")
    {
        $zonesTag = "T";
    }
    elsif($el eq "zone")
    {
        $zoneTag = "T";
        if($zonesTag eq "T")
        {
            my $zoneNew = $zones{$zoneFound};
            if(not defined($zoneNew))
            {
                $zones{$zoneFound} = $zoneNew = new Zone;
                $zoneFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
                if($att eq "total-memory-mb")
                {
                    $zoneNew->{_TOTAL_MEMORY_MB} = $val;
                }
                elsif($att eq "total-diskspace-mb")
                {
                    $zoneNew->{_TOTAL_DISKSPACE_MB} = $val;
                }
                elsif($att eq "total-physical-cpus")
                {
                    $zoneNew->{_TOTAL_PHYSICAL_CPUS} = $val;
                }
                elsif($att eq "total-nics")
                {
                    $zoneNew->{_TOTAL_NICS} = $val;
                }
                elsif($att eq "zone-uuid")
                {
                    $zoneNew->{_ZONE_UUID} = $val;
                }
                elsif($att eq "ovmm-uuid")
                {
                    $zoneNew->{_OVMM_UUID} = $val;
                }
                elsif($att eq "ovm-display-name")
                {
                    $zoneNew->{_OVM_DISPLAY_NAME} = $val;
                }
            }   
        }    
    }
}

sub parseEnd
{
    my $p = shift;
    my $el = shift ;

    if($el eq "zones")
    {
        $zonesTag = "F";
    }
    elsif($el eq "zone")
    {
        $zoneTag ="F";

    }
}

package Zone;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}
 
