#!/bin/sh
#
# $Header: config.sh 07-mar-2006.15:35:29 ndutko Exp $
#
# config.sh
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      config.sh - CCR Package post install software configuration script
#
#    DESCRIPTION
#      Run after the install.sh and postinstall procedure is invoked
#      during a package deployment, this script completes the installation
#      steps by configuring the software.
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

exit 0
