#!/bin/sh
#
# $Header: emll/install/scripts/install.sh /main/15 2011/02/22 13:29:06 pschow Exp $
#
# install.sh
#
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      install.sh - CCR Package install software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process and is used to unpack the distribution in the target
#      directory. 
#
#    MODIFIED   (MM/DD/YY)
#    pschow      10/28/10 - Ops Center Harvester
#    qding       03/25/10 - move PyLib to core package
#    svrrao      02/12/10 - Unzipping PyLib
#    tsubrama    01/13/09 - no jdk jar dependency
#    pparida     03/24/06 - Use JAR instead of UNZIP to extract 
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    cvaishna    02/20/06 - UNZIP -d option 
#    cvaishna    02/20/06 - 
#    ndutko      10/17/05 - Add alternate path for unzip 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

#
# LiveLink installation and deployment of the LiveLink scripts package
#

_usrBinDir=/usr/bin
_binDir=/bin
_usrLocalBinDir=/usr/local/bin

DIRNAME=${_usrBinDir}/dirname
if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

if [ ! -z "${JAVA_HOME_CCR}" ]
then
    _JAVA_HOME=${JAVA_HOME_CCR}
elif [ ! -z "${JAVA_HOME}" ]
    then    
        _JAVA_HOME=${JAVA_HOME}
    else    
        _JAVA_HOME=${ORACLE_HOME}/jdk
fi

# find jre home, if jdk home is not found
if [ ! -f ${_JAVA_HOME}/bin/java ]
then
  _JAVA_HOME=${ORACLE_HOME}/jre
fi

#
#Use jdk/jar if available, Otherwise use our util.
#
if [ -f ${_JAVA_HOME}/bin/jar ] 
then
  JAR=${_JAVA_HOME}/bin/jar
else
  if [ -f ${CCR_HOME}/bin/ocmJarUtil ]
  then
     JAR=${CCR_HOME}/bin/ocmJarUtil
  else
     echo "OCM JAR Util is not found"
     exit 3
  fi
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

AWK=${_binDir}/awk
PLATFORM=`$UNAME | $CUT -f1`
if [ "$PLATFORM" = "SunOS" ]
then
    if [ -f ${_binDir}/nawk ]
    then
        AWK=${_binDir}/nawk
    elif [ -f ${_usrBinDir}/nawk ]
    then
        AWK=${_usrBinDir}/nawk
    fi
fi

CAT=${_binDir}/cat
ECHO=${_binDir}/echo
CRONTAB=${_usrBinDir}/crontab
EXPR=${_usrBinDir}/expr
PKGPARAM=${_usrBinDir}/pkgparam
RPM=${_binDir}/rpm
RM="${_binDir}/rm"
RMF="$RM -f"

# Default the temporary directory to /tmp for where temporary files are written.
if [ -z "${CCR_TEMP}" ]
then
    CCR_TEMP=/tmp
    export CCR_TEMP
fi
_tmpCrontab=${CCR_TEMP}/crontab.$$

returnExitCodeOnExit()
{
    exit $?
}

addOpsCenterCronEntry()
{
   ocharv="${CCR_HOME}/sysman/admin/util/opscenterharvester"
   cronentry="30 3 * * * [ -x ${ocharv} ] && ${ocharv} >/dev/null 2>&1"
   crontmp2=${CCR_TEMP}/cron2.$$
   $CRONTAB -l > ${_tmpCrontab} 2>${_tmpCrontab}.err
   
   if [ $? -eq 0 ]; then
      $CAT ${_tmpCrontab} | $EGREP -v "${ocharv}" > ${crontmp2} 2>/dev/null
      exitc=$?
      echo "${cronentry}" >> ${crontmp2}
      if [ $? -eq 0 -a $exitc -eq 0 ]; then
         $CRONTAB ${crontmp2} >/dev/null 2>&1
      fi
   fi
   $RMF ${crontmp2} ${_tmpCrontab} ${_tmpCrontab}.err
}

#
# Check if running version of Ops Center is at release level 2.6
# or higher
#
compareOpsCenterVersion()
{
    maj=$1
    min=$2

    # Ensure major and minor levels are numeric
    $EXPR "$maj" + 1 2>/dev/null 1>&2
    [ $? -ne 0 ] && return 1

    $EXPR "$min" + 1 2>/dev/null 1>&2
    [ $? -ne 0 ] && return 1

    if [ $maj -ge 2 ]; then
       if [ $maj -eq 2 -a $min -ge 6 ]; then
          return 0
       elif [ $maj -gt 2 ]; then
          return 0
       fi
    fi

    return 1
}

# Check for if OCM installation is being driven by Ops Center installer
checkOpsCenterPlatform()
{
    if [ "${PLATFORM}" = "Linux" -o "${PLATFORM}" = "SunOS" ]; then
        if [ -z "${CCR_DISABLE_CRON_ENTRY}" ]; then
            if [ "${CCR_HOME}" = "/var/opt/sun/xvm/ocm/ccr" ]; then
                return 0
            fi
        fi
    fi

    return 1
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

CWD=$PWD
KITLOC=`$DIRNAME $0`

if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

cd $CCR_HOME
$JAR -xvf ${KITLOC}/payload.zip
cd $CWD

#
# Add cron entry for Ops Center Harvester if this is an Ops Center
# Enterprise Controller and this instance of OCM is being installed
# by the Ops Center installer.  Disable immediate error exiting since
# it is normal to encounter errors in this section.
#

if [ "${PLATFORM}" != "SunOS" -a "${PLATFORM}" != "Linux" ]; then
    trap - ERR
fi
set +e
checkOpsCenterPlatform
if [ $? -eq 0 ]; then
   errpkg=1
   VERS=
   case "${PLATFORM}" in
      Linux)
         VERS=`$RPM -q --queryformat '%{VERSION}' sun-xvm-xvmocbui 2>/dev/null`
         errpkg=$?
         ;;

      SunOS)
         VERS=`$PKGPARAM SUNWxvmocbui VERSION 2>/dev/null`
         errpkg=$?
         ;;
      *)
         ;;
    esac

    if [ "$errpkg" -eq 0 ]; then
       # Ensure this is Ops Center version 2.6 or higher
       MAJVERS=`$ECHO "${VERS}" | $AWK -F'.' '{print $1}' 2>/dev/null`
       MINVERS=`$ECHO "${VERS}" | $AWK -F'.' '{print $2}' 2>/dev/null`
       if [ ! -z "${MAJVERS}" -a ! -z "${MINVERS}" ]; then
           compareOpsCenterVersion "${MAJVERS}" "${MINVERS}"
           if [ $? -eq 0 ]; then
              addOpsCenterCronEntry
           fi
       fi
    fi
fi
set -e

exit 0
