#!/bin/sh
#
# $Header: emll/install/scripts/postinstall.sh /main/10 2012/06/14 11:40:58 fmorshed Exp $
#
# postinstall.sh
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      postinstall.sh - CCR Package postinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process after install.sh and is used to reset file permissions,
#      etc. 
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    05/11/12 - Move the central collector related .sh file treatment to core package
#    fmorshed    04/27/12 - Add chmodFilesh
#    fmorshed    10/07/11 - Add testOwnership.sh and makeDirSameOwner.sh.
#    jsutton     04/22/11 - chown to ccr tree owner, not current process UID
#    pschow      11/02/10 - Ops Center Harvester
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Port specific changes for generic mechanism for 
#                           getting uid 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin

AWK=${_binDir}/awk
CHMOD=${_binDir}/chmod
CHOWN=${_binDir}/chown
FIND=${_usrBinDir}/find
ID=${_usrBinDir}/id
LS=${_binDir}/ls

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

#
# LiveLink installation and deployment of the LiveLink Engines package
#
if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

# Initialize ccr owner and group 
ccrOwner=`$LS -Llnd $CCR_HOME |$AWK '{print $3}'`
ccrGroup=`$LS -Llnd $CCR_HOME |$AWK '{print $4}'`

#
# Recurse through the directory and reset the file protections.
#
$CHOWN -R "$ccrOwner:$ccrGroup" ${CCR_HOME}/sysman
$CHMOD -R 740 ${CCR_HOME}/sysman

$FIND ${CCR_HOME}/sysman -type f -exec $CHMOD u-x {} \;

# Ensure that Ops Center Harvester script is executable
if [ -f ${CCR_HOME}/sysman/admin/util/opscenterharvester ]; then
    $CHMOD 740 ${CCR_HOME}/sysman/admin/util/opscenterharvester
fi

exit 0
