#!/bin/sh
#
# $Header: emll/install/scripts/uninstall.sh /main/7 2010/11/09 11:43:52 pschow Exp $
#
# uninstall.sh
#
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      uninstall.sh - CCR Package deinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      to deinstall the current version. 
#
#    MODIFIED   (MM/DD/YY)
#    pschow      10/29/10 - Ops Center Harvester
#    ndutko      04/10/07 - Movement of calconfig.jar to sysman subtree
#    rayleung    02/27/06 - add steps to remove calconfig.jar and 
#                           esemconfig.jar for OCS targets config data 
#                           collections 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin

RMRF="${_binDir}/rm -rf"
CRONTAB=${_usrBinDir}/crontab
ED=${_binDir}/ed

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then 
    CUT=${_usrBinDir}/cut
fi  

PLATFORM=`$UNAME | $CUT -f1`


#
# LiveLink installation and deployment of the LiveLink Engines package
#
if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

if [ -z "${CCR_TEMP}" ]
then
    CCR_TEMP=/tmp
    export CCR_TEMP
fi

if [ -d ${CCR_HOME}/sysman ]; then
   $RMRF ${CCR_HOME}/sysman
fi

# Remove crontab entry for Ops Center Harvester on this OCM instance if 
# it exists and if this is an Enterprise Controller
set +e
if [ "${PLATFORM}" = "Linux" -o "${PLATFORM}" = "SunOS" ]; then
    cronfile=${CCR_TEMP}/crontab.$$
    $CRONTAB -l > $cronfile 2>/dev/null
    if [ $? -eq 0 ]; then
        cron_entry=`$EGREP "$CCR_HOME/sysman/admin/util/opscenterharvester" $cronfile 2>/dev/null`
        if [ -n "${cron_entry}" ]; then
            $ED $cronfile <<EOF >/dev/null
g,$CCR_HOME/sysman/admin/util/opscenterharvester,d
w
q
EOF
            if [ $? -eq 0 ]; then
                $CRONTAB $cronfile
            fi
        fi
    fi
    $RMRF $cronfile 
fi
set -e

exit 0
