#!/bin/sh
#
# $Header: emll/install/core/install.sh /main/42 2012/10/03 15:45:08 jsutton Exp $
#
# install.sh
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      install.sh - CCR Package install software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process and is used to unpack the distribution in the target
#      directory. 
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     10/03/12 - deal with installing 64 bit kits when using 32 bit
#                           jvm
#    ckalivar    05/26/11 - XbranchMerge ckalivar_bug-10104949 from
#                           st_emll_10.3.5
#    ckalivar    05/20/11 - add support for ccr user for ASM home install
#    ckalivar    05/27/10 - Fix bug 9707966: look for /usr/local/bin for make
#    qding       04/02/10 - diagexclusion.template file
#    ndutko      02/26/10 - Fix problem where TOUCH was not defined
#    aghanti     02/17/10 - Change the hardcoded password of the keystore we
#                           ship to a random one
#    aghanti     10/08/09 - Removal of dependency on xpg4 utilities
#    aghanti     09/14/09 - Define macro OCM_MAKE, to avoid clash with MAKE
#                           macro from other imported makefiles
#    tsubrama    01/13/09 - no jdk jar dependency
#    nmittal     12/22/08 - creating state/upload/external dir
#    jsutton     10/12/07 - XbranchMerge jsutton_bug-6491511 from
#                           st_emll_10.2.7
#    ndutko      10/11/07 - XbranchMerge ndutko_bug-6495218 from st_emll_10.2.7
#    ndutko      10/11/07 - Explicitly compare the va sharedHomesSupported
#                           against a value
#    jsutton     10/10/07 - XbranchMerge jsutton_bug-6475754 from
#                           st_emll_10.2.7
#    jsutton     10/10/07 - Make sure we have port-specific SED definitions
#    jsutton     10/10/07 - Need SED definition
#    ndutko      10/09/07 - XbranchMerge ndutko_bug-6488100 from st_emll_10.2.7
#    ndutko      10/09/07 - Determine whether this version of install supports
#                           shared installs and use constants vs checking for a
#                           directory.
#    aghanti     09/10/07 - Bug 6372785 - fixing PE in main
#    aghanti     09/03/07 - Bug 6372785 -z arg should be in quotes
#    aghanti     08/30/07 - Bug 6324591 - Setting env var LD_OPTIONS before
#                           relinking
#    jsutton     08/29/07 - Handle upgrades from pre-shared-home OCM
#    jsutton     07/26/07 - Pick up existing shared OH work
#    aghanti     06/19/07 - Bug 6127305 (hpux) - moving snmzuutil from bin to
#                           lib
#    nemalhot    06/24/07 - Create diagnostic directory as part of
#                           installation.
#    aghanti     05/31/07 - Bug 6061960 - Setting MAKEFLAGS and MFLAGS env vars
#    cvaishna    04/03/06 - Replacing make with MAKE macro 
#    cvaishna    03/30/06 - replace _platform with PLATFORM 
#    cvaishna    03/30/06 - Relinking snmzuutil for hpux 
#    ndutko      04/03/06 - Use definition of MAKE 
#    cvaishna    03/29/06 - Fix for differnt behaviour of TRAP 
#    pparida     03/24/06 - Use JAR instead of UNZIP to extract 
#    ndutko      03/21/06 - Follow the SYMLINK'd directory for the true 
#                           ownership of the ORACLE_HOME 
#    cvaishna    02/20/06 - UNZIP -d option 
#    cvaishna    02/20/06 - 
#    ndutko      02/09/06 - Clean up the archives and objects deployed in lib 
#    amitkum     11/16/05 - Added support for scheduler 
#    ndutko      11/22/05 - Change the comparison for ownership to numeric 
#                           based 
#    ndutko      10/17/05 - Add alternate path for unzip 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      10/06/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Port specific changes for generic mechanism for 
#                           getting uid 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      09/27/05 - Remove use of array for loop 
#    ndutko      09/27/05 - Don't use stat 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

setHostName()
{
  CCR_HOST_NAME=`hostname`

  export CCR_HOST_NAME
}

setOCMDirPaths()
{
  # Check whether its a shared OCM install
  if [ ${_sharedHomesSupported} -eq 0 ]
  then
    if [ -z "${ORACLE_CONFIG_HOME}" ]
    then
      CCR_CONFIG_HOME="${CCR_HOME}/hosts/${CCR_HOST_NAME}"
    elif [ -d ${ORACLE_CONFIG_HOME} ]
    then
      # strip any trailing dirsep
      ORACLE_CONFIG_HOME=`$ECHO ${ORACLE_CONFIG_HOME} | $SED -e 's/\/*$//'`
      CCR_CONFIG_HOME="${ORACLE_CONFIG_HOME}/ccr"
    else
      $ECHO '$ORACLE_CONFIG_HOME should point to the directory containing OCM configurations for the host.'
      exit $ERR_PREREQ_FAILURE
    fi
  else
    CCR_CONFIG_HOME=${CCR_HOME}
  fi

  export CCR_CONFIG_HOME
}

#
# function - changeKeystorePasswd
# Changes the password of the keystore to a random one
# (The passwd of the keystore we ship is hardcoded currently)
# Ignores all errors, just reports them as warnings
#
changeKeystorePasswd()
{
  if [ -f ${_JAVA_HOME}/bin/keytool ]
  then
    KEYTOOL=${_JAVA_HOME}/bin/keytool
  else
    $ECHO 'Keytool is not found'
    return
  fi

  _keyStore=${CCR_HOME}/admin/security/certca
  if [ ! -f "${_keyStore}" ]
  then
    $ECHO 'Keystore is not found'
    return
  fi

  # Save the original shell flags
  _originalShellFlags=$-
  # Disable shell exit on error
  set +e

  # CCR_TEMP is set by deployPackages
  if [ "${PLATFORM}" = "Linux" ]; then
    _tmpKeytool=`$MKTEMP ${CCR_TEMP}/keytool.XXXXXX`
  else
    _tmpKeytool=${CCR_TEMP}/keytool.$$
    # First remove the temp file if it already existed
    if [ -f "${_tmpKeytool}" ]
    then
      $RMF ${_tmpKeytool}
    fi
    $TOUCH ${_tmpKeytool}
  fi
  if [ ! -f ${_tmpKeytool} ]
  then
    $ECHO 'Unable to create temp file in ${CCR_TEMP}'
    # Reset original shell flags only if there were any
    if [ ! -z "${_originalShellFlags}" ]
    then
      set ${_originalShellFlags}
    fi
    return
  fi

  # Generate random password for keystore
  _curDate=`$DATE +%m%d%Y%H%M%S`
  $ECHO "OCMRootCA${_curDate}" > ${_tmpKeytool}
  $ECHO "OCMRootCA${_curDate}" >> ${_tmpKeytool}

  # Do not set passwd through command line option, read it thro redirection
  $KEYTOOL -storepass "LiveLinkRootCA" -storepasswd -keystore ${_keyStore} < ${_tmpKeytool} >/dev/null 2>&1

  if [ $? -eq 0 ]
  then
    $ECHO 'Keystore password updated successfully'
  else
    $ECHO 'Unable to update keystore password'
  fi

  # Cleanup
  $RMF ${_tmpKeytool}
  # Reset original shell flags only if there were any
  if [ ! -z "${_originalShellFlags}" ]
  then
    set ${_originalShellFlags}
  fi
}

#
# CCR installation and deployment of the CCR core package
#
# Define the paths for /usr/bin. These are used in subsequent path
# specifications for native commands.
_usrBinDir=/usr/bin
_binDir=/bin
_usrLocalBinDir=/usr/local/bin
_usrCcsBinDir=/usr/ccs/bin

# Set the variables that map to explicit paths to prevent from trojan
# horse type attacks and allow for more consistent installation experience
# by eliminating the use of aliases.
AWK=${_binDir}/awk
CHMOD=${_binDir}/chmod
CHOWN=${_binDir}/chown
DATE=${_binDir}/date
DIRNAME=${_usrBinDir}/dirname
ECHO=${_binDir}/echo
ID=${_usrBinDir}/id
LS=${_binDir}/ls
MKDIRP="${_binDir}/mkdir -p"
MKTEMP=${_binDir}/mktemp
MV=${_binDir}/mv
RM=${_binDir}/rm
RMRF="$RM -rf"
RMF="$RM -f"
SED=${_binDir}/sed
TAR=${_binDir}/tar
TOUCH=${_binDir}/touch
TR=${_usrBinDir}/tr

if [ -f ${_usrBinDir}/make ]; then
   MAKE=${_usrBinDir}/make
elif [ -f ${_usrCcsBinDir}/make ]; then
   MAKE=${_usrCcsBinDir}/make
elif [ -f ${_usrLocalBinDir}/make ]; then
   MAKE=${_usrLocalBinDir}/make
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi
if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1`
PLATARCH=`$UNAME -m | $CUT -f1`

returnExitCodeOnExit()
{
    exit $?
}

# special check for Linux 64 bit platforms
if [ "${PLATFORM}" = "Linux" ] && [ "${PLATARCH}" = "x86_64" -o "${PLATARCH}" = "amd64" ]
then
    # check manifest file - we should be using the 64 bit kit here
    _tmpDir=`$DIRNAME $0`
    _mfFile=${_tmpDir}/META-INF/MANIFEST.MF
    if [ -f ${_mfFile} ]
    then
        _packageArch=`$EGREP 'package-architecture' ${_mfFile} | $TR -d '\r' |$CUT -f2 -d':' | $CUT -f2 -d' '`
        if [ ! "${_packageArch}" = "x86_64" ]
        then
            $ECHO 'The kit being installed is supported on ${_packageArch}, but not this architecture (${PLATARCH}).'
            exit 1
        fi
    fi
fi

if [ "${PLATFORM}" = "SunOS" ]; then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]; then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

if [ ! -z "${JAVA_HOME_CCR}" ]
then 
    _JAVA_HOME=${JAVA_HOME_CCR}
elif [ ! -z "${JAVA_HOME}" ]
    then    
        _JAVA_HOME=${JAVA_HOME}
    else    
        _JAVA_HOME=${ORACLE_HOME}/jdk
fi

# find jre home, if jdk home is not found
if [ ! -f ${_JAVA_HOME}/bin/java ]
then
   _JAVA_HOME=${ORACLE_HOME}/jre
fi

#
#Use jdk/jar if available, Otherwise use our util.
#
if [ -f ${_JAVA_HOME}/bin/jar ] 
then
  JAR=${_JAVA_HOME}/bin/jar
else
  if [ -f ${CCR_HOME}/bin/ocmJarUtil ]
  then
     JAR=${CCR_HOME}/bin/ocmJarUtil
  else
     $ECHO "OCM JAR Util is not found"
     exit 3 
  fi
fi

CWD=$PWD
KITLOC=`$DIRNAME $0`

if [ -z "${CCR_HOME}" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

#
# Determine if Shared Oracle Home support is available. This is determined
# thru the new directory 'hosts' under the CCR_HOME.
#
if [ -d "${CCR_HOME}/hosts" ]; then
    _sharedHomesSupported=0
else
    _sharedHomesSupported=1
fi

setHostName
setOCMDirPaths

if [ -z "${CCR_CONFIG_HOME}" ]
then
   $ECHO '${CCR_CONFIG_HOME} is not defined.'
   exit 1
fi

# Determine the owner of the ORACLE_HOME directory. This is not 
# foolproof, but will indicate the owner of the home.
_UID=`$ID | $CUT -d'=' -f2 | $CUT -d'(' -f1`
_CCR_OWNER=`$LS -Llnd $CCR_HOME |$AWK '{print $3}'`
_ORACLE_HOME_OWNER=`$LS -Llnd $ORACLE_HOME |$AWK '{print $3}'`
if [ ${_UID} -ne ${_ORACLE_HOME_OWNER} ]; then
    # If OH owner is not running, only excuse: user should be ccr_owner and OH owner should be root
    if [ ${_UID} -ne ${_CCR_OWNER} -o ${_ORACLE_HOME_OWNER} -ne 0 ]; then
      echo "*****"
      echo "Only the Oracle home owner can install the CCR collector into the home"
      echo "The ORACLE_HOME (${ORACLE_HOME}) is owned by the UID $OH_OWNER"
      echo "*****"
      exit 2
    fi
fi

#
# Unpack the payload ZIP file directly into the CCR home
#
cd $CCR_HOME
$JAR -xvf ${KITLOC}/payload.zip
cd $KITLOC

# Change the hardcoded password of the keystore we ship to a random one
changeKeystorePasswd

#
# Create the list of subdirectories that may not be present.
#
for LL_SUBDIRS in inventory inventory/pending
do
   path=${CCR_HOME}/${LL_SUBDIRS}
   if [ ! -d $path ]; then
       $MKDIRP $path
   fi
done

for LL_SUBDIRS in config config/default config/diagchecks_exclude config/diagcheck_wallet state state/review state/previous state/upload state/upload/external state/temp state/diagnostic log 
do
   path=${CCR_CONFIG_HOME}/${LL_SUBDIRS}
   if [ ! -d $path ]; then
       $MKDIRP $path
   fi
done

#
# Relink scheduler/emctl objects/libraries to generate executables.
#
MAKEFLAGS=
export MAKEFLAGS
MFLAGS=
export MFLAGS 
LD_OPTIONS=
export LD_OPTIONS

#unset CCOPTS see bug 6164575
CCOPTS=
export CCOPTS

#pass OCM_MAKE macro to the makefile
$MAKE -f ${CCR_HOME}/lib/ins_emll.mk OCM_MAKE=${MAKE} sched

# Relink snmzuutil binary on HP-UX for cpuinfo
if [ "${PLATFORM}" = "HP-UX" ];  then
   $MAKE -f ${CCR_HOME}/lib/ins_emll.mk OCM_MAKE=${MAKE} snmzuutil
   $MV ${CCR_HOME}/bin/snmzuutil ${CCR_HOME}/lib/
   $CHMOD 740 ${CCR_HOME}/lib/snmzuutil
fi

# Remove the archives and objects that are no longer required for running.
$RMF ${CCR_HOME}/lib/sysliblist
$RMF ${CCR_HOME}/lib/*.a
$RMF ${CCR_HOME}/lib/*.o
$RMRF ${CCR_HOME}/lib/stubs
$RMF ${CCR_HOME}/lib/env_emll.mk
$RMF ${CCR_HOME}/lib/ins_emll.mk

exit 0
