#!/bin/sh
#
# $Header: emll/install/core/postinstall.sh /main/57 2012/06/14 11:40:59 fmorshed Exp $
#
# postinstall.sh
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      postinstall.sh - CCR Package postinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process after install.sh and is used to reset file permissions,
#      etc. 
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    05/11/12 - Make permission of the scripts needed for max upload 755.
#    fmorshed    05/11/12 - Add the scripts needed for max upload
#    jsutton     04/22/11 - chown to ccr tree owner, not current process UID
#    fmorshed    11/10/10 - add deriveCCR and common
#    qding       04/02/10 - diagexclusion.template file
#    qding       03/26/10 - move the root directory of diagchecks
#    asunar      02/15/10 - Cleaning the JAVA_CRONPATH compuation and the
#                           JAVA_HOME entry from SED for crontab entry
#    ndutko      10/16/09 - XbranchMerge ndutko_bug-8999116 from st_emll_10.3.2
#    ndutko      10/15/09 - Don't perform a re-registration on upgrade due to
#                           generation of superfluous new configs if registered
#                           anonymously.
#    aghanti     10/08/09 - Removal of dependency on xpg4 utilities
#    mswamyt     02/02/09 - permission to ocmJarUtil
#    jsutton     07/29/08 - XbranchMerge jsutton_bug-7268601 from main
#    ndutko      04/23/08 - Reset the permissions on the ccr/config directory
#                           as well
#    ndutko      03/19/08 - change permission on emocmrsp
#    jsutton     12/14/07 - Clamp down on file protections
#    jsutton     12/13/07 - Set protections more restrictive
#    aghanti     10/17/07 - Bug 6506916 - fixing path to snmzuutil binary (for
#                           CHMOD)
#    ndutko      10/17/07 - XbranchMerge ndutko_bug6502842 from st_emll_10.2.7
#    ndutko      10/17/07 - Conditionally add the ORACLE_CONFIG_HOME=<val> to 
#                           the template crontab file (bug 6502842)
#    jsutton     10/12/07 - XbranchMerge jsutton_bug-6491511 from
#                           st_emll_10.2.7
#    ndutko      10/11/07 - XbranchMerge ndutko_bug-6495218 from st_emll_10.2.7
#    ndutko      10/11/07 - Explicitly compare the va sharedHomesSupported
#                           against a value
#    jsutton     10/10/07 - XbranchMerge jsutton_bug-6475754 from
#                           st_emll_10.2.7
#    jsutton     10/10/07 - Make sure we have port-specific SED definitions
#    ndutko      10/09/07 - XbranchMerge ndutko_bug-6488100 from st_emll_10.2.7
#    ndutko      10/09/07 - Determine whether this version of install supports
#                           shared installs and use constants vs checking for a
#                           directory.
#    jsutton     10/03/07 - Create crontab file in postinstall, remove it in
#                           config
#    jsutton     10/02/07 - No crontab entry, thanks
#    jsutton     09/10/07 - Leave crontab template
#    aghanti     09/10/07 - Bug 6372785 - fixing PE in main
#    aghanti     08/30/07 - Bug 6372785 -z argument should be in quotes
#    jsutton     08/29/07 - Handle upgrades from pre-shared-home OCM
#    jsutton     07/26/07 - Pick up existing shared OH work
#    ndutko      05/10/07 - XbranchMerge ndutko_bug-6040007 from st_emll_10.2.6
#    ndutko      05/09/07 - Conditionally force a re-registration
#    ndutko      09/25/06 - CHMOD configCCR vs setupCCR
#    ndutko      09/20/06 - Name change of ccr.properties.template to
#                           ccr.properties
#    ndutko      08/02/06 - Remove the SYMLINK of emCCR.jar to bin
#    ndutko      06/27/06 - Change the protection of the getdbinfo module 
#    pparida     03/24/06 - Use $PWD instead of `pwd` 
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - 
#    ndutko      01/25/06 - allow a precidence of JAVA_HOME_CCR, then 
#                           JAVA_HOME for JDK location specification. This for 
#                           OUI installation support 
#    jsutton     12/14/05 - Need symlink for lib/emCCR.jar to ../bin 
#    ndutko      12/12/05 - Include the ebs_createCtxLocXml.sh file 
#    ndutko      12/08/05 - Movement of emCCRCollector to lib 
#    ndutko      12/06/05 - Conditionally update the collector.properties 
#    ndutko      12/05/05 - Change the crontab schedule for scheduler startup 
#                           to be every 15 minutes in a portable fashion 
#    amitkum     11/16/05 - Added support for scheduler 
#    ndutko      10/12/05 - Remove ';' between setting of env for LINUX when 
#                           setting JAVA_HOME 
#    dkapoor     10/10/05 - Provide SQL convenience 
#    ndutko      10/07/05 - 
#    ndutko      09/30/05 - Add instantiating of JAVA_HOME in the crontab if 
#                           specified during installation 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Port specific changes for generic mechanism for 
#                           getting uid 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      09/18/05 - Correct the path for Find directive 
#    ndutko      09/13/05 - Provide the template for user customization 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

# Define the paths for /usr/bin. These are used in subsequent path
# specifications for native commands.
_usrBinDir=/usr/bin
_binDir=/bin

# Set the variables that map to explicit paths to prevent from trojan
# horse type attacks and allow for more consistent installation experience
# by eliminating the use of aliases.
AWK=${_binDir}/awk
CAT=${_binDir}/cat
CHMOD=${_binDir}/chmod
CHOWN=${_binDir}/chown
CP=${_binDir}/cp
ECHO=${_binDir}/echo
FIND=${_usrBinDir}/find
HOSTNAME=${_binDir}/hostname
ID=${_usrBinDir}/id
LS=${_binDir}/ls
SED=${_binDir}/sed
RM=${_binDir}/rm

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

_platform=`$UNAME | $CUT -f1`

returnExitCodeOnExit()
{
    exit $?
}

setHostName()
{
  CCR_HOST_NAME=`hostname`

  export CCR_HOST_NAME
}

setOCMDirPaths()
{
  # Check whether its a shared OCM install
  if [ ${_sharedHomesSupported} -eq 0 ]
  then
    if [ -z "${ORACLE_CONFIG_HOME}" ]
    then
      CCR_CONFIG_HOME="${CCR_HOME}/hosts/${CCR_HOST_NAME}"
    elif [ -d ${ORACLE_CONFIG_HOME} ]
    then
      # strip any trailing dirsep
      ORACLE_CONFIG_HOME=`$ECHO ${ORACLE_CONFIG_HOME} | $SED -e 's/\/*$//'`
      CCR_CONFIG_HOME="${ORACLE_CONFIG_HOME}/ccr"
    else
      $ECHO '$ORACLE_CONFIG_HOME should point to the directory containing OCM configurations for the host.'
      exit $ERR_PREREQ_FAILURE
    fi
  else
    CCR_CONFIG_HOME=${CCR_HOME}
  fi

  export CCR_CONFIG_HOME
}

if [ "${_platform}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${_platform}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

CWD=$PWD

#
# CCR installation and deployment of the CCR core package
#
if [ -z "${CCR_HOME}" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

# Initialize ccr owner and group 
ccrOwner=`$LS -Llnd $CCR_HOME |$AWK '{print $3}'`
ccrGroup=`$LS -Llnd $CCR_HOME |$AWK '{print $4}'`

#
# Determine if Shared Oracle Home support is available. This is determined
# thru the new directory 'hosts' under the CCR_HOME.
#
if [ -d "${CCR_HOME}/hosts" ]; then
    _sharedHomesSupported=0
else
    _sharedHomesSupported=1
fi

setHostName
setOCMDirPaths


# Instantiate a property file if not already present.
if [ -z "${CCR_INSTALL_CODEPATH}" ]
then
    if [ ! -f ${CCR_CONFIG_HOME}/config/collector.properties ]
    then
        $CP ${CCR_HOME}/config/collector.properties.template \
            ${CCR_CONFIG_HOME}/config/collector.properties
    fi
else
    $CAT ${CCR_HOME}/config/collector.properties.template >> \
         ${CCR_CONFIG_HOME}/config/collector.properties
fi

# copy the diagexclude.template file to ccr config home if it's different
# from ccr home.
if [ ! -z "${CCR_CONFIG_HOME}" -a \
     "${CCR_CONFIG_HOME}" != "${CCR_HOME}" ]
then
    if [ ! -f ${CCR_CONFIG_HOME}/config/diagchecks_exclude/diagexclude.template ]
    then
        $CP ${CCR_HOME}/config/diagchecks_exclude/diagexclude.template \
            ${CCR_CONFIG_HOME}/config/diagchecks_exclude/diagexclude.template
    fi
fi

#
# Recurse through the directory and reset the file protections.
#
$CHOWN -R "$ccrOwner:$ccrGroup" \
                ${CCR_HOME}/admin \
                ${CCR_HOME}/bin \
                ${CCR_HOME}/config \
                ${CCR_HOME}/doc \
                ${CCR_HOME}/lib \
                ${CCR_CONFIG_HOME}/config \
                ${CCR_CONFIG_HOME}/state \
                ${CCR_HOME}/mesg \
                ${CCR_HOME}/diagchecks

# Recursively set the file permissions on all files
$CHMOD -R 740 ${CCR_HOME}/admin \
              ${CCR_HOME}/doc \
              ${CCR_HOME}/lib \
              ${CCR_HOME}/mesg \
              ${CCR_HOME}/diagchecks

$CHMOD -R 700 ${CCR_CONFIG_HOME}/config \
              ${CCR_CONFIG_HOME}/state \
              ${CCR_CONFIG_HOME}/log \
              ${CCR_HOME}/config

$FIND ${CCR_HOME}/config -type f -exec $CHMOD 600 {} \;
$FIND ${CCR_CONFIG_HOME}/config -type f -exec $CHMOD 600 {} \;

# Remove the execute mask on files alone, leaving directories
# to retain execute or access permission.
$FIND ${CCR_HOME}/admin \
      ${CCR_HOME}/doc \
      ${CCR_HOME}/lib \
      ${CCR_CONFIG_HOME}/config \
      ${CCR_CONFIG_HOME}/state \
      ${CCR_HOME}/mesg \
      ${CCR_HOME}/diagchecks \
  -type f -exec $CHMOD u-x {} \;

# Explicitly set the permission on the bin directory. This directory
# is shared and as such, not all files can be reset.               
$CHMOD 740 ${CCR_HOME}/bin

# Reset the protection on the emCCR script/scheduler executables.
$CHMOD 740 ${CCR_HOME}/bin/nmz
$CHMOD 740 ${CCR_HOME}/bin/nmzctl
$CHMOD 740 ${CCR_HOME}/bin/emCCR
$CHMOD 740 ${CCR_HOME}/bin/emocmrsp
$CHMOD 740 ${CCR_HOME}/bin/configCCR
$CHMOD 740 ${CCR_HOME}/bin/common
$CHMOD 740 ${CCR_HOME}/bin/deriveCCR
$CHMOD 755 ${CCR_HOME}/bin/testOwnership.sh
$CHMOD 755 ${CCR_HOME}/bin/makeDirSameOwner.sh
$CHMOD 755 ${CCR_HOME}/bin/getUsersCentralPropsLocAndOwner.sh
$CHMOD 755 ${CCR_HOME}/bin/chmodFile.sh
$CHMOD 755 ${CCR_HOME}/bin/runCommandAsUser.sh
$CHMOD 740 ${CCR_HOME}/bin/ebs_createCtxLocXml.sh
$CHMOD 740 ${CCR_HOME}/lib/emCCRCollector
$CHMOD 740 ${CCR_HOME}/lib/emlogger
$CHMOD 740 ${CCR_HOME}/lib/getdbinfo
$CHMOD 740 ${CCR_HOME}/lib/emocmutl
$CHMOD 740 ${CCR_HOME}/bin/deployPackages
$CHMOD 740 ${CCR_HOME}/bin/ocmJarUtil
$CHMOD 740 ${CCR_HOME}/bin/lockfile
$CHMOD 740 ${CCR_HOME}/admin/scripts/installCCRSQL.sh

if [ "${_platform}" = "HP-UX" ]; then
   $CHMOD 740 ${CCR_HOME}/lib/snmzuutil
fi

ORACLE_CONFIG_HOME_VAR=""
if [ ${_sharedHomesSupported} -eq 0 -a \
     ! -z "${ORACLE_CONFIG_HOME}" ]; then
    ORACLE_CONFIG_HOME_VAR="ORACLE_CONFIG_HOME=${ORACLE_CONFIG_HOME} "
fi

$SED -e "s?%ORACLE_HOME%?${ORACLE_HOME}?g" \
     -e "s?%ORACLE_CONFIG_HOME%?${ORACLE_CONFIG_HOME_VAR}?g" \
        ${CCR_HOME}/admin/scripts/crontab.entry.template > \
        ${CCR_CONFIG_HOME}/config/default/crontab.entry

exit 0
