#!/bin/sh
#
# $Header: emll/install/core/uninstall.sh /main/44 2012/06/14 11:40:59 fmorshed Exp $
#
# uninstall.sh
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      uninstall.sh - CCR Package deinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      to deinstall the current version. 
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    05/11/12 - Add the scripts needs for designated collectors
#    fmorshed    11/10/10 - add deriveCCR and common scripts
#    qding       03/26/10 - move the root directory of diagchecks
#    ndutko      03/01/10 - OCM README and ReleaseNotes are now in PDF
#    asunar      02/01/10 - Matching the crontab entries by making the
#                           JAVA_HOME value as optional in grep
#    aghanti     10/08/09 - Reset shell flags only if there were any initially
#    aghanti     10/08/09 - Removal of dependency on xpg4 utilities
#    ckalivar    08/13/09 - Fix Bug-8366683: crontab wont be tamppered unless
#                           there is somthing to edit
#    ndutko      03/18/08 - 
#    aghanti     03/11/08 - Ensuring that the script runs with xpg4 shell on
#                           SunOS
#    ndutko      10/19/07 - XbranchMerge ndutko_bug-6511140 from st_emll_10.2.7
#    ndutko      10/19/07 - Correctly handle deinstall paths where the current
#                           oracle home could be shared. do not remove all the
#                           crontab entries, just the current one.
#    ndutko      10/17/07 - XbranchMerge ndutko_bug6502842 from st_emll_10.2.7
#    ndutko      10/17/07 - Conditionally remove CRONTAB entry for the OCH
#                           location.
#    ndutko      10/11/07 - XbranchMerge ndutko_bug-6495218 from st_emll_10.2.7
#    ndutko      10/11/07 - Explicitly compare the va sharedHomesSupported
#                           against a value
#    ndutko      10/09/07 - XbranchMerge ndutko_bug-6488100 from st_emll_10.2.7
#    ndutko      10/09/07 - Determine whether this version of install supports
#                           shared installs and use constants vs checking for a
#                           directory.
#    aghanti     09/10/07 - Bug 6372785 - fixing PE in main
#    aghanti     08/30/07 - Bug 6372785 -z argument should be in quotes
#    ndutko      08/14/07 - Provide the OCM collections PDF document
#    ndutko      09/27/06 - Remove templates if they existed on deinstall
#    ndutko      09/27/06 - XbranchMerge ndutko_bug-5567715 from st_emll_10.2.4
#    ndutko      09/25/06 - Uninstall configCCR vs setupCCR
#    ndutko      09/23/06 - Do not de-register on de-instalation.
#    ndutko      09/20/06 - Remove the distributed setupCCR
#    jsutton     09/12/06 - README is now README.TXT
#    ndutko      08/02/06 - Remove the SYMLINK of emCCR.jar to bin
#    cvaishna    04/03/06 - Bug Fix : 5128304 
#    cvaishna    03/30/06 - Removing snmzuutil binary for hpux 
#    ndutko      04/04/06 - Remove deployPackages 
#    kgupta      03/30/06 - Using stop_abort to stop scheduler 
#    ndutko      03/24/06 - Handle case where this is the only entry in the 
#                           crontab file 
#    ndutko      03/21/06 - Handle case of installation on an NFS volume. NFS 
#                           makes files hidden till closed. Hence 'Directory 
#                           not empty' errors may appear. 
#    kgupta      03/07/06 - Removing -silent from emCCR stop command 
#    ndutko      03/07/06 - Conditional location of UNAME 
#    ndutko      02/21/06 - Remove the crontab entry on uninstall 
#    ndutko      02/09/06 - Remove the archives and objects if present 
#    ndutko      02/01/06 - Trap the shutdown error condition and continue
#    jsutton     12/20/05 - Remove symlink for bin/emCCR.jar 
#    ndutko      12/12/05 - Include the ebs_createCtxLocXml.sh file 
#    ndutko      12/08/05 - Movement of emCCRCollector to lib 
#    glavash     12/09/05 - add timezone.properties 
#    ndutko      12/06/05 - Do not delete the entire doc directory on 
#                           deinstall 
#    ndutko      12/05/05 - Handle the deinstallation path successfully 
#    amitkum     11/16/05 - Added support for scheduler 
#    ndutko      10/07/05 - 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#
# Disable the shell exit on error
disableExitOnError()
{
    set +e
}
                                                                                                                      
#
# set the shell flags to the original state. As the design of this script
# assumes the -e flag, make certain the original state does not override
# what we need.
resetShellFlags()
{
    # Reset original shell flags only if there were any
    if [ ! -z "${_originalShellFlags}" ]
    then
        set ${_originalShellFlags}
    fi
    set -e
}
                                                                                                                      
# Save the original shell flag state as we'll need it for when
# we disable the state of the flags.
_originalShellFlags=$-

# Define the paths for /usr/bin. These are used in subsequent path
# specifications for native commands.
_usrBinDir=/usr/bin
_binDir=/bin

# Set the variables that map to explicit paths to prevent from trojan
# horse type attacks and allow for more consistent installation experience
# by eliminating the use of aliases.
CRONTAB=${_usrBinDir}/crontab
DIFF=${_usrBinDir}/diff
HOSTNAME=${_binDir}/hostname
RM=${_binDir}/rm
RMF="$RM -f"
RMRF="$RM -rf"
SED=${_binDir}/sed

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

PLATFORM=`$UNAME | $CUT -f1`

if [ $PLATFORM = "OSF1" ]
then
  if [ -z "${BIN_SH}" ]
  then
    BIN_SH=xpg4
    export BIN_SH
    $0 "$@"
    exit $?
  fi
fi

setHostName()
{
  CCR_HOST_NAME=`${HOSTNAME}`

  export CCR_HOST_NAME
}

# 
setOCMDirPaths()
{
  # Check whether its a shared OCM install
  if [ ${_sharedHomesSupported} -eq 0 ]
  then

    # Set the CCR_HOST_NAME variable
    setHostName

    if [ -z "${ORACLE_CONFIG_HOME}" ]
    then
      CCR_CONFIG_HOME="${CCR_HOME}/hosts/${CCR_HOST_NAME}"
    elif [ -d ${ORACLE_CONFIG_HOME} ]
    then
      # strip any trailing dirsep
      ORACLE_CONFIG_HOME=`$ECHO ${ORACLE_CONFIG_HOME} | $SED -e 's/\/*$//'`
      CCR_CONFIG_HOME="${ORACLE_CONFIG_HOME}/ccr"
    else
      $ECHO '$ORACLE_CONFIG_HOME should point to the directory containing OCM configurations for the host.'
      exit $ERR_PREREQ_FAILURE
    fi
  else
    CCR_CONFIG_HOME=${CCR_HOME}
  fi

  export CCR_CONFIG_HOME
}

#
# Delete file Unconditionally
#
rmUnconditional()
{
    _file=$1
    if [ ! -z "${_file}" ]
    then
        disableExitOnError        
        $RMF $_file
        # resetShellFlags: inlining function for ports
        if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
            resetShellFlags
        else
            # Reset original shell flags only if there were any
            if [ ! -z "${_originalShellFlags}" ]
            then
                set ${_originalShellFlags}
            fi
            set -e
        fi
    fi
}

#
# CCR installation and deployment of the CCR Engines package
#
if [ -z "${CCR_HOME}" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

#
# Determine if Shared Oracle Home support is available. This is determined
# thru the new directory 'hosts' under the CCR_HOME.
#
if [ -d "${CCR_HOME}/hosts" ]; then
    _sharedHomesSupported=0
else
    _sharedHomesSupported=1
fi

# 
# Set the variables for the OCH_VAR dependent on whether this is a shared
# config install
G_ORACLE_CONFIG_HOME_VAR=""
if [ ${_sharedHomesSupported} -eq 0 -a \
     ! -z "${ORACLE_CONFIG_HOME}" ]; then
    G_ORACLE_CONFIG_HOME_VAR="ORACLE_CONFIG_HOME=${ORACLE_CONFIG_HOME} "
fi

#
# Before going ahead make sure CCR is not running
#
if [ -x ${CCR_HOME}/bin/emCCR ]
then
    # disableExitOnError: inlining function for ports
    if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
        disableExitOnError
    else
        set +e
    fi

    ${CCR_HOME}/bin/emCCR -upgrade stop_abort
    # resetShellFlags: inlining function for ports
    if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
        resetShellFlags
    else
        # Reset original shell flags only if there were any
        if [ ! -z "${_originalShellFlags}" ]
        then
            set ${_originalShellFlags}
        fi
        set -e
    fi
fi

# disableExitOnError: inlining function for ports
if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
    disableExitOnError
else
    set +e
fi

$RMRF ${CCR_HOME}/admin
$RMRF ${CCR_HOME}/lib
$RMRF ${CCR_HOME}/mesg
$RMRF ${CCR_HOME}/diagchecks/scripts

rmUnconditional ${CCR_HOME}/bin/emCCR
rmUnconditional ${CCR_HOME}/lib/emCCRCollector
rmUnconditional ${CCR_HOME}/lib/emCCR.jar
rmUnconditional ${CCR_HOME}/bin/nmz
rmUnconditional ${CCR_HOME}/bin/nmzctl
rmUnconditional ${CCR_HOME}/bin/configCCR
rmUnconditional ${CCR_HOME}/bin/deriveCCR
rmUnconditional ${CCR_HOME}/bin/testOwnership.sh
rmUnconditional ${CCR_HOME}/bin/makeDirSameOwner.sh
rmUnconditional ${CCR_HOME}/bin/getUsersCentralPropsLocAndOwner.sh
rmUnconditional ${CCR_HOME}/bin/chmodFile.sh
rmUnconditional ${CCR_HOME}/bin/runCommandAsUser.sh
rmUnconditional ${CCR_HOME}/bin/common

if [ "$PLATFORM" = "HP-UX" ]; then
   rmUnconditional ${CCR_HOME}/bin/snmzuutil
fi

rmUnconditional ${CCR_HOME}/bin/ebs_createCtxLocXml.sh

rmUnconditional ${CCR_HOME}/bin/emocmrsp
rmUnconditional ${CCR_HOME}/lib/emocmutl.jar

rmUnconditional ${CCR_HOME}/log/sched.lock

rmUnconditional ${CCR_HOME}/bin/deployPackages

rmUnconditional ${CCR_HOME}/config/default/country_codes.properties
rmUnconditional ${CCR_HOME}/config/default/collector.properties
rmUnconditional ${CCR_HOME}/config/default/fetchlets.reg
rmUnconditional ${CCR_HOME}/config/default/sched.properties.template
rmUnconditional ${CCR_HOME}/config/collector.properties.template

rmUnconditional ${CCR_HOME}/doc/OCM_ReleaseNotes.pdf
rmUnconditional ${CCR_HOME}/doc/jsse_license.html
rmUnconditional ${CCR_HOME}/doc/license.txt
rmUnconditional ${CCR_HOME}/doc/ocm_collections.pdf

rmUnconditional ${CCR_HOME}/config/default/targets.xml
rmUnconditional ${CCR_HOME}/config/default/sched.properties
rmUnconditional ${CCR_HOME}/config/default/timezones.properties

rmUnconditional ${CCR_HOME}/diagchecks/DiagMetadata.xsd
rmUnconditional ${CCR_HOME}/diagchecks/DiagCheck.xsd

# Remove the archives and objects that are no longer required for running.
$RMF ${CCR_HOME}/lib/sysliblist
$RMF ${CCR_HOME}/lib/*.a
$RMF ${CCR_HOME}/lib/*.o
$RMRF ${CCR_HOME}/lib/stubs
$RMF ${CCR_HOME}/lib/env_emll.mk
$RMF ${CCR_HOME}/lib/ins_emll.mk

# Remove the crontab entry for the current home collector.
if [ -z "${CCR_TEMP}" ]
then
    CCR_TEMP=/tmp
fi
_tmpCrontab=${CCR_TEMP}/crontab.$$

# make certain crontab commands do not cause this to fail.
# disableExitOnError: inlining function for ports
if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
    disableExitOnError
else
    set +e
fi

$CRONTAB -l > /dev/null 2>&1
# Proceed only if crontab command succeeded (eg. crontab is not disabled)
if [ $? -eq 0 ]
then
    $CRONTAB -l > ${_tmpCrontab}
    $EGREP -v "(JAVA_HOME=[^ ]*)? ${G_ORACLE_CONFIG_HOME_VAR}${CCR_HOME}/bin/emCCR " ${_tmpCrontab} > ${_tmpCrontab}.1
    $DIFF ${_tmpCrontab}.1 ${_tmpCrontab} > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
       $CRONTAB ${_tmpCrontab}.1
    fi
fi

# resetShellFlags: inlining function for ports
if [ "$PLATFORM" = "SunOS" -o "$PLATFORM" = "Linux" ]; then
    resetShellFlags
else
    # Reset original shell flags only if there were any
    if [ ! -z "${_originalShellFlags}" ]
    then
        set ${_originalShellFlags}
    fi
    set -e
fi

$RMF ${_tmpCrontab}
$RMF ${_tmpCrontab}.1

exit 0
