#!/bin/sh
#
# $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/config.sh,v 2.5 2011/03/25 09:28:56 ldens Exp $
#
# config.sh
#
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      config.sh - CCR Package post install software configuration script
#
#    DESCRIPTION
#      Run after the install.sh and postinstall procedure is invoked
#      during a package deployment, this script completes the installation
#      steps by configuring the software.
#
#    MODIFIED   (MM/DD/YY)
#    ldens       03/25/11 - Change the copyright notice
#    ldens       11/15/10 - Initial version for the RDA component
#    mschenke    04/25/07 - Adapt it for RDA deployment
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

if [ "${RDA_OCM_TRACE:=0}" -ge 0 ]
then
    set -x
fi

_usrBinDir=/usr/bin
_binDir=/bin

CHMOD=${_binDir}/chmod
MV=${_binDir}/mv
RM=${_binDir}/rm

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

# Configure the compile engines
ENG_HOME="${ORACLE_HOME}/rda/engine"
if [ -f "${ENG_HOME}/rda.dft" ]
then
    if [ -f "${ENG_HOME}/rda.cfg" ]
    then
        $RM -f "${ENG_HOME}/rda.dft"
    else
        $MV "${ENG_HOME}/rda.dft" "${ENG_HOME}/rda.cfg"
        $CHMOD 440 "${ENG_HOME}/rda.cfg"
    fi
fi

exit 0
