' $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/config.vbs,v 2.5 2011/03/25 09:28:51 ldens Exp $
'
' config.vbs
'
' Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved.
'
'    NAME
'      config.vbs - CCR Package post install software configuration script
'
'    DESCRIPTION
'      Run after the install.vbs and postinstall procedure is invoked
'      during a package deployment, this script completes the installation
'      steps by configuring the software.
'
'    MODIFIED   (MM/DD/YY)
'    ldens       03/25/11 - Change the copyright notice
'    ldens       11/24/10 - Enhance it for RDA deployment
'    jsutton     01/24/06 - Creation
'
Option Explicit

Dim CcrHome, EngHome, FSO, WshShell, WshEnv

Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshShell = WScript.CreateObject("WScript.Shell")
Set WshEnv = WshShell.Environment("PROCESS")

' Include core utility
IncludeCoreUtils

' Get the CCR home
CcrHome = WshEnv("CCR_HOME")
If (isUninitialized(CcrHome)) Then
  WScript.Echo "CCR Home is not defined"
  WScript.Quit(1)
End If

' Treat the engine configuration file
EngHome = LCase(FSO.GetParentFolderName(CcrHome)) & "\rda\engine"

If FSO.FileExists(EngHome & "\rda.dft") Then
  If FSO.FileExists(EngHome & "\rda.cfg") Then
    FSO.DeleteFile EngHome & "\rda.dft", True
  Else
    FSO.MoveFile EngHome & "\rda.dft", EngHome & "\rda.cfg" 
  End If
End If

' Indicate a successful return
WScript.Quit(0)

' Includes the core utility file.
Private Sub IncludeCoreUtils
  Dim CoreUtils
  ' Get directory context of the script, coreutils must be in the same directory
  CoreUtils = LCase(Left(WScript.ScriptFullName, _
                         InStrRev(WScript.ScriptFullName, "\")))
  CoreUtils = CoreUtils & "coreutil.vbs"
  IncludeFileAbs CoreUtils
End Sub

' Includes a file in the global namespace of the current script.
' The file can contain any VBScript source code.
' The path of the file name must be specified absolute (or
' relative to the current directory).
Private Sub IncludeFileAbs (ByVal FileName)
  Dim f: set f = FSO.OpenTextFile(FileName, ForReading)
  Dim s: s = f.ReadAll()
  ExecuteGlobal s
End Sub
