#!/bin/sh
#
# $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/install.sh,v 2.18 2011/12/23 15:22:58 rda Exp $
#
# install.sh
#
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      install.sh - CCR Package install software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process and is used to unpack the distribution in the target
#      directory.
#
#    MODIFIED   (MM/DD/YY)
#    ldens       12/22/11 - Work around issue on AIX with '&&'.
#    ldens       09/12/11 - Enhance for embedded Diagnostic Assistant tool.
#    ldens       03/25/11 - Change the copyright notice.
#    ldens       01/13/11 - Enhance it for OCM 10.3.4.
#    ldens       11/15/10 - Initial version for the RDA component
#    mschenke    04/25/07 - Adapt it for RDA deployment
#    pparida     03/24/06 - Use JAR instead of UNZIP to extract
#    ndutko      03/07/06 - Correct location for UNAME
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP
#    cvaishna    03/03/06 - Bug Fix : 4908827
#    cvaishna    02/20/06 - UNZIP -d option
#    cvaishna    02/20/06 -
#    ndutko      10/17/05 - Add alternate path for unzip
#    ndutko      10/07/05 - CCR Cutover
#    ndutko      09/29/05 - Register a trap handler such that if an error
#                           occurs, the command exit code is percolated back
#                           up
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

#
# LiveLink installation and deployment of the RDA package
#

if [ "${RDA_OCM_TRACE:=0}" -ge 0 ]
then
    set -x
fi

_usrBinDir=/usr/bin
_binDir=/bin

CHMOD=${_binDir}/chmod
CHOWN=${_binDir}/chown
ECHO=${_binDir}/echo
LS=${_binDir}/ls
RM=${_binDir}/rm

DIRNAME=${_usrBinDir}/dirname
FIND=${_usrBinDir}/find

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_binDir}/expr ]
then
    EXPR=${_binDir}/expr
elif [ -f ${_usrBinDir}/expr ]
then
    EXPR=${_usrBinDir}/expr
fi

if [ -f ${_binDir}/grep ]
then
    GREP=${_binDir}/grep
elif [ -f ${_usrBinDir}/grep ]
then
    GREP=${_usrBinDir}/grep
fi

if [ -f ${_binDir}/sed ]
then
    SED=${_binDir}/sed
elif [ -f ${_usrBinDir}/sed ]
then
    SED=${_usrBinDir}/sed
fi

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

# Bail out if CCR home is not defined
if [ -z "${CCR_HOME}" ]
then
    $ECHO "CCR Home is not defined"
    exit 1
fi

# Determine the Java home
if [ ! -z "${JAVA_HOME_CCR}" ]
then
    _JAVA_HOME="${JAVA_HOME_CCR}"
elif [ ! -z "${JAVA_HOME}" ]
then
    _JAVA_HOME="${JAVA_HOME}"
else
    _JAVA_HOME="${ORACLE_HOME}/jdk"
fi

# Find JRE home, if JDK home is not found
if [ ! -f "${_JAVA_HOME}/bin/java" ]
then
    _JAVA_HOME="${ORACLE_HOME}/jre"
fi

# Use JDK/JAR if available, otherwise use OCM util
if [ -f "${_JAVA_HOME}/bin/jar" ]
then
    JAR="${_JAVA_HOME}/bin/jar"
elif [ -f "${CCR_HOME}/bin/ocmJarUtil" ]
then
    JAR="${CCR_HOME}/bin/ocmJarUtil"
else
    $ECHO "OCM JAR Util is not found"
    exit 3
fi

# Check the deployment conditions
can_deploy_rda()
{
    # Condition 1: Upgrade not disabled
    if [ -r "${RDA_HOME}/rda.cfg" ] &&
       $EGREP '^NO_UPGRADE=".*"' "${RDA_HOME}/rda.cfg"
    then
        $ECHO 'RDA upgrade disabled'
        exit 83
    fi

    # Condition 2: RDA directory writable
    if [ ! -w "${RDA_HOME}" ]
    then
        $ECHO 'RDA directory not writable'
        exit 83
    fi

    # Condition 3: Not an IRDA bootstrap
    if [ -f "${RDA_HOME}/irdacfg.ini" ] &&
       $EGREP "^RDA_HOME=" "${RDA_HOME}/irdacfg.ini" >/dev/null 2>&1
    then
        $ECHO 'IRDA bootstrap'
        exit 83
    fi

    # Condition 4: Default RDA configuration
    if [ -f "${RDA_HOME}/rda.cfg" ] &&
        $EGREP "^D_RDA_.*=" "${RDA_HOME}/rda.cfg" >/dev/null 2>&1
    then
        $ECHO 'Custom RDA configuration'
    fi

    # Condition 5: No alternative engine locations
    if [ -f "${ENG_HOME}/rda.cfg" ]
    then
        DIR=`$EGREP "^D_RDA=" "${ENG_HOME}/rda.cfg"`
        DIR=`$EXPR "$DIR" : 'D_RDA="\(.*\)"' || :`
        if [ -n "$DIR" ]
        then
            if [ "$DIR" != ".." -a "$DIR" != "${RDA_HOME}" ]
            then
                $ECHO 'Alternative RDA engine directory found'
                exit 83
            fi
        fi
    fi
}

# Deploy RDA
deploy_rda()
{
    # Extract payload
    cd "$ORACLE_HOME"
    "$JAR" -xvf "${KITLOC}/payload.zip"
    cd "$CWD"

    # Align ownership
    $CHOWN -R $RDAUID:$RDAGID "$RDA_HOME"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}"/rda.*
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}"/irda.*
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}"/*.txt
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/Convert"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/IRDA"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/RDA"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/da"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/dfw"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/engine"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/hcve"
    $CHOWN -R $RDAUID:$RDAGID "${RDA_HOME}/modules"

    # Set permissions
    $CHMOD 750 "$RDA_HOME"
    $FIND "${RDA_HOME}/Convert" -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/IRDA"    -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/RDA"     -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/da"      -type d -exec $CHMOD 700 {} \;
    $FIND "${RDA_HOME}/dfw"     -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/engine"  -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/hcve"    -type d -exec $CHMOD 750 {} \;
    $FIND "${RDA_HOME}/modules" -type d -exec $CHMOD 750 {} \;

    $CHMOD 550 "${RDA_HOME}"/rda.*
    $CHMOD 550 "${RDA_HOME}"/irda.*
    $CHMOD 440 "${RDA_HOME}"/*.txt
    $CHMOD 440 "${ENG_HOME}"/*.txt
    $FIND "${RDA_HOME}/Convert" -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/IRDA"    -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/RDA"     -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/da"      -type f -exec $CHMOD 400 {} \;
    $FIND "${RDA_HOME}/dfw"     -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/hcve"    -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/modules" -type f -exec $CHMOD 440 {} \;
    $FIND "${RDA_HOME}/da"      -name '*.sh' -exec $CHMOD u+x {} \;
}

# Install RDA
CWD="$PWD"
KITLOC=`$DIRNAME "$0"`

RDA_HOME="${ORACLE_HOME}/rda"
ENG_HOME="${RDA_HOME}/engine"
if [ -d "$RDA_HOME" ]
then
    $CHMOD u+w "$RDA_HOME"

    # Check if deployment can take place
    can_deploy_rda

    if [ ! -w "$RDA_HOME" ]
    then
        $ECHO 'No permissions to install or upgrade RDA'
        exit 83
    fi

    # Install a newer RDA version
    if [ -f "${RDA_HOME}/modules/rda.dat" ]
    then
        STR=`$EGREP "^# .*Build: " "${RDA_HOME}/modules/rda.dat"`
        REF=`$EXPR "$STR" : ".*Build.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)" || :`
        if [ -z "$REF" ]
        then
            REF='000000'
        fi
    else
        REF='000000'
    fi
    STR=`$GREP "rda-build: " "${KITLOC}/META-INF/MANIFEST.MF"`
    BLD=`$EXPR "$STR" : "rda-build: \([0-9][0-9][0-9][0-9][0-9][0-9]\)" || :`
    if [ "$BLD" -gt "$REF" ]
    then
        # Get expected user and group identifier
        RDAUID=`$LS -Lnd "$RDA_HOME" | $SED -e "s/[ \t][ \t]*/:/g" | $CUT -d: -f3`
        RDAGID=`$LS -Lnd "$RDA_HOME" | $SED -e "s/[ \t][ \t]*/:/g" | $CUT -d: -f4`

        # Make the file writable
        $CHMOD u+w "${RDA_HOME}"/rda.*  2>/dev/null || :
        $CHMOD u+w "${RDA_HOME}"/irda.* 2>/dev/null || :
        $CHMOD u+w "${RDA_HOME}"/*.txt  2>/dev/null || :
        if [ -d "${RDA_HOME}/Convert" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/Convert"
        fi
        if [ -d "${RDA_HOME}/IRDA" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/IRDA"
        fi
        if [ -d "${RDA_HOME}/RDA" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/RDA"
        fi
        if [ -d "${RDA_HOME}/da" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/da"
        fi
        if [ -d "${RDA_HOME}/dfw" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/dfw"
        fi
        if [ -d "${RDA_HOME}/hcve" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/hcve"
        fi
        if [ -d "${RDA_HOME}/modules" ]
        then
            $CHMOD -R u+w "${RDA_HOME}/modules"
        fi

        if [ -d "${ENG_HOME}" ]
        then
            $CHMOD u+w "${ENG_HOME}"
            $CHMOD u+w "${ENG_HOME}"/*.txt 2>/dev/null || :
            $RM -f "${ENG_HOME}/rda.dft"
        fi

        # Install RDA
        deploy_rda
    fi
else
    # Get expected user and group identifier
    RDAUID=`$LS -Lnd "$CCR_HOME" | $SED -e "s/[ \t][ \t]*/:/g" | $CUT -d: -f3`
    RDAGID=`$LS -Lnd "$CCR_HOME" | $SED -e "s/[ \t][ \t]*/:/g" | $CUT -d: -f4`

    # Install RDA
    deploy_rda
fi

exit 0
