' $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/install.vbs,v 2.7 2011/03/25 09:28:54 ldens Exp $
'
' install.vbs
'
' Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved.
'
'    NAME
'      install.vbs - CCR Package install software script
'
'    DESCRIPTION
'      This script is invoked by the Oracle CCR package deployment
'      process and is used to unpack the distribution in the target
'      directory. 
'
'    MODIFIED   (MM/DD/YY)
'    ldens       03/25/11 - Change the copyright notice
'    ldens       01/13/11 - Enhance it for OCM 10.3.4
'    ldens       11/24/10 - Enhance it for IRDA inclusion
'    mschenke    04/25/07 - Adapt it for RDA deployment
'    nemalhot    05/22/06 - Fixing null value checks 
'    ndutko      05/15/06 - 
'    jsutton     05/12/06 - Alternate approach to getting output from 
'                           subprocesses 
'    ndutko      05/12/06 - Handle case of spaces in JAVA_HOME 
'    nemalhot    05/08/06 - convert OracleHome to lowercase 
'    jsutton     05/05/06 - Remove extra print of error info 
'    jsutton     01/24/06 - Creation; lifted from unix .sh variant
'
'
' LiveLink installation and deployment of the RDA package
'

Option Explicit

Dim WshShell, WshEnv

Dim ExecCommand
Dim oExec, oStdErr, oStdOut

Dim FSO
Const ReadOnly = 1
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Dim CcrHome, CcrCfgHome, OracleHome, JavaHome, JavaHomeEnv

Set WshShell = WScript.CreateObject("WScript.Shell")
Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshEnv = WshShell.Environment("PROCESS")

' Include core utility
IncludeCoreUtils

' Get the CCR home 
CcrHome = WshEnv("CCR_HOME")
If (isUninitialized(CcrHome)) Then
 WScript.Echo "CCR Home is not defined"
 WScript.Quit(1)
End If

'Get the Oracle home
OracleHome = LCase(FSO.GetParentFolderName(CcrHome))

' First look for JAVA_HOME_CCR, then for JAVA_HOME
JavaHomeEnv = UnquoteString(WshEnv("JAVA_HOME_CCR"))
If (isUninitialized(JavaHomeEnv)) Then
    JavaHomeEnv = UnquoteString(WshEnv("JAVA_HOME"))
End If

If (isUninitialized(JavaHomeEnv)) Then
  JavaHomeEnv = OracleHome & "\jdk"
Else
  If (FSO.FolderExists(JavaHomeEnv)) Then
    JavaHomeEnv = FSO.GetFolder(JavaHomeEnv).ShortPath
  End If
End If
JavaHome = JavaHomeEnv & "\bin"

' If jdk/jar is available then use it, Otherwise use our util.
Dim JarExe : JarExe = FSO.BuildPath(JavaHome, "jar.exe")
Dim CcrHomeBin : CcrHomeBin = FSO.BuildPath(CcrHome, "bin")
If (Not FSO.FileExists(JarExe)) Then
   JarExe = FSO.BuildPath(CcrHomeBin, "ocmJarUtil.bat")
   If (Not FSO.FileExists(JarExe)) Then
      WScript.Echo "OCM JAR Util is not found."
      WScript.Quit(1)
   End If
End If

' Get the execution context
Dim CurrentDir, EngHome, KitBuild, KitDir, RdaHome
KitDir = Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName, "\"))
CurrentDir = FSO.GetFolder(".")
RdaHome = OracleHome & "\rda"
EngHome = RdaHome & "\engine"

' Install RDA
If (FSO.FolderExists(RdaHome)) Then
  ' Check if deployment can take place
  Call CanDeployRda()

  ' Get the kit build
  KitBuild = GetKitBuild(KitDir & "META-INF\MANIFEST.MF")
  printDebug "** RDA: Kit Build=" & KitBuild

  ' Upgrade RDA as needed
  If isNeeded() Then
    ' Upgrade RDA
    printDebug "** RDA: Deploy RDA"
    WshShell.CurrentDirectory = OracleHome
    Call runProc(JarExe, " xf " & KitDir & "payload.zip")
    WshShell.CurrentDirectory = CurrentDir
  End If
Else
  ' Install RDA
  printDebug "** RDA: Install RDA"
  WshShell.CurrentDirectory = OracleHome
  Call runProc(JarExe, " xf " & KitDir & "payload.zip")
  WshShell.CurrentDirectory = CurrentDir
End If

' Indicate a successful return
WScript.Quit(0)

' Includes the core utility file.
Private Sub IncludeCoreUtils
  Dim CoreUtils
  ' Get directory context of the script, coreutils must be in the same directory
  CoreUtils = LCase(Left(WScript.ScriptFullName, _
                         InStrRev(WScript.ScriptFullName, "\")))
  CoreUtils = CoreUtils & "coreutil.vbs"
  IncludeFileAbs CoreUtils
End Sub

' Includes a file in the global namespace of the current script.
' The file can contain any VBScript source code.
' The path of the file name must be specified absolute (or
' relative to the current directory).
Private Sub IncludeFileAbs (ByVal FileName)
  Dim f: set f = FSO.OpenTextFile(FileName, ForReading)
  Dim s: s = f.ReadAll()
  ExecuteGlobal s
End Sub


' Check the deployment conditions
Private Sub CanDeployRda
  ' Condition 1: Upgrade not disabled
  printDebug "** RDA: Check deployment condition 1"
  If hasPattern("^NO_UPGRADE=\042.*\042", RdaHome & "\rda.cfg") Then
    WScript.Echo "RDA upgrade disabled"
    WScript.Quit(83)
  End If

  ' Condition 2: Writable directory
  printDebug "** RDA: Check deployment condition 2"
  If (FSO.FolderExists(RdaHome) And _
      (FSO.GetFolder(RdaHome).Attributes And ReadOnly)) Then
    WScript.Echo "Directory " & RdaHome & " not writable"
    WScript.Quit(83)
  End If

  ' Condition 3: Not an IRDA bootstrap
  printDebug "** RDA: Check deployment condition 3"
  If hasPattern("^RDA_HOME=", RdaHome & "\irdacfg.ini") Then
    WScript.Echo "IRDA bootstrap found in " & RdaHome
    WScript.Quit(83)
  End If

  ' Condition 4: Default RDA configuration
  printDebug "** RDA: Check deployment condition 4"
  If hasPattern("^D_RDA_.*=", RdaHome & "\rda.cfg") Then
    WScript.Echo "Custom RDA configuraton found in " & RdaHome
    WScript.Quit(83)
  End If

  ' Condition 5: No alternative engine locations
  printDebug "** RDA: Check deployment condition 5"
  If FSO.FolderExists(EngHome) And FSO.FileExists(EngHome & "\rda.cfg") Then
    If AltEngFound(EngHome & "\rda.cfg") Then
      WScript.Echo "Alternative RDA engine directory found!"
      WScript.Quit(83)
    End If
  End If
End Sub

' Check if an alternative engine directory is found
Private Function AltEngFound(ByVal EngConfigFile)
  Dim AltEngDir, IFH, Match, Matches, RE, TextLine
  Set IFH = FSO.OpenTextFile(EngConfigFile, ForReading)
  Set RE = New RegExp
  RE.Pattern = "^D_RDA=\042(.*)\042"
  RE.IgnoreCase = False
  Do While (IFH.AtEndOfStream <> True)
    TextLine = IFH.ReadLine
    Set Matches = RE.Execute(TextLine)
    For Each Match in Matches
      AltEngDir = Match.Submatches(0)
      If Not (AltEngDir = ".." Or AltEngDir = RdaHome) Then
        IFH.Close
        AltEngFound = True
        Exit Function
      End if
    Next
  Loop
  IFH.Close
  AltEngFound = False
End Function

' Get the component build
Private Function GetKitBuild (ByVal Path)
  If (FSO.FileExists(Path)) Then
    Dim IFH, Match, Matches, RE, TextLine
    Set IFH = FSO.OpenTextFile(Path, ForReading)
    Set RE = New RegExp
    RE.Pattern = "rda-build: (\d{6})"
    RE.IgnoreCase = False
    Do While (IFH.AtEndOfStream <> True)
      TextLine = IFH.ReadLine
      Set Matches = RE.Execute(TextLine)
      For Each Match in Matches
        IFH.Close
        GetKitBuild = Match.Submatches(0)
        Exit Function
      Next
    Loop
    IFH.Close
  End If
  GetKitBuild = "000000"
End Function

' Indicate whether a pattern in present in a file
Private Function hasPattern (ByVal Pattern, ByVal Path)
  If (FSO.FileExists(Path)) Then
    Dim IFH, Match, Matches, RE, TextLine
    Set IFH = FSO.OpenTextFile(Path, ForReading)
    Set RE = New RegExp
    RE.Pattern = Pattern
    RE.IgnoreCase = False
    Do While (IFH.AtEndOfStream <> True)
      TextLine = IFH.ReadLine
      If RE.Test(TextLine) Then
        IFH.Close
        hasPattern = True
        Exit Function
      End If
    Loop
    IFH.Close
  End If
  hasPattern = False
End Function

' Determine whether the RDA upgrade is needed
Private Function isNeeded
  ' Do not overwrite more recent builds
  Dim Path
  Path = RdaHome & "\modules\rda.dat"
  If (FSO.FileExists(Path)) Then
    Dim IFH, Match, Matches, RdaBuild, RE, TextLine
    Set IFH = FSO.OpenTextFile(Path, ForReading)
    Set RE = New RegExp
    RE.Pattern = "^# \$Build: \d+\.\d+-(\d{6})"
    RE.IgnoreCase = False
    Do While (IFH.AtEndOfStream <> True)
      TextLine = IFH.ReadLine
      Set Matches = RE.Execute(TextLine)
      For Each Match in Matches
        IFH.Close
        RdaBuild = Match.Submatches(0)
        printDebug "** RDA: build=" & RdaBuild
        isNeeded = (RdaBuild < KitBuild)
        Exit Function
      Next
    Loop
    IFH.Close
  End If
  isNeeded = True
End Function

