#!/bin/sh
#
# $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/postinstall.sh,v 2.7 2011/12/22 16:38:05 mschenke Exp $
#
# postinstall.sh
#
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      postinstall.sh - CCR Package postinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process after install.sh and is used to reset file permissions,
#      etc. 
#
#    MODIFIED   (MM/DD/YY)
#    ldens       12/22/11 - Work around protection issue on AIX.
#    ldens       03/25/11 - Change the copyright notice
#    ldens       11/15/10 - Initial version for the RDA component
#    mschenke    04/25/07 - Adapt it for RDA deployment
#    ndutko      03/07/06 - Correct location for UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Port specific changes for generic mechanism for 
#                           getting uid 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

if [ "${RDA_OCM_TRACE:=0}" -ge 0 ]
then
    set -x
fi

_usrBinDir=/usr/bin
_binDir=/bin

CHMOD=${_binDir}/chmod
RM=${_binDir}/rm

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

# Delete obsolete RDA components
CCR_REPO="${CCR_HOME}/inventory"
if [ -f "${CCR_REPO}/rda.jar" ]
then
    $CHMOD u+w "${CCR_REPO}/rda.jar" || :
fi
if [ -f "${CCR_REPO}/urda.jar" ]
then
    $RM -f "${CCR_REPO}/urda.jar" || :
fi
if [ -f "${CCR_REPO}/wrda.jar" ]
then
    $RM -f "${CCR_REPO}/wrda.jar" || :
fi

exit 0
