' $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/postinstall.vbs,v 2.5 2011/03/25 11:38:25 ldens Exp $
'
' postinstall.vbs
'
' Copyright (c) 2002, 2011, Oracle and/or its affiliates. All rights reserved.
'
'    NAME
'      postinstall.vbs - CCR Package postinstall software script
'
'    DESCRIPTION
'      This script is invoked by the Oracle CCR package deployment
'      process after install.vbs and is used to reset file permissions,
'      etc. 
'
'    MODIFIED   (MM/DD/YY)
'    ldens       03/25/11 - Update the copyright notice
'    ldens       11/24/10 - Enhance it for RDA deployment
'    jsutton     01/24/06 - Creation; lifted from unix .sh variant
'
Option Explicit

Dim CcrHome, FSO, Path, WshEnv, WshShell

Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshShell = WScript.CreateObject("WScript.Shell")
Set WshEnv = WshShell.Environment("PROCESS")

' Include core utility
IncludeCoreUtils

' Get the CCR Home
CcrHome = WshEnv("CCR_HOME")
If (isUninitialized(CcrHome)) Then
  WScript.Echo "CCR Home is not defined"
  WScript.Quit(1)
End If

' Delete obsolete RDA components
Path = CcrHome & "\inventory\urda.jar"
If FSO.FileExists(Path) Then
  FSO.DeleteFile Path, True
End If

Path = CcrHome & "\inventory\wrda.jar"
If FSO.FileExists(Path) Then
  FSO.DeleteFile Path, True
End If

' Indicate a succesfull return
WScript.Quit(0)

' Includes the core utility file.
Private Sub IncludeCoreUtils
  Dim CoreUtils
  ' Get directory context of the script, coreutils must be in the same directory
  CoreUtils = LCase(Left(WScript.ScriptFullName, _
                         InStrRev(WScript.ScriptFullName, "\")))
  CoreUtils = CoreUtils & "coreutil.vbs"
  IncludeFileAbs CoreUtils
End Sub

' Includes a file in the global namespace of the current script.
' The file can contain any VBScript source code.
' The path of the file name must be specified absolute (or
' relative to the current directory).
Private Sub IncludeFileAbs (ByVal FileName)
  Dim f: set f = FSO.OpenTextFile(FileName, ForReading)
  Dim s: s = f.ReadAll()
  ExecuteGlobal s
End Sub
