#!/bin/sh
#
# $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/uninstall.sh,v 2.8 2011/03/25 09:28:59 ldens Exp $
#
# uninstall.sh
#
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      uninstall.sh - CCR Package deinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      to deinstall the current version. 
#
#    MODIFIED   (MM/DD/YY)
#    ldens       03/25/11 - Change the copyright notice
#    ldens       01/27/11 - Prevent DBD::Oracle test
#    ldens       11/15/10 - Initial version for the RDA component
#    mschenke    04/25/07 - Adapt it for RDA deployment
#    rayleung    02/27/06 - add steps to remove calconfig.jar and 
#                           esemconfig.jar for OCS targets config data 
#                           collections 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

if [ "${RDA_OCM_TRACE:=0}" -ge 0 ]
then
    set -x
fi

_usrBinDir=/usr/bin
_binDir=/bin

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

# Delete obsolete files
RDA_HOME="${ORACLE_HOME}/rda"
if [ -r "${RDA_HOME}/rda.cfg" ] &&
    $EGREP '^NO_UPGRADE=".*"' "${RDA_HOME}/rda.cfg"
then
    exit 0
elif [ -x "${RDA_HOME}/rda.sh" ]
then
    RDA_NO_DBD_ORACLE=1
    export RDA_NO_DBD_ORACLE
    "${RDA_HOME}/rda.sh" -XUpgrade files
fi

exit 0
