' $Header: /home/cvs/cvs/RDA_4/src/scripting/adm/ocm/uninstall.vbs,v 2.5 2011/03/25 09:28:55 ldens Exp $
'
' uninstall.vbs
'
' Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved.
'
'    NAME
'      uninstall.vbs - CCR Package deinstall software script
'
'    DESCRIPTION
'      This script is invoked by the Oracle CCR package deployment
'      to deinstall the current version. 
'
'    MODIFIED   (MM/DD/YY)
'    ldens       03/25/11 - Change the copyright notice
'    ldens       01/27/11 - Prevent DBD::Oracle test
'    ldens       11/25/10 - Enhance RDA deployment
'    mschenke    04/25/07 - Adapt it for RDA deployment
'    nemalhot    05/22/06 - Fixing null value checks 
'    kgupta      05/03/06 - Bringing in sync with linux label 
'    jsutton     03/13/06 - Clean up syntax problems 
'    jsutton     01/24/06 - Creation; lifted from unix .sh variant
'
Option Explicit

' Set Execution Context
Dim CcrHome, FSO, RdaHome, WshEnv, WshShell

Const ForReading = 1

Set WshShell = WScript.CreateObject("WScript.Shell")
Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshEnv = WshShell.Environment("PROCESS")

CcrHome = WshEnv("CCR_HOME")
If (isUninitialized(CcrHome)) Then
  WScript.Echo "CCR Home is not defined"
  WScript.Quit(1)
End If

' Delete obsolete files
RdaHome = LCase(FSO.GetParentFolderName(CcrHome)) & "\rda"
If hasNotPattern("^NO_UPGRADE=\042.*\042", RdaHome & "\rda.cfg") Then
  If FSO.FileExists(RdaHome & "\rda.cmd") Then
    WshEnv("RDA_NO_DBD_ORACLE") = "1"
    WshShell.Run RdaHome & "\rda.cmd -XUpgrade files >NUL 2>NUL", 2, True
  End If
End If

' Indicate a successful return
WScript.Quit(0)

' Indicate whether a pattern in not present in a file
Private Function hasNotPattern (ByVal Pattern, ByVal Path)
  If (FSO.FileExists(Path)) Then
    Dim IFH, Match, Matches, RE, TextLine
    Set IFH = FSO.OpenTextFile(Path, ForReading)
    Set RE = New RegExp
    RE.Pattern = Pattern
    RE.IgnoreCase = False
    Do While (IFH.AtEndOfStream <> True)
      TextLine = IFH.ReadLine
      If RE.Test(TextLine) Then
        IFH.Close
        hasNotPattern = False
        Exit Function
      End If
    Loop
    IFH.Close
  End If
  hasNotPattern = True
End Function

' Check if the string is uninitialized
Private Function isUninitialized (ByVal var)
  If (IsEmpty(var) Or IsNull(var) Or Len(var)=0) then
    isUninitialized = True
  Else
    isUninitialized = False
  End If
End Function

