#!/bin/sh
#
# $Header: emll/install/engines/install.sh /main/18 2012/02/13 14:12:21 jsutton Exp $
#
# install.sh
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      install.sh - CCR Package install software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process and is used to unpack the distribution in the target
#      directory. 
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     02/13/12 - use relative path to instantiate_files
#    jsutton     12/21/11 - fix instantiations 
#    jsutton     11/10/11 - instantiation tweaks
#    jsutton     09/14/11 - instantiate, then remove template files
#    tsubrama    01/13/09 - no jdk jar dependency
#    aghanti     08/06/07 - XbranchMerge aghanti_bug-6318902 from
#                           st_emll_10.2.6
#    ndutko      06/26/07 - XbranchMerge ndutko_bug-6119067 from st_emll_10.2.6
#    ndutko      06/15/07 - Create a symlink for the libexpat issue on Suse10
#    pparida     03/24/06 - Use JAR instead of UNZIP to extract 
#    ndutko      03/07/06 - Conditional location of UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      10/17/05 - Add alternate path for unzip 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

#
# LiveLink installation and deployment of the LiveLink Engines package
#

_usrBinDir=/usr/bin
_binDir=/bin
_usrLocalBinDir=/usr/local/bin

DIRNAME=${_usrBinDir}/dirname
LNS="${_binDir}/ln -s"
MKDIRP="${_binDir}/mkdir -p"
RMRF="${_binDir}/rm -rf"
SED=${_binDir}/sed
TAR=${_binDir}/tar

if [ -f ${_binDir}/egrep ]
then
    EGREP=${_binDir}/egrep
elif [ -f ${_usrBinDir}/egrep ]
then
    EGREP=${_usrBinDir}/egrep
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

if [ ! -z "${JAVA_HOME_CCR}" ]
then
    _JAVA_HOME=${JAVA_HOME_CCR}
elif [ ! -z "${JAVA_HOME}" ]
    then    
        _JAVA_HOME=${JAVA_HOME}
    else    
        _JAVA_HOME=${ORACLE_HOME}/jdk
fi

# find jre home, if jdk home is not found
if [ ! -f ${_JAVA_HOME}/bin/java ]
then
   _JAVA_HOME=${ORACLE_HOME}/jre
fi

# will need java later
JAVA=${_JAVA_HOME}/bin/java

#
#Use jdk/jar if available, Otherwise use our util.
#
if [ -f ${_JAVA_HOME}/bin/jar ] 
then
  JAR=${_JAVA_HOME}/bin/jar
else
  if [ -f ${CCR_HOME}/bin/ocmJarUtil ]
  then
    JAR=${CCR_HOME}/bin/ocmJarUtil
  else
    echo "OCM JAR Util is not found"
    exit 3
  fi
fi

CWD=$PWD
KITLOC=`$DIRNAME $0`

if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

cd $KITLOC
$JAR -xvf payload.zip

cd ${CCR_HOME}
if [ -d engines ]; then
   $RMRF engines
fi;

$MKDIRP engines/${PLATFORM}/perl
cd ${CCR_HOME}/engines/${PLATFORM}/perl

$TAR -xf ${KITLOC}/perl.tar

# use appropriate perlarch directory
_osArch=`$JAVA -cp ${CCR_HOME}/lib/emocmcommon.jar:${CCR_HOME}/lib/emocmutl.jar:${CCR_HOME}/lib OsInfo`

if [ "${PLATFORM}" = "AIX" ] ; then
  PERLARCH="aix-thread-multi"
elif [ "${PLATFORM}" = "HP-UX" ] ; then
  if [ "${_osArch}" = "IA64" -o  "${_osArch}" = "IA64N" -o  "${_osArch}" = "IA64W" ] ; then
    PERLARCH="IA64.ARCHREV_0-thread-multi-LP64"
  else  # PA_RISC*
    PERLARCH="PA-RISC2.0-thread-multi"
  fi
elif [ "${PLATFORM}" = "Linux" ] ; then
  if [ "${_osArch}" = "ia64" ] ; then
    PERLARCH="IA64LINUX-thread-multi"
  elif [ "${_osArch}" = "ppc" -o  "${_osArch}" = "ppc64" ] ; then
    PERLARCH="PLinux-thread-multi"
  elif [ "${_osArch}" = "s390" -o  "${_osArch}" = "s390x" ] ; then
    PERLARCH="s390x-linux"
  else  # *86
    PERLARCH="i686-linux-thread-multi"
  fi
elif [ "${PLATFORM}" = "SunOS" ] ; then
  if [ "${_osArch}" = "sparc" -o "${_osArch}" = "sparcv9" ] ; then
    PERLARCH="sun4-solaris-thread-multi"
  else  # *86
    PERLARCH="i86pc-solaris-thread-multi"
  fi
fi

_doInstantiations=0

## jrs not sure why I thought we could skip for ppc?
#
#if [ "${PLATFORM}" = "Linux" ] ; then
#  if [ ! "${_osArch}" = "ppc" -o  "${_osArch}" = "ppc64" ] ; then
#    _doInstantiations=1
#  fi
#fi

if [ ${_doInstantiations} -eq 0 ] ; then
  # Instantiate template files
  cd ./instantiate_files

  $EGREP -v "^(## Configured by|## Target system|cf_by=|cf_email=|perladmin=|myhostname=|mydomain=|myuname=)" Config.pm > Config.pm.tmp

  # this ugliness is due to what we get from the PERL label consumed on Linux IA64
  if [ "${PERLARCH}" = "IA64LINUX-thread-multi" ] ; then
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?ia64-linux-thread-multi?${PERLARCH}?g" config.h  > ../lib/5.8.3/${PERLARCH}/CORE/config.h
    $SED -e "s?2\.4\.21\-20\.el?2\.4\.21\-37\.el?" -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?ia64-linux-thread-multi?${PERLARCH}?g" Config.pm.tmp > ../lib/5.8.3/${PERLARCH}/Config.pm
  # and THIS ugliness is due to what we get from the PERL label consumed on Solaris x86
  elif [ "${PERLARCH}" = "i86pc-solaris-thread-multi" ] ; then
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?sun4-solaris-thread-multi?${PERLARCH}?g" config.h  > ../lib/5.8.3/${PERLARCH}/CORE/config.h
    $SED -e "s?2\.8?2\.9?" -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?sun4-solaris-thread-multi?${PERLARCH}?g" Config.pm.tmp > ../lib/5.8.3/${PERLARCH}/Config.pm
  # and for Linux PPC
  elif [ "${PERLARCH}" = "PLinux-thread-multi" ] ; then
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?i686-linux-thread-multi?${PERLARCH}?g" config.h  > ../lib/5.8.3/${PERLARCH}/CORE/config.h
    $SED -e "s?2\.4\.21\-37\.elsmp?2\.6\.9\-34\.el?" -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?i686-linux-thread-multi?${PERLARCH}?g" Config.pm.tmp > ../lib/5.8.3/${PERLARCH}/Config.pm
  # and for Linux ZSeries
  elif [ "${PERLARCH}" = "s390x-linux" ] ; then
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?i686-linux-thread-multi?${PERLARCH}?g" config.h  > ../lib/5.8.3/${PERLARCH}/CORE/config.h
    $SED -e "s?2\.4\.21\-37\.elsmp?2\.6\.5\-7\.191\-s390x?" -e "s?%ORACLE_HOME%?${CCR_HOME}?g" -e "s?i686-linux-thread-multi?${PERLARCH}?g" Config.pm.tmp > ../lib/5.8.3/${PERLARCH}/Config.pm
  else
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" config.h  > ../lib/5.8.3/${PERLARCH}/CORE/config.h
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" Config.pm > ../lib/5.8.3/${PERLARCH}/Config.pm
  fi

  $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" perllocal.pod  > ../lib/5.8.3/${PERLARCH}/perllocal.pod

  for PERL_FILE in GET HEAD POST c2ph cpan dbiprof dbiproxy dprofpp enc2xs find2perl h2ph h2xs instmodsh libnetcfg lwp-download lwp-mirror lwp-request lwp-rget ora_explain perlbug perlcc perldoc perlivp piconv pl2pm pod2html pod2latex pod2man pod2text pod2usage podchecker podselect prove psed pstruct s2p splain xsubpp
  do
    $SED -e "s?%ORACLE_HOME%?${CCR_HOME}?g" ${PERL_FILE} > ../bin/${PERL_FILE}
  done
  cd ..
fi

$RMRF ./instantiate_files

# Handle condition where on Linux, the location of libexpat.so is
# not used or found when updated such as in Suse10.
# Create a symlink to the library that is present in the engines
# directory (only if the link does not exist).
if [ "${PLATFORM}" = "Linux" ]; then
   if [ ! -e ${CCR_HOME}/engines/${PLATFORM}/perl/lib/5.8.3/libexpat.so.0 ]; then
	$LNS ${CCR_HOME}/engines/${PLATFORM}/perl/lib/libexpat.so.0.5.0 \
	     ${CCR_HOME}/engines/${PLATFORM}/perl/lib/5.8.3/libexpat.so.0
   fi
fi

cd $CWD

exit 0
