#!/bin/sh
#
# $Header: emll/install/engines/postinstall.sh /st_emll_10.3.8/1 2013/01/17 12:36:06 jsutton Exp $
#
# postinstall.sh
#
# Copyright (c) 2005, 2013, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      postinstall.sh - CCR Package postinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process after install.sh and is used to reset file permissions,
#      etc. 
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     01/16/13 - For some platforms, require x permission
#    jsutton     05/10/12 - fix file permissions
#    jsutton     04/22/11 - chown to ccr tree owner, not current process UID
#    nemalhot    06/19/07 - Allow group and other users to execute perl
#                           binaries.
#    pparida     03/28/06 - Use $PWD instead of `pwd` 
#    cvaishna    03/23/06 - fix for bug 4908844 
#    cvaishna    03/07/06 - Bug Fix : 4908844 
#    cvaishna    03/07/06 - Fix for the execute permissons on porting 
#                           platforms like HP-UX 
#    ndutko      03/07/06 - Conditional location of UNAME 
#    cvaishna    03/03/06 - Fix for differnt behaviour of TRAP 
#    cvaishna    03/03/06 - Bug Fix : 4908827 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Port specific changes for generic mechanism for 
#                           getting uid 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin

AWK=${_binDir}/awk
CHMOD=${_binDir}/chmod
CHOWN=${_binDir}/chown
FIND=${_usrBinDir}/find
LS=${_binDir}/ls

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

ID=${_usrBinDir}/id

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

CWD=$PWD

#
# LiveLink installation and deployment of the LiveLink Engines package
#
if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

# Initialize ccr owner and group 
ccrOwner=`$LS -Llnd $CCR_HOME |$AWK '{print $3}'`
ccrGroup=`$LS -Llnd $CCR_HOME |$AWK '{print $4}'`

#
# Recurse through the directory and reset the file protections.
#
$CHOWN -R "$ccrOwner:$ccrGroup" ${CCR_HOME}/engines/${PLATFORM}
$CHMOD -R 750 ${CCR_HOME}/engines/${PLATFORM}

#
# ONLY Linux and SunOS can have permissions tightened; others require the x bit as set above.
# See bugs 4908844, 16179565.
#
if [ "${PLATFORM}" = "Linux" -o "${PLATFORM}" = "SunOS" ]
then
    $FIND ${CCR_HOME}/engines/${PLATFORM} \
          -type f -exec $CHMOD 640 {} \;
    $CHMOD 750 ${CCR_HOME}/engines/${PLATFORM}/perl/bin/perl
fi

exit 0
