#!/bin/sh
#
# $Header: uninstall.sh 07-mar-2006.15:42:10 ndutko Exp $
#
# uninstall.sh
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      uninstall.sh - CCR Package deinstall software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      to deinstall the current version. 
#
#    MODIFIED   (MM/DD/YY)
#    ndutko      03/07/06 - Conditional location of UNAME 
#    ndutko      10/07/05 - CCR Cutover 
#    ndutko      09/29/05 - Register a trap handler such that if an error 
#                           occurs, the command exit code is percolated back 
#                           up 
#    ndutko      09/27/05 - Remove references/uses of typeset - not portable 
#    ndutko      08/03/05 - ndutko_code_checkin
#    ndutko      07/21/05 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

RMRF="${_binDir}/rm -rf"

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1`

#
# LiveLink installation and deployment of the LiveLink Engines package
#
if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

if [ -d ${CCR_HOME}/engines/$PLATFORM ]; then
   $RMRF ${CCR_HOME}/engines/$PLATFORM
fi;

exit 0
