#!/bin/sh
#
# $Header: emll/install/metricdata/install.sh /main/3 2009/02/25 04:21:27 mswamyt Exp $
#
# install.sh
#
# Copyright (c) 2006, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      install.sh - OCM Install script for metricdata package
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    01/13/09 - no jdk jar dependency
#    ndutko      07/31/07 - Movement of metric data to CCR_HOME/data directory
#    ndutko      09/25/06 - Installation scripts for Unix' of the configuration
#                           collection packages
#    ndutko      09/25/06 - Creation
#

_usrBinDir=/usr/bin
_binDir=/bin
_usrLocalBinDir=/usr/local/bin

CHMOD=${_binDir}/chmod
DIRNAME=${_usrBinDir}/dirname
MKDIR=${_binDir}/mkdir

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

if [ ! -z "${JAVA_HOME_CCR}" ]
then
    _JAVA_HOME=${JAVA_HOME_CCR}
elif [ ! -z "${JAVA_HOME}" ]
    then
        _JAVA_HOME=${JAVA_HOME}
    else
        _JAVA_HOME=${ORACLE_HOME}/jdk
fi

# find jre home, if jdk home is not found
if [ ! -f ${_JAVA_HOME}/bin/java ]
then
  _JAVA_HOME=${ORACLE_HOME}/jre
fi

#
#Use jdk/jar if available, Otherwise use our util.
#
if [ -f ${_JAVA_HOME}/bin/jar ] 
then
  JAR=${_JAVA_HOME}/bin/jar
else
  if [ -f ${CCR_HOME}/bin/ocmJarUtil ]
  then
     JAR=${CCR_HOME}/bin/ocmJarUtil
  else
     echo "OCM JAR Util is not found"
     exit 3 
  fi
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

CWD=$PWD
KITLOC=`$DIRNAME $0`

if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

$MKDIR $CCR_HOME/data
$CHMOD 740 $CCR_HOME/data

cd $CCR_HOME/data
$JAR -xvf ${KITLOC}/payload.zip
cd $CWD

exit 0
