#!/bin/sh
#
# $Header: orarun.sh 06-feb-2006.18:16:22 njerath Exp $
#
# orarun.sh
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      orarun.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#     njerath  02/06/06 - XbranchMerge njerath_misc_prereq_fixup_2 from main 
#     vsubrahm 02/02/06 - XbranchMerge vsubrahm_orarun_target from main 
#     vsubrahm 01/27/06 -  Fix the variable name for shell limits
#     njerath  12/04/05 - Changed constant names for base urls
#     njerath  11/27/05 - Added more fixups
#       vsubrahm 10/22/05 - 
#   
#    vsubrahm    10/22/05  - changing add user to group to includ groups user belongs to
#    vsubrahm    10/18/05  -  Adding fixup for mount parameters
#    vsagar      10/26/05  - 
#    vsubrahm    10/22/05 -    
#    vsubrahm    10/22/05  - changing add user to group to includ groups user belongs to
#    vsubrahm    10/18/05  -  Adding fixup for mount parameters
#    gmanglik    09/02/05  - add fix up for central inventory permissions 
#    vsburahm    08/26/05 -  Added fixup for adding user to groups
#    bpaliwal    08/25/05 -  use tee to output the progress / errors an log
#    vsubrahm    07/26/05 - Changes for Shell limits 
#    suravind    07/15/05 - suravind_updation_prereq_xml
#    vsubrahm    07/06/05 - Creation
#
set -x
#Assign command line params 1 and 2 to response file and enable file

# Helper function to verify an address is associated with an interface
resp_file=$1
enable_file=$2
log_file=$3
#If both files are not specified look for the files in the current directory
if [ $# -ne 3 ]
then
 resp_file="`pwd`/orarun.response"
 enable_file="`pwd`/orarun.enable"
 log_file="`pwd`"
fi
echo "This is the log file for orarun script" > $log_file/orarun.log
 if [ ! -f $resp_file -o ! -f $enable_file ]
 then
         echo "Nothing to fix!!" | tee -a $log_file/orarun.log
         exit 0
 fi
 if [ ! -r $resp_file -o ! -r $enable_file ]
 then
         echo "One or both of the input files are not readable" |tee -a $log_file/orarun.log
         exit 1
 fi

#check if user has given absolute/relative path or just filename
first_char=`expr "$resp_file" : '\(.\)'`
if [ "$first_char" != "/" -a "$first_char" != "." ]
then
 . ./$resp_file
else
. $resp_file
fi

first_char=`expr "$enable_file" : '\(.\)'`
if [ "$first_char" != "/" -a "$first_char" != "." ]
then
 . ./$enable_file
else
. $enable_file
fi

check_ifconfig()
{
    ADDR="$1"
    IFCONFIG="`/sbin/ifconfig 2>/dev/null`"
    if [ "$?" != 0 ]
    then
        echo "Unable to run ifconfig"
        return 1
    fi

    case "$IFCONFIG" in
    *addr:"$ADDR"*)
        return 0
        ;;
    *)
        ;;
    esac

    echo "IP address \"$ADDR\" is not associated with an interface"
    return 1
}

install_ocfs_packages()
{
   METHOD_INSTALL_OCFS="$1"
#install of ocfs
if [ "`echo $METHOD_INSTALL_OCFS | tr A-Z a-z`" == "true" ]
then
   METHOD_OCFS_RPMS="$2"
   METHOD_RPM_BASE_URL_OCFS="$3"
   METHOD_PROCESSOR="$4"
   for ocfs_rpm in $METHOD_OCFS_RPMS
   do
     full_ocfs_rpm=`echo $ocfs_rpm "$METHOD_PROCESSOR.rpm" | awk '$1 !~ /rpm$/ { print $1 "." $2 }'`
     if  test -z "$full_ocfs_rpm"
     then
        full_ocfs_rpm=$ocfs_rpm
     fi
     fullpath=${METHOD_RPM_BASE_URL_OCFS}/$full_ocfs_rpm
     if test -n "$fullpath" 
     then
        protocol="`expr $fullpath : '\(....\)'`"
        if [ "$protocol" == "http" ]
        then
            if test -n "$HTTP_PROXY" && test -n "$HTTP_PORT"
            then
               rpm -Uvh $fullpath --httpproxy $HTTP_PROXY --httpport $HTTP_PORT
               returncode=$?
            else    
             echo "Errors occured during installation of package:$ocfs_rpm. Either HTTP Proxy or HTTP Port not specified." | tee -a $logfile/orarun.log
            fi
        elif [ "$protocol" == "ftp:" ]
        then
           if test -n "$FTP_PROXY" && test -n "$FTP_PORT"
           then
              rpm -Uvh $fullpath --ftpproxy $FTP_PROXY --ftpport $FTP_PORT
              returncode=$?
           else
              echo "Errors occured during installation of package:$ocfs_rpm. Either FTP Proxy or FTP Port not specified." | tee -a $logfile/orarun.log
           fi
        else
            rpm -Uvh $fullpath
            returncode=$?
        fi
        if [ $? -ne 0 ]
        then
          echo "Errors occured during installation of package:$ocfs_rpm." | tee -a $logfile/orarun.log
        fi
     fi
   done 
fi
}

if [ "`echo $SET_KERNEL_PARAMETERS | tr A-Z a-z`" == "true" ]
then
    if [ ! -d /proc/sys/kernel ]; then
        echo "No sysctl kernel interface - cannot set kernel parameters." |tee -a $log_file/orarun.log
    fi
   
    if [ -n "$KERNEL_PARAMETERS_FILE" ]
    then
   
       if [ -r $KERNEL_PARAMETERS_FILE ]
       then
         $SYSCTL_LOC -p "$KERNEL_PARAMETERS_FILE"
         if [ $? -ne 0 ]
         then
            echo "Could not set the Kernel parameters." |tee -a $log_file/orarun.log
         fi
       else
         echo "File $KERNEL_PARAMETERS_FILE is not found/not readable" |tee -a $log_file/orarun.log
       fi
    
    else
        #delete the line containing parameter from conf file and replace with new value
	# Set shared memory parameters:
        #SHMMAX, SHMMNI, SHMALL
       if [ -n "$SHMMAX" ]
       then
          sed -e '/^[     | ]*kernel.shmmax/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "kernel.shmmax = $SHMMAX " >> /etc/sysctl.conf

          if  ! $SYSCTL_LOC -w kernel.shmmax="$SHMMAX"
          then
              echo "$SYSCTL_LOC failed to set shmmax" |tee -a $log_file/orarun.log
          fi
       fi

	if [ -n "$SHMMNI" ]
        then
          sed -e '/^[     | ]*kernel.shmmni/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "kernel.shmmni = $SHMMNI " >> /etc/sysctl.conf

          if  ! $SYSCTL_LOC -w kernel.shmmni="$SHMMNI"
          then
              echo "$SYSCTL_LOC failed to set shmmni" |tee -a $log_file/orarun.log
          fi
        fi
	
	if [ -n "$SHMALL" ]
        then
          sed -e '/^[     | ]*kernel.shmall/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "kernel.shmall = $SHMALL " >> /etc/sysctl.conf

           if  ! $SYSCTL_LOC -w kernel.shmall="$SHMALL"
           then
              echo "$SYSCTL_LOC failed to set shmall" |tee -a $log_file/orarun.log
           fi
	fi

	# Set the semaphore parameters:
        # SEMMSL, SEMMNS, SEMOPM, SEMMNI
        #Check if any of semaphores need to be set
	#All must be set at the same time, so first get those which need not be set
	#from /proc/sys/kernel/sem
	if [ -n "$SEMMSL" -o -n "$SEMMNS" -o -n "$SEMOPM" -o -n "$SEMMNI" ]
        then
          if [ -z "$SEMMSL" ]
          then
              SEMMSL="`awk '{print $1}' /proc/sys/kernel/sem`"
          fi

          if [ -z "$SEMMNS" ]
          then
              SEMMNS="`awk '{print $2}' /proc/sys/kernel/sem`"
          fi

          if [ -z "$SEMOPM" ]
          then
              SEMOPM="`awk '{print $3}' /proc/sys/kernel/sem`"
          fi

	  if [ -z "$SEMMNI" ]
          then
              SEMMNI="`awk '{print $4}' /proc/sys/kernel/sem`"
          fi

          sed -e '/^[     | ]*kernel.sem/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "kernel.sem = $SEMMSL $SEMMNS $SEMOPM $SEMMNI " >> /etc/sysctl.conf

          if ! $SYSCTL_LOC -w kernel.sem="$SEMMSL $SEMMNS $SEMOPM $SEMMNI"
          then
             echo "$SYSCTL_LOC failed to set semaphore parameters" |tee -a $log_file/orarun.log
          fi
       fi

	#FILE_MAX_KERNEL, IP_LOCAL_PORT_RANGE, RMEM_DEFAULT, WMEM_DEFAULT, RMEM_MAX, WMEM_MAX, VM_MAPPED_RATIO, AIO_MAX_SIZE
       if [ -n "$FILE_MAX_KERNEL" ]
       then
          sed -e '/^[     | ]*fs.file-max/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "fs.file-max = $FILE_MAX_KERNEL " >> /etc/sysctl.conf

          if ! $SYSCTL_LOC -w fs.file-max="$FILE_MAX_KERNEL"
          then
              echo "$SYSCTL_LOC failed to set fs.file-max parameter" |tee -a $log_file/orarun.log
          fi
	fi

       if [ -n "$IP_LOCAL_PORT_RANGE" ]
       then
          sed -e '/^[     | ]*net.ipv4.ip_local_port_range/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "net.ipv4.ip_local_port_range = $IP_LOCAL_PORT_RANGE " >> /etc/sysctl.conf
          if ! $SYSCTL_LOC -w net.ipv4.ip_local_port_range="$IP_LOCAL_PORT_RANGE"
          then
	  echo "$SYSCTL_LOC failed to set net.ipv4.ip_local_port_range parameter"  |tee -a $log_file/orarun.log
          fi
       fi

       if [ -n "$RMEM_DEFAULT" ]
       then
          sed -e '/^[     | ]*net.core.rmem_default/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "net.core.rmem_default = $RMEM_DEFAULT " >> /etc/sysctl.conf

          if ! $SYSCTL_LOC -w net.core.rmem_default="$RMEM_DEFAULT"
          then
             echo "$SYCTL_LOC failed to set net.core.rmem_default parameter" |tee -a $log_file/orarun.log
          fi	
       fi
    
       if [ -n "$WMEM_DEFAULT" ]
       then
          sed -e '/^[     | ]*net.core.wmem_default/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "net.core.wmem_default = $WMEM_DEFAULT " >> /etc/sysctl.conf

          if ! $SYSCTL_LOC -w net.core.wmem_default="$WMEM_DEFAULT"
          then
             echo "$SYSCTL_LOC failed to set net.core.wmem_default parameter" >> $log_file/orarun.log
           fi	
	fi	

       if [ -n "$RMEM_MAX" ]
       then
          sed -e '/^[     | ]*net.core.rmem_max/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "net.core.rmem_max = $RMEM_MAX " >> /etc/sysctl.conf

         if ! $SYSCTL_LOC -w net.core.rmem_max="$RMEM_MAX"
         then
            echo "$SYSCTL_LOC failed to set net.core.rmem_max parameter" |tee -a $log_file/orarun.log
          fi
        fi

	if [ -n "$WMEM_MAX" ]
        then
          sed -e '/^[     | ]*net.core.wmem_max/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "net.core.wmem_max = $WMEM_MAX " >> /etc/sysctl.conf

           if ! $SYSCTL_LOC -w net.core.wmem_max="$WMEM_MAX"
           then
             echo "$SYSCTL_LOC failed to set net.core.wmem_max parameter" |tee -a $log_file/orarun.log
           fi
	fi

	if [ -n "$AIO_MAX_SIZE" ]
        then
          sed -e '/^[     | ]*fs.aio-max-size/d' /etc/sysctl.conf > /tmp/sysctl.conf
          cat /tmp/sysctl.conf > /etc/sysctl.conf
          echo "fs.aio-max-size = $AIO_MAX_SIZE " >> /etc/sysctl.conf

	  if ! $SYSCTL_LOC -w fs.aio-max-size="$AIO_MAX_SIZE"
          then
             echo "$SYSCTL_LOC failed to set fs.aio-max-size parameter" |tee -a $log_file/orarun.log
          fi
	fi
   fi
fi
#Set shell limits
if [ "`echo $SET_SHELL_LIMITS | tr A-Z a-z`" == "true" ]
then
   if [ "$SHELL" == "/bin/sh" -o "$SHELL" == "/bin/bash" -o "$SHELL" == "/bin/ksh" ]
   then
      if [ -n "$MAX_PROCESSES_HARDLIMIT" ]
      then
         echo "$ORACLE_USER hard nproc $MAX_PROCESSES_HARDLIMIT" >> /etc/security/limits.conf
      fi      
      
      if [ -n "$MAX_PROCESSES_SOFTLIMIT" ]
      then
         echo "$ORACLE_USER soft nproc $MAX_PROCESSES_SOFTLIMIT" >> /etc/security/limits.conf
      fi

      if [ -n "$FILE_OPEN_MAX_HARDLIMIT" ]
      then
         echo "$ORACLE_USER hard nofile $FILE_OPEN_MAX_HARDLIMIT" >> /etc/security/limits.conf
      fi
      
      if [ -n "$FILE_OPEN_MAX_SOFTLIMIT" ]
      then
         echo "$ORACLE_USER soft nofile $FILE_OPEN_MAX_SOFTLIMIT" >> /etc/security/limits.conf
      fi

    elif [ "$SHELL" == "/bin/csh" -o "$SHELL" == "/bin/tcsh" -o "$SHELL" == "/bin/zsh" ]
    then 
      if [ -n "$MAX_PROCESSES_HARDLIMIT" ]
      then
         echo "$ORACLE_USER hard nproc $MAX_PROCESSES_HARDLIMIT" >> /etc/security/limits.conf
   
         echo "$ORACLE_USER soft nproc $MAX_PROCESSES_HARDLIMIT" >> /etc/security/limits.conf
      fi
      
      if [ -n "$FILE_OPEN_MAX_HARDLIMIT" ]
      then
         echo "$ORACLE_USER hard nofile $FILE_OPEN_MAX_HARDLIMIT" >> /etc/security/limits.conf

         echo "$ORACLE_USER soft nofile $FILE_OPEN_MAX_HARDLIMIT" >> /etc/security/limits.conf
      fi
   fi
 fi		

#Set default and current runlevels correctly
if [ "`echo $CHANGE_CURRENT_RUNLEVEL | tr A-Z a-z`" == "true" ]
then
   /sbin/telinit $DESIRED_CURRENT_RUNLEVEL
fi

if [ "`echo $CHANGE_DEFAULT_RUNLEVEL | tr A-Z a-z`" == "true" ]
then
    INITTAB_FILE="/etc/inittab"
    echo "Modifying $INITTAB_FILE to update the default runlevel" | tee -a $log_file/orarun.log
    typeset -i linenumber=`grep -n ":initdefault" $INITTAB_FILE | awk -F: '{ print $1 }'`
    typeset -i linesbefore=$linenumber-1
    head -n $linesbefore $INITTAB_FILE > $INITTAB_FILE.tmp
    echo "id:$DESIRED_DEFAULT_RUNLEVEL:initdefault:" >> $INITTAB_FILE.tmp
    typeset -i totallines=`wc -l $INITTAB_FILE | awk '{ print $1 }'`
    typeset -i linesafter=$totallines-$linenumber
    tail -n $linesafter $INITTAB_FILE >> $INITTAB_FILE.tmp 
    mv $INITTAB_FILE.tmp $INITTAB_FILE
    # tell init to re-examine the /etc/inittab file.
    /sbin/telinit q
fi

#Create groups if they do not exist
if [ "`echo $CREATE_GROUPS | tr A-Z a-z`" == "true" ]
then
   for group in $GROUP  
   do
      grep -qs ^$group: /etc/group || /usr/sbin/groupadd -r $group
     if [ $? -ne 0 ]
     then
      echo "An error occured while creating the group: $group" |tee -a $log_file/orarun.log
     fi
   done
fi

#set inventory permissions
if [ "`echo $SET_INVENTORY_PERMISSIONS | tr A-Z a-z`" == "true" ]
then
   
      echo "setting permissions for the central inventory '$CENTRAL_INVENTORY'" |tee -a $log_file/orarun.log
      /bin/chmod 770 -R $CENTRAL_INVENTORY   
      /bin/chown -R $ORACLE_USER:$INSTALL_GROUP $CENTRAL_INVENTORY 
fi

#Create the users if they do not exist
if [ "`echo $CREATE_USERS | tr A-Z a-z`" == "true" ]
then
   for user in $USERS
   do        
       grep -qs ^$user: /etc/passwd || /usr/sbin/useradd -r  $user
       if [ $? -ne 0 ]
       then
          echo "An error occured while creating the user $user " |tee -a $log_file/orarun.log
       fi
  done
fi

#Setup virtual ip
if [ "`echo $SETUP_VIRTUAL_IP | tr A-Z a-z`" == "true" ]
then
 domain_name="`domainname`"     
#strip off quotes
 ip_host_list=`grep ^VIRTUAL_IP_INFO $resp_file | cut -d= -f2`
 ip_host_list=`echo $ip_host_list | cut -d\" -f2`
 ip_host_list=`echo $ip_host_list | cut -d\" -f1`  
 for ip_hosts in $ip_host_list
 do
  ip=`echo $ip_hosts | cut -d: -f1`
  host=`echo $ip_hosts | cut -d: -f2`
  
  echo $host | grep "$domain_name"
  if [ $? -eq 0 ]
  then
    fqhn="$host"
    host=`echo $fqhn | awk -F. '{ print $1 }'`
  else
    fqhn="$host.$domain_name"
  fi
  echo "$ip   $fqhn	$host" >> /etc/hosts
  if [ $? -ne 0 ]
  then
    echo "An error occured while trying to update /etc/hosts file with Virtual IP information." |tee -a $log_file/orarun.log
  fi     
 done
fi

#Setup private nodes
if [ "`echo $SETUP_PRIVATE_NODES | tr A-Z a-z`" == "true" ]
then
 domain_name="`domainname`"     
 ip_host_list=`grep ^PRIVATE_NODE_INFO $resp_file | cut -d= -f2`
 ip_host_list=`echo $ip_host_list | cut -d\" -f2`
 ip_host_list=`echo $ip_host_list | cut -d\" -f1`
 for ip_hosts in $ip_host_list
 do
  ip=`echo $ip_hosts | cut -d: -f1`
  host=`echo $ip_hosts | cut -d: -f2`
  echo $host | grep "$domain_name"
  if [ $? -eq 0 ]
  then
    fqhn="$host"
    host=`echo $fqhn | awk -F. '{ print $1 }'`
  else
    fqhn="$host.$domain_name"
  fi
  echo "$ip	$fqhn	$host" >> /etc/hosts
  if [ $? -ne 0 ]
  then
    echo "An error occured while trying to update /etc/hosts file with Private Node information." |tee -a $log_file/orarun.log
  fi     
 done
fi

#Change primary group for users
if [ "`echo $CHANGE_PRIMARY_GROUP | tr A-Z a-z`" == "true" ] 
then 
 user_group_list=`grep ^USERS_PRIMARY_GROUP $resp_file | cut -d= -f2`

     #Strip off quotes
 user_group_list=`echo $user_group_list | cut -d\" -f2`
 user_group_list=`echo $user_group_list | cut -d\" -f1` 
 for user_groups in `echo $user_group_list`
  do
    # user_groups=`echo $user_groups | tr , \ `
     user=`echo $user_groups | cut -d: -f1`
     primary_grp=`echo $user_groups | cut -d: -f2`
    #Check if the user has the correct primary group 
    existing_primary_group=`id -ng $user` 
    if [ "$existing_primary_group" != "$primary_group" ]
    then 
    # Change the primary group for the user
    group_ids=`grep "$primary_grp:" /etc/group | awk -F: '{ print $3 }'` 
    for group_id in $group_ids
    do
      in_primary_group_name=`grep ":$group_id:" /etc/group | awk -F: '{ print $1 }'`
      if [ "$in_primary_group_name" = "$primary_grp" ]
      then
          primary_group_id=$group_id
      fi
    done
    /usr/sbin/usermod -g $primary_group_id $user 
    existing_grps=`id -nG $user`
    # replace all spaces in existing_grps by ,
    existing_grps=`echo $existing_grps | tr \  ,`
    /usr/sbin/usermod -G $existing_grps,$existing_primary_group $user 
     if [ $? -ne 0 ]
     then
       echo "User: $user could not be added to all the groups in the list $grp_list. " |tee -a $log_file/orarun.log
     fi
    fi
  done
fi

#Add users to the required groups
if [ "`echo $ADD_USER_TO_GROUP | tr A-Z a-z`" == "true" ]
then
  user_group_list=`grep ^USERS_GROUPS $resp_file | cut -d= -f2`

     #Strip off quotes
 user_group_list=`echo $user_group_list | cut -d\" -f2`
 user_group_list=`echo $user_group_list | cut -d\" -f1` 
 for user_groups in `echo $user_group_list`
  do
    # user_groups=`echo $user_groups | tr , \ `
     user=`echo $user_groups | cut -d: -f1`
     grp_list=`echo $user_groups | cut -d: -f2`
     #get the groups user belongs to
     existing_grps=`id -nG $user`
    # replace all spaces in existing_grps by ,
     existing_grps=`echo $existing_grps | tr \  ,`
     /usr/sbin/usermod -G $grp_list,$existing_grps $user 
     if [ $? -ne 0 ]
     then
       echo "User: $user could not be added to all the groups in the list $grp_list. " |tee -a $log_file/orarun.log
     fi
  done 
fi


#install of ocfs tools
install_ocfs_packages ${INSTALL_PACKAGES_OCFS_TOOLS} "${PACKAGES_OCFS_TOOLS}" ${RPM_BASE_URL_OCFS_TOOLS} `uname -i`

#install of ocfs
install_ocfs_packages ${INSTALL_PACKAGES_OCFS}  "${PACKAGES_OCFS}" ${RPM_BASE_URL_OCFS} `uname -p`


#loading of ocfs kernel module
if [ "`echo $INSTALL_OCFS_MODULE | tr A-Z a-z`" == "true" ]
then
#Add /sbin to PATH so that ifconfig can run
   PATH=$PATH:/sbin
   if [ -f /etc/ocfs.conf ]
   then
	echo "No need to populate /etc/ocfs.conf"
   else
     for private_node in $PRIVATE_NODES
     do
       private_ip=`grep "$private_node" /etc/hosts | awk ' { print $1 }'`
       if check_ifconfig "$private_ip"
       then
#This is the Private IP address which needs to go into /etc/ocfs.conf
 	    echo "node_name = $private_node" > /etc/ocfs.conf
	    echo "ip_address = $private_ip" >> /etc/ocfs.conf
	    echo "ip_port = 7000" >> /etc/ocfs.conf
	    echo "comm_voting = 1" >> /etc/ocfs.conf
         fi
     done
     /sbin/ocfs_uid_gen -c
   fi 
#Prepare the dependencies among kernel modules which can later be used by modprobe
   /sbin/depmod -a
   kernel_rel=`uname -r`
   cd /lib/modules/$kernel_rel
   LOAD_OCFS=/sbin/load_ocfs
   mkdir -p ocfs
   cd ocfs
   ln -s /lib/modules/$kernel_rel/kernel/drivers/addon/ocfs/ocfs.o ocfs.o
   typeset -i load_ocfs_updated=`grep "MODULE=" $LOAD_OCFS | grep -v "MODULE_SCRIPT" | awk '$1 !~ /#/ { print $0 }' | grep "/lib/modules/$kernel_rel/ocfs/ocfs.o" | wc -l`
   if [ $load_ocfs_updated -eq 0 ]
   then
 # Check if atleast the MODULE= line is present
       typeset -i module_line_present=`grep "MODULE=" $LOAD_OCFS | grep -v "MODULE_SCRIPT" |  wc -l`
       if [ $module_line_present -ne 0 ]
       then
#There should be only one such line
         typeset -i linenumber=`grep -n "MODULE=" $LOAD_OCFS | grep -v "MODULE_SCRIPT" | awk -F: '{ print $1 }'`
          head -n $linenumber $LOAD_OCFS > $LOAD_OCFS.tmp
          echo "MODULE=/lib/modules/$kernel_rel/ocfs/ocfs.o" >> $LOAD_OCFS.tmp
          typeset -i totallines=`wc -l $LOAD_OCFS | awk '{ print $1 }'`
          typeset -i linesafter=$totallines-$linenumber-1
          tail -n $linesafter $LOAD_OCFS >> $LOAD_OCFS.tmp
          mv $LOAD_OCFS.tmp $LOAD_OCFS
       else
          echo "Could not find MODULE= line in $LOAD_OCFS. Please update $LOAD_OCFS manually. Please add the following line at the appropriate place: MODULE=/lib/modules/$kernel_rel/ocfs/ocfs.o."
          updated_load_ocfs="false"
       fi
   fi
   chmod +x ${LOAD_OCFS}
   ${LOAD_OCFS}
fi


#Mount devices using required parameters
if [ "`echo $ENABLE_MOUNT | tr A-Z a-z`" == "true" ]
then
   mount_info_list=$MOUNT_INFO
   for mount_info in `echo $mount_info_list`
   do
         type_info=`echo $mount_info | cut -d% -f1`
         device_info=`echo $mount_info | cut -d% -f2`
         mount_pt=`echo $mount_info | cut -d% -f3`
         mount_options=`echo $mount_info | cut -d% -f4`
#First updating /etc/fstab if not updated already
         grep $device_info /etc/fstab

         if [ $? != 0 ]
         then
#Update /etc/fstab
           echo "$device_info $mount_pt $type_info $mount_options 0 2" >> /etc/fstab
         fi

         if mount -l | grep $device_info
         then
            echo "Unmounting the device..."
            if ! umount $device_info
             then
                 echo "Unmounting of $device_info failed, check if the device is in use." | tee -a $log_file/orarun.log
              else
                mount -t $type_info $device_info $mount_pt -o $mount_options
               if [ $? -ne 0 ]
               then
                  echo "Mounting $device_info on mountpoint $mount_pt with parameter $mount_options failed." | tee -a $log_file/orarun.log
               fi
            fi
         else
           if ! mount -t $type_info $device_info $mount_pt -o $mount_options
           then
              echo "Mounting $device_info on mountpoint $mount_pt with parameter $mount_options failed." | tee -a $log_file/orarun.log
            fi
         fi
  done

fi

#install the required packages
if [ "`echo $INSTALL_PACKAGES | tr A-Z a-z`" == "true" ]
then
   if [ "`echo $USE_YUM | tr A-Z a-z`" == "true" ]
   then
	http_proxy=http://$HTTP_PROXY:$HTTP_PORT/
        export http_proxy
        ftp_proxy=http://$FTP_PROXY:$FTP_PORT/
        export ftp_proxy
	if [ -z "$YUM_CONF_LOCATION" -o ! -r "$YUM_CONF_LOCATION" ]
        then
                curr_dir=`pwd`
                echo "\n Creating the yum.conf file $curr_dir/yum.conf.. \n "
                YUM_LOG_DIR="/var/yum"
                if [ ! -e $YUM_LOG_DIR ]
                then
                   mkdir -p $YUM_LOG_DIR
                fi
                if [ ! -e $YUM_CACHE_LOC ]
                then
                   mkdir -p $YUM_CACHE_LOC
                fi
                prefix=""  
                if [ "$protocol" != "http" -o "$protocol" != "ftp:" ]
              then
                prefix="file://localhost"
              fi
                cat <<EOF > $curr_dir/yum.conf
[main]
cachedir=$YUM_CACHE_LOC
debuglevel=2
errorlevel=2
logfile=$YUM_LOG_DIR/yum.log
pkgpolicy=newest
distroverpkg=redhat-release
tolerant=0
exactarch=1

[base]
name=Red Hat Linux - Base
baseurl=$prefix$YUM_REPOSITORY_URL
EOF
                YUM_CONF_LOCATION=$curr_dir/yum.conf
        fi
	if [ -n "$PACKAGES" ]
        then
           for package in $PACKAGES $GLIBC_PACKAGE $OCFS_PACKAGES
            do
                yum -y -c $YUM_CONF_LOCATION install $package
                if ! rpm --quiet -q $package
                then
                echo "Package: $package could not be installed" |tee -a $log_file/orarun.log
                fi
            done
        fi
  
    else
#USE RPM TO INSTALL PACKAGES

	for rpm_name in $RPM_FILENAMES $GLIBC_RPM
        do
           url="$RPM_BASE_URL/$rpm_name"
           if [ -n $url ]
           then
              protocol="`expr $url : '\(....\)'`"
              if [ "$protocol" == "http" ]
              then
                 rpm -Uvh $url --httpproxy $HTTP_PROXY --httpport $HTTP_PORT
              elif [ "$protocol" == "ftp:" ]
              then
                 rpm -Uvh $url --ftpproxy $FTP_PROXY --ftpport $FTP_PORT
              else
                 rpm -Uvh $url
              fi
           fi
        done
	for package in $PACKAGES $GLIBC_PACKAGE $OCFS_PACKAGES
        do
          if ! rpm --quiet -q $package
          then
           echo "Package: $package could not be installed." |tee -a $log_file/orarun.log
          fi
       done
   fi	
fi

