/*
 * Copyright (c) 1996-1998, by Sun Microsystems, Inc. All rights reserved.
 */

#ifndef	_SYS_SCSI_ADAPTERS_SFVAR_H
#define	_SYS_SCSI_ADAPTERS_SFVAR_H

#pragma ident	"@(#)sfvar.h	1.20	02/07/30 SMI"

/*
 * FC-AL FCP driver definitions
 */

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	TWO_FIVE_ONE
typedef	unsigned long	uintptr_t;
#endif


#define	SF_INIT_ITEMS		5
#define	SF_MAX_TARGETS		126
#define	SF_MAX_LILP_ENTRIES	126

#define	SF_NUM_HASH_QUEUES	32
#define	SF_HASH(x, y)	((x[0]+x[1]+x[2]+x[3]+x[4]+x[5]+x[6]+x[7]) &\
(SF_NUM_HASH_QUEUES-1))

/*
 * sf instance structure
 */

struct sf {
	struct scsi_hba_tran *sf_tran;
	dev_info_t	*sf_dip;
	struct sf	*sf_next;
	struct sf	*sf_sibling;
	kmutex_t	sf_mutex;
	kmutex_t	sf_cr_mutex;
	u_int		sf_state;
	struct sf_target *sf_targets[SF_MAX_TARGETS];
	struct sf_target *sf_wwn_lists[SF_NUM_HASH_QUEUES];
	void		*sf_socp;	/* pointer to socal state */
	struct fcal_transport *sf_sochandle;
	kmutex_t	sf_cmd_mutex;
	int		sf_throttle;
	int		sf_ncmds;
	int		sf_ncmds_exp_avg;
	int		sf_device_count;
	u_int		sf_use_lock;
	u_int		sf_timer;
	u_int		sf_online_timer;
	int		sf_take_core;
	struct kmem_cache *sf_pkt_cache;
	struct sf_pkt *sf_pkt_head; /* packet queue */
	struct sf_pkt *sf_pkt_tail;
	struct sf_els_hdr *sf_els_list;
	struct sf_reset_list	*sf_reset_list;
	kcondvar_t	sf_cr_cv;
	u_int		sf_cr_pool_cnt;
	struct sf_cr_pool *sf_cr_pool; /* list of command/response pools */
	u_char		sf_al_pa;
	u_char		sf_busy;
	u_char		sf_flag;
	u_char		sf_cr_flag; /* synchronize creation of new cr pools */
	u_int		sf_lip_cnt;
	struct scsi_reset_notify_entry  *sf_reset_notify_listf;
	struct fcal_lilp_map	*sf_lilp_map;
	ddi_dma_handle_t	sf_lilp_dmahandle;
	ddi_acc_handle_t	sf_lilp_acchandle;
	ddi_dma_cookie_t	sf_lilp_dmacookie;
	kstat_t		*sf_ksp;
#ifndef	TWO_FIVE_ONE
	kmutex_t	sf_hp_daemon_mutex;
	kcondvar_t	sf_hp_daemon_cv;
	struct sf_hp_elem *sf_hp_elem_head;
	struct sf_hp_elem *sf_hp_elem_tail;
#endif
	struct	sf_stats	sf_stats;
	uchar_t		sf_hp_initted;	/* hotplug daemon initialized */
	uchar_t		sf_init_done;
};

#define	SF_STATE_INIT		0x01
#define	SF_STATE_OFFLINE	0x02
#define	SF_STATE_ONLINE		0x04
#define	SF_STATE_ONLINING	0x08
#define	SF_STATE_SUSPENDED	0x10

/*
 * pool of sf command response blocks
 */

struct  sf_cr_pool {
	struct	sf_cr_pool 	*next;
	struct	sf_cr_free_elem *free;
	struct	sf		*sf;
	caddr_t			cmd_base;	/* start addr of this chunk */
	ddi_dma_handle_t	cmd_dma_handle; /* dma mapping for this chunk */
	ddi_acc_handle_t	cmd_acc_handle;
	caddr_t			rsp_base;
	ddi_dma_handle_t	rsp_dma_handle;
	ddi_acc_handle_t	rsp_acc_handle;
	u_int		nfree;
	u_int		ntot;
};

#define	SF_CR_POOL_MAX		32	/* allows 4096 outstanding packets */

#define	SF_ELEMS_IN_POOL	128
#define	SF_LOG2_ELEMS_IN_POOL	7	/* LOG2 SF_ELEMS_IN_POOL */
#define	SF_FREE_CR_EPSILON	64	/* SF_ELEMS_IN_POOL /2 */

/*
 * sf command/response free structure which is overlaid on fcp_cmd
 */

struct  sf_cr_free_elem {
	struct		sf_cr_free_elem *next;
	caddr_t		rsp;		/* ptr to corresponding rsp */
	u_int		cmd_dmac;	/* dmac_address for cmd */
	u_int		rsp_dmac;	/* dmac_address for rsp */
};

/*
 * list of targets for reset delay handling
 */

struct sf_reset_list {
	struct sf_reset_list	*next;
	struct sf_target	*target;
	clock_t			timeout;
	u_int			lip_cnt;
};

#ifndef	TWO_FIVE_ONE
/*
 * structure used to store hotplug event callback info
 */

struct sf_hp_event {
	int (*callback)();
	void *arg;
};

#endif

/*
 * sf per target structure
 */

struct sf_target 	{
	struct sf_pkt *sft_pkt_head; /* queue of active commands */
	struct sf_pkt *sft_pkt_tail;
	kmutex_t	sft_mutex;
	kcondvar_t	sft_cv;
	kmutex_t	sft_pkt_mutex;
	dev_info_t	*sft_dip;
	u_char		sft_node_wwn[FC_WWN_SIZE];
	u_char		sft_port_wwn[FC_WWN_SIZE];
	union {
		/* It's easier to shove around an int64 than a byte array */
		u_char	b[FCP_LUN_SIZE];
		int64_t l;
	}		sft_lun;
	/* XXXX The RAID LUN field is used to implement FCP Annex C */
#ifdef RAID_LUNS
	u_int		sft_raid_lun;
#endif
	u_char		sft_hard_address;
	u_char		sft_al_pa;
	u_char		sft_device_type;
	u_char		sft_scan_count;
	u_int		sft_alive;
	u_int		sft_state;
	u_int		sft_lip_cnt;
	struct scsi_hba_tran *sft_tran;
	struct sf_target	*sft_next;
	struct sf_target	*sft_next_lun;
#ifndef	TWO_FIVE_ONE
	struct sf_hp_event sft_insert_ev;
	struct sf_hp_event sft_remove_ev;
#endif
};

#define	SF_TARGET_INIT_DONE	0x1
#define	SF_TARGET_BUSY		0x2
#define	SF_TARGET_OFFLINE	0x4
#define	SF_TARGET_MARK		0x8

/*
 * sf packet
 */

#define	PKT2CMD(pkt)		((struct sf_pkt *)pkt->pkt_ha_private)
#define	CMD2PKT(cmd)		((cmd)->cmd_pkt)
#ifdef	_LP64
#define	PKT_PRIV_SIZE		2
#define	PKT_PRIV_LEN		16
#else /* _ILP32 */
#define	PKT_PRIV_SIZE		1
#define	PKT_PRIV_LEN		8
#endif


struct sf_pkt {
	struct sf_pkt 		*cmd_forw;
	struct sf_pkt 		*cmd_back;
	struct sf_pkt 		*cmd_next;
	struct scsi_pkt 	*cmd_pkt;
	fcal_packet_t 		*cmd_fp_pkt;
	u_int		cmd_state;
	u_int		cmd_timeout;
	char		cmd_scsi_scb[sizeof (struct scsi_arq_status)];
	uint32_t	cmd_dmacount;
	ddi_dma_handle_t	cmd_dmahandle;  /* dma handle */
	ddi_dma_cookie_t	cmd_dmacookie;  /* current dma cookie */
	u_int		cmd_flags;	/* private flags */
						/* needs ZEROING */
	u_int		cmd_cdblen;	/* length of cdb */
					/* needs to be INITialized */
	u_int		cmd_scblen;	/* length of scb */
					/* needs to be INITialized */
	u_int		cmd_privlen;	/* length of tgt private */
					/* needs to be INITialized */
	struct	sf_cr_pool	*cmd_cr_pool; /* pool to which cmd/rsp belong */
	struct fcp_cmd		*cmd_block;
	struct fcp_rsp		*cmd_rsp_block;
	u_int		cmd_dmac;
	u_int		cmd_rsp_dmac;
	uint64_t		cmd_pkt_private[PKT_PRIV_LEN];
			/* default target private area */
};

#define	SF_STATE_IDLE		0x1
#define	SF_STATE_ISSUED		0x2
#define	SF_STATE_ABORTING	0x4

/*
 * Define size of extended scsi cmd pkt (ie. includes ARQ)
 */
#define	EXTCMDS_STATUS_SIZE  (sizeof (struct scsi_arq_status))

/*
 * These are the defined flags for this structure.
 */
#define	CFLAG_DMAVALID		0x0010	/* dma mapping valid */
#define	CFLAG_DMASEND		0x0020	/* data is going 'out' */
#define	CFLAG_CMDIOPB		0x0040	/* this is an 'iopb' packet */
#define	CFLAG_CDBEXTERN		0x0100	/* cdb kmem_alloc'd */
#define	CFLAG_SCBEXTERN		0x0200	/* scb kmem_alloc'd */
#define	CFLAG_FREE		0x0400	/* packet is on free list */
#define	CFLAG_PRIVEXTERN	0x1000	/* target private was */
					/* kmem_alloc'd */
#define	CFLAG_IN_QUEUE		0x2000	/* command in sf queue */

struct sf_els_hdr {
	struct sf	*sf;
	caddr_t		cmd;
	caddr_t		rsp;
	u_char		els_code;
	u_char		delayed_retry;
	ddi_dma_handle_t	cmd_dma_handle;
	ddi_dma_handle_t	rsp_dma_handle;
	ddi_acc_handle_t	cmd_acc_handle;
	ddi_acc_handle_t	rsp_acc_handle;
	u_int		dest_nport_id;
	struct	sf_els_hdr	*next;
	struct	sf_els_hdr	*prev;
	u_int		size;
	u_int		timeout;
	u_int		retries;
	struct fcal_packet	*fpkt;
	u_int		lip_cnt;
	u_char		port_wwn[FC_WWN_SIZE];
	u_char		node_wwn[FC_WWN_SIZE];
	struct sf_target *target;
	ddi_dma_handle_t	data_dma_handle;
	ddi_acc_handle_t	data_acc_handle;
	caddr_t			data_buf;
};

union sf_els_cmd {
	struct la_els_logi logi;
	struct la_els_logo logo;
	struct la_els_prli prli;
	struct la_els_adisc adisc;
	struct fcp_cmd cmd;
};

union sf_els_rsp {
	struct la_els_logi logi;
	struct la_els_logo logo;
	struct la_els_prli prli;
	struct la_els_adisc adisc;
	u_char rsp[FCP_MAX_RSP_IU_SIZE];
};

struct sf_hp_elem {
	struct sf_hp_elem *next;
	dev_info_t	*dip;
	int		what;
	struct sf_target *target;
	struct sf	*sf;
};
#define	SF_ONLINE	0
#define	SF_OFFLINE	1

#ifdef	TWO_FIVE_ONE
#define	NDI_SUCCESS	0
#define	NDI_FAILURE	-1

#define	NDI_DEVI_REMOVE	0x01

#define	SCSI_MAXNAMELEN	MAXNAMELEN
#endif

#define	ADDR2SF(ap)	(struct sf *)((ap)->a_hba_tran->tran_hba_private)
#define	ADDR2TARGET(ap)	(struct sf_target *)((ap)->a_hba_tran->\
    tran_tgt_private)
#define	SF_ONLINE_TIMEOUT	180
#define	SF_OFFLINE_TIMEOUT	45
#define	SF_RESET_TIMEOUT	10
#define	SF_ELS_TIMEOUT		5
#define	SF_INVALID_TIMEOUT	0x7fffffff
#define	SF_INQ_TIMEOUT		30
#define	SF_BSY_TIMEOUT		10
#define	SF_ABORT_TIMEOUT	10000000 	/* in usec */
#define	SF_POLL_TIMEOUT	60
#define	SF_TARGET_RESET_DELAY	250000		/* in usec */

#define	SF_DECR_DELTA		5
#define	SF_INCR_DELTA		5

#define	SF_LO_CMD_DELTA	512
#define	SF_HI_CMD_DELTA	256

#define	SF_ELS_RETRIES		4
#define	SF_BSY_RETRIES		7

#define	SF_INIT_WAIT_TIMEOUT	60000000
#define		SF_CORE_CMD_TIMEOUT		0x01
#define		SF_CORE_BAD_ABORT		0x02
#define		SF_CORE_ABORT_TIMEOUT		0x04
#define		SF_CORE_ELS_TIMEOUT		0x08
#define		SF_CORE_ELS_FAILED		0x10
#define		SF_CORE_LILP_FAILED		0x20
#define		SF_CORE_OFFLINE_TIMEOUT		0x40
#define		SF_CORE_LIP_FAILED		0x80
#define		SF_CORE_OFFLINE_TARGET		0x100
#define		SF_CORE_INCOMPLETE_DMA		0x200
#define		SF_CORE_REPORTLUN_TIMEOUT	0x400
#define		SF_CORE_INQUIRY_TIMEOUT		0x800

#define	TRUE		1
#define	FALSE		0
#define	UNDEFINED	-1

/*
 * The initiator must allocate a minimum of 16 bytes for the response
 * to the REPORT_LUNS command.  Since there is 8 bytes of overhead and
 * each LUN is 4 bytes, this means that the minimum size is 2 LUNs.  We
 * will define the structure that way to prevent any spurious check
 * conditions.
 *
 * There is no maximum size for the response.
 *
 * By default we support 256 LUNs for the moment, which means 256*8+16
 * or 2064 bytes total size.
 */

#define	REPORT_LUNS_MIN_LUNS	2
#define	REPORT_LUNS_DEFAULT	256
#define	REPORT_LUNS_SIZE	((REPORT_LUNS_DEFAULT)*sizeof (uint32_t) \
				+2*sizeof (uint32_t))

/*
 * SCSI Report_Luns Data
 *
 * Format of data returned as a result of an REPORT_LUNS command.
 *
 */

struct scsi_report_luns {
	/* Number of bytes of data the target has available to send. */
	uint32_t	lun_list_len;
	uint32_t	reserved;
	uint64_t	lun[REPORT_LUNS_MIN_LUNS];
};

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SCSI_ADAPTERS_SFVAR_H */
