.\" ident	"@(#)dumpbind.man	1.2	00/07/17 SMI"
.\" Copyright (c) 1996, Sun Microsystems, Inc.
.\" All Rights Reserved
.if n .tr \--
.TH dumpbind 1 "18 Nov 1996"
.SH NAME
dumpbind \- dump the bindings found in a bindings.so.1 output file
.SH SYNOPSIS
.B dumpbind
[
.B -pqsc
]
.I bindings_file
.SH AVAILABILITY
.LP
SUNWosdem
.SH DESCRIPTION
.B dumpbind
parses the output file created by the 
.B bindings.so.1
.I Link-Auditing
library and displays a summary of all of the bindings that are
are recorded in it.
.LP
.B bindings.so.1
is a
.I Link-Auditing
library which monitors the bindings of function calls and stores
the data in a common buffer pointed to by BT_OUTPUT.  Because this
library tracks procedure calls via the
.I la_pltenter()
.I Link-Auditing
interface this library will record which functions are called as part of
the execution of a program.  This differs from the
.B symbindrep
example which performs a static analysis of all of the bindings that are
recorded in a program without actually executing it.  Also note that it
is safe to use the same BT_BUFFER for multiple processes running
concurrently.  This means that a whole suite of applications can be
run and the interfaces that are used as part of that suite are recorded.
.LP
The
.B bindings.so.1
library is enabled by the setting of the following environment variables.
.LP
.TP 10
.B LD_AUDIT
set this to the value of the bindings.so.1
.I Link-Auditing
library.  By setting this environment variable the gathering of
bindings data is enabled.
.TP
.B BT_OUTPUT
set this to the name of the common output buffer which will be maintained
durring the data gathering periode.  If this is not set the
output buffer will default to
.I /tmp/bindings.data.
.TP
.B BT_BINDFROM
a colon seperated list of libraries that are to be traced.  Only calls from
these libraries will be traced.  The default is to trace all calls.
.TP
.B BT_BINDTO
a colon seperated list of libraries that are to be traced.  Only calls to
these libraries will be traced.  The default is to trace all calls.
.SH OPTIONS
.TP 10
.B \-p
display output in parseable format.
.TP
.B \-q
query mutex_locks in bindings buffer and display there current status.  This is
when querying a problem with the bindings buffer.
.TP
.B \-c
clear all mutex_locks currently held in the bindings buffer.  
.TP
.B \-s
set master mutex_lock in bindings buffer.  This will cause any processes
currently using this bindings buffer to hang until the lock is freed.
.TP
.B \-b
print hash bucket usage statistics for the bindings buffer.

.SH EXAMPLES
Here is a sample of gathering data using the
.B bindings.so.1
.I Link-Auditing
library and then the examination of that data with the
.B dumpbind
command.
.LP
.nf
.ft 3
polyslo 131% export BT_OUTPUT=/tmp/bindings.data
polyslo 3563% LD_AUDIT=/opt/SUNWonld/lib/bindings.so.1
polyslo 3564% export LD_AUDIT
polyslo 3565% ls /usr/ccs/bin
admin              gprof.flat.blurb   nrform             strip.orig
ar                 help               prof               symorder
ar.orig            ld                 prs                tsort
as                 ld.orig            prt                unget
cdc                lex                ranlib             unifdef
comb               lorder             regcmp             val
delta              m4                 rmdel              vc
dis                make               sact               what
dump               mcs                sccs               yacc
error              mcs.orig           sccsdiff           yaccpar
get                nceucform          size
gprof              ncform             stanswer
gprof.callg.blurb  nm                 strip
polyslo 3566% nm /usr/lib/libdl.so.1
 
 
/usr/lib/libdl.so.1:
 
[Index]   Value      Size    Type  Bind  Other Shndx   Name
 
...
[27]    |      1788|       8|FUNC |GLOB |0    |7      |_dladdr
[32]    |      1772|       8|FUNC |GLOB |0    |7      |_dlclose
[44]    |      1796|       8|FUNC |GLOB |0    |7      |_dldump
[29]    |      1780|       8|FUNC |GLOB |0    |7      |_dlerror
[26]    |      1732|       8|FUNC |GLOB |0    |7      |_dlinfo
[17]    |      1740|       8|FUNC |LOCL |0    |7      |_dlmap
[24]    |      1748|       8|FUNC |GLOB |0    |7      |_dlmopen
[23]    |      1756|       8|FUNC |GLOB |0    |7      |_dlopen
[48]    |      1764|       8|FUNC |GLOB |0    |7      |_dlsym
[38]    |         0|       0|OBJT |GLOB |0    |ABS    |_edata
[21]    |      1824|       0|OBJT |GLOB |0    |8      |_end
[42]    |      1820|       0|OBJT |GLOB |0    |8      |_etext
[30]    |      1804|       8|FUNC |GLOB |0    |7      |_ld_concurrency
[34]    |      1812|       8|FUNC |GLOB |0    |7      |bind_guard
[47]    |      1820|       4|OBJT |GLOB |0    |8      |dbg_mask
[20]    |         0|       0|FILE |LOCL |0    |ABS    |dl.c
[43]    |      1788|       8|FUNC |WEAK |0    |7      |dladdr
[22]    |      1772|       8|FUNC |WEAK |0    |7      |dlclose
[31]    |      1796|       8|FUNC |WEAK |0    |7      |dldump
[45]    |      1780|       8|FUNC |WEAK |0    |7      |dlerror
...
polyslo 136% unset LD_AUDIT
.ft
.fi
.LP
The unseting of LD_AUDIT has turned off the bindings data gathering
and the output can now safely be examined by dumpbind.
.LP
.nf
.ft3
polyslo 3567% unset LD_AUDIT
polyslo 3568% dumpbind /tmp/bindings.data
                           Bindings Summary Report
 
Library                             Symbol                   Call Count
------------------------------------------------------------------------
/usr/lib/libc.so.1                  textdomain                    2
/usr/lib/libelf.so.1                elf_kind                      1
/usr/lib/libc.so.1                  munmap                        1
/usr/lib/libc.so.1                  strlen                      353
/usr/lib/libc.so.1                  .urem                         3
/usr/lib/libc.so.1                  iswprint                    444
/usr/lib/libc.so.1                  .udiv                        11
/usr/lib/libc.so.1                  time                          1
/usr/lib/libc.so.1                  .mul                        361
/usr/lib/libc.so.1                  closedir                      1
/usr/lib/libc.so.1                  _rw_read_held                36
/usr/lib/libelf.so.1                elf_strptr                   34
/usr/lib/libc.so.1                  lstat64                       1
/usr/lib/libc.so.1                  _realbufend                1203
/usr/lib/libc.so.1                  qsort                         3
/usr/lib/libc.so.1                  _write                       64
/usr/lib/libelf.so.1                _elf32_fsize                  7
/usr/lib/libc.so.1                  close                         1
/usr/lib/libelf.so.1                elf_begin                     1
/usr/lib/libelf.so.1                elf_version                   1
/usr/lib/libc.so.1                  _isatty                       2
/usr/lib/libc.so.1                  mmap                          1
/usr/lib/libelf.so.1                elf_end                       1
/usr/lib/libc.so.1                  printf                      628
/usr/lib/libc.so.1                  calloc                        2
...
/usr/lib/libc.so.1                  __flsbuf                    511
/usr/lib/libc.so.1                  _close                        1
/usr/lib/libc.so.1                  _doprnt                     630
/usr/lib/libc.so.1                  ___errno                      3
/usr/lib/libc.so.1                  .umul                        23
/usr/lib/libc.so.1                  _thr_main                     7
/usr/lib/libc.so.1                  open                          1
/usr/lib/libc.so.1                  _sbrk_unlocked                8
/usr/lib/libc.so.1                  mutex_lock                    1
/usr/lib/libc.so.1                  _setbufend                    2
/usr/lib/libc.so.1                  sprintf                       2
/usr/lib/libc.so.1                  setlocale                     2
/usr/lib/libelf.so.1                elf_nextscn                  15
/usr/lib/ld.so.1                    dlsym                         2
/usr/lib/libelf.so.1                _elf_getscn                  34
/usr/lib/libc.so.1                  _sbrk                         8
/usr/lib/libc.so.1                  _open64                       1
/usr/lib/libc.so.1                  _mutex_lock                  88
/usr/lib/libc.so.1                  exit                          2
/usr/lib/libc.so.1                  ioctl                         1
/usr/lib/libc.so.1                  getenv                       17
/usr/lib/libc.so.1                  _mutex_held                  36
------------------------------------------------------------------------
Symbol Count: 87    Call Count: 8272
 
polyslo 3570% 
.ft
.fi
.SH SEE ALSO
.BR ld.so.1 (1)
.br
.TZ LLM
