.\" ident	"@(#)perfcnt.man	1.3	01/09/21 SMI"
.\" Copyright (c) 1996-2001 by Sun Microsystems, Inc.
.\" All rights reserved.
.if n .tr \--
.TH perfcnt 1 "18 Nov 1996"
.SH NAME
perfcnt \- trace the amount of time spent in each function call
.SH SYNOPSIS
.B perfcnt
[
.B -f
.I bindfromlist
] [
.B t
.I bindtolist
] [
.B -l
.I perfcntlib
] executable [executable arguments ...]
.SH AVAILABILITY
.LP
SUNWosdem
.SH DESCRIPTION
.B perfcnt
executes the specified command and tracks the amount of time
that is spent in each procedure call.
.B perfcnt
traces all of the procedure calls that occur between dynamic objects
via the
.I Procedure Linkage Table, so only those procedure calls which are
bound to the
.I Procedure Linkage Table
will be traced.
.LP
.B perfcnt
has the limitation that it does not work with a threaded program nor
any programs which use procedures which are dependent upon the
stack frame.  See
.I NOTES
below
.SH OPTIONS
.TP 10
.BI \-f " bindfromlist"
A colon seperated list of libraries that are to be
traced.  Only calls from these libraries will be traced.  The default
is to trace all calls.
.TP
.BI \-t " bindtolist"
A colon seperated list of libraries taht are to be traced.
Only calls to these libraries will be traced.  The default is
to trace all calls.
.TP
.BI \-l " perfcntlib"
specify an alternate perfcnt.so 
.I Link-Auditing
library to use.
.SH EXAMPLES
The example tracks the usage of the libelf.so.1 library when performing
a nm.
.LP
.nf
.ft 3
% perfcnt -t/usr/lib/libelf.so.1 nm /usr/lib/libc.so.1
/usr/lib/libc.so.1:

[Index]   Value      Size    Type  Bind  Other Shndx   Name

[457]   |         0|       0|NOTY |LOCL |0    |UNDEF  |
[2]     |       148|       0|SECT |LOCL |0    |1      |
[3]     |     15232|       0|SECT |LOCL |0    |2      |
[4]     |     45120|       0|SECT |LOCL |0    |3      |
[5]     |     64024|       0|SECT |LOCL |0    |4      |
\.\.\.
[1893]  |    347660|      88|FUNC |LOCL |0    |12     |ypstub_perror
[1895]  |    347280|     380|FUNC |LOCL |0    |12     |ypstub_sperror
[714]   |    663472|       8|OBJT |LOCL |0    |22     |zero


Perf Counts for: nm

              SYMBOL    c_count     tim         avg. tim        tot. %
---------------------------------------------------------------------
          elf_getscn    1           4.03            4.03        0.01%
            elf_kind    1           4.36            4.36        0.01%
        _elf32_fsize    7          50.80            7.26        0.09%
     _elf32_xlatetom    6          67.47           11.24        0.11%
         elf_version    1          72.50           72.50        0.12%
       elf32_getshdr    33         77.42            2.35        0.13%
         elf_nextscn    33         83.36            2.53        0.14%
             elf_end    1         131.91          131.91        0.22%
         elf_getdata    2         138.74           69.37        0.23%
           elf_begin    1         171.74          171.74        0.29%
       elf32_getehdr    1         214.81          214.81        0.36%
         _elf_getscn    4254     9755.89            2.29        16.38%
          elf_strptr    4254    48784.97           11.47        81.91%
---------------------------------------------------------------------
                                                Total Time: 59557.98

.ft
.fi
.SH NOTES
The
.B perfcnt
command is a demonstration of the
.I Link-Auditing
interface of the run-time linker (which is documented in
.TZ LLM
\), and it is not usefull in all environments.  This program
will not work with a threaded application and should not be
used with one.  Also, in order to track the
time spent in a procedure both the
entry and exit of the procedure must be tracked.  Because this causes
an additional stack frame to be created for each procedure call 
it is not compatible with all library routines.
More details on this can be found in the
.I Link-Auditing
section of
.TZ LLM
.SH SEE ALSO
.BR ld.so.1 (1)
.br
.TZ LLM
