#!/bin/ksh -p
#
# Copyright (c) 1997-2001 by Sun Microsystems, Inc.
# All rights reserved.
#
#pragma ident	"@(#)whocalls.ksh	1.9	01/09/21 SMI"
#



usage() {
	cat 1>&2 << 'EOF'
usage: whocalls [sl:] <funcname> <utility> [utility arguments]

  whocalls will audit all function bindings between <utility> and any library
  it utilizes.  Each time the function <funcname> is called, a stack
  backtrace is displayed

	-l <wholib>
		specify an alternate who.so to use.

	-s	When available, examine and use the .symtab symbol table
		for local symbols (more expensive).
EOF
}



optlet="sl:"

if [[ $# < 2 ]]; then
	usage
	exit 1
fi

wholib="/usr/lib/link_audit/who.so.1"
wholib64="/usr/lib/link_audit/sparcv9/who.so.1"
detail=""

while getopts $optlet c
do
	case $c in
	l)
		wholib="$OPTARG"
		wholib64="$OPTARG"
		;;
	s)
		detail="1"
		;;
	\?)
		usage
		exit 1
		;;
	esac
done

shift `expr $OPTIND - 1`
func=$1
shift 1


LD_AUDIT="$wholib" \
LD_AUDIT_64="$wholib64" \
WHO_DETAIL="$detail" \
WHOCALLS="$func" \
"$@"
exit 0
