/*
 * Copyright (c) 1994-1998 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_CPR_IMPL_H
#define	_SYS_CPR_IMPL_H

#pragma ident	"@(#)cpr_impl.h	1.32	98/09/30 SMI"

#ifdef	__cplusplus
extern "C" {
#endif


#ifndef _ASM

#include <sys/machparam.h>
#include <sys/vnode.h>
#include <sys/pte.h>

/*
 * This file contains machine dependent information for CPR
 */
#define	CPR_MACHTYPE_4U		0x3475		/* '4u' */

/*
 * Information about the pages allocated via prom_retain().
 * Increase the number of CPR_PROM_RETAIN_CNT if more
 * prom_retain() are called.
 */
#define	CPR_PROM_RETAIN_CNT	1
#define	CPR_PANICBUF		0	/* prom_retain() for panicbuf */


/*
 * For 2.7 and later releases, sun4u cprbooter and cprboot are
 * ELF64 binaries, and must handle both ILP32 and LP64 kernels;
 * while long and ptr sizes are fixed at 64-bits for cprboot/er,
 * these sizes are mixed between ILP32/LP64 kernels.  To simplify
 * handling of statefile data, we define fixed-size types for
 * all sun4u kernels.
 */
typedef uint64_t cpr_ptr;
typedef uint64_t cpr_ext;

struct cpr_map_info {
	cpr_ptr	virt;
	cpr_ext	phys;
	uint_t	size;
};


#define	CPR_MAX_TLB	(16)

struct sun4u_tlb {
	tte_t	tte;
	cpr_ptr va_tag;
	int	no;		/* tlb entry number */
	int	ctx;
};

/*
 * This structure defines the fixed-length machine dependent data for
 * sun4u ILP32 and LP64 systems.  It is followed in the state file by
 * a variable length section of null-terminated prom forth words:
 *
 *    cpr_obp_tte_str	for translating kernel mappings, unix-tte
 *    kadb_defer_word	kadb callback
 *
 * The total length (fixed plus variable) of the machine-dependent
 * section is stored in cpr_machdep_desc.md_size
 *
 * WARNING: make sure all CPR_MD_* below match this structure
 */
struct cpr_sun4u_machdep {
	uint32_t ksb;			/* 0x00: kernel stack bias */
	uint16_t kpstate;		/* 0x04: kernel pstate */
	uint16_t kwstate;		/* 0x06: kernel wstate */
	cpr_ptr thrp;			/* 0x08: current thread ptr */
	cpr_ext thrp_pfn;		/* 0x10: current thread pfn */
	cpr_ptr func;			/* 0x18: jumpback virt text addr */
	cpr_ext func_pfn;		/* 0x20: jumpback phys text addr */
	cpr_ext qsav_pc;		/* 0x28: qsav pc */
	cpr_ext qsav_sp;		/* 0x30: qsav sp */
	int	mmu_ctx_pri;		/* 0x38: primary context */
	int	mmu_ctx_sec;		/* 0x3c: secondary context */
	int	test_mode;
	struct	sun4u_tlb dtte[CPR_MAX_TLB];
	struct	sun4u_tlb itte[CPR_MAX_TLB];
	struct	cpr_map_info retain[CPR_PROM_RETAIN_CNT];
	struct	cpr_map_info tmp_stack;
};
typedef struct cpr_sun4u_machdep csu_md_t;

#endif /* _ASM */


/*
 * XXX - these should be generated by a genassym,
 * but that doesn't work well for shared psm/kernel use
 */
#define	CPR_MD_KSB		0x00
#define	CPR_MD_KPSTATE		0x04
#define	CPR_MD_KWSTATE		0x06
#define	CPR_MD_THRP		0x08
#define	CPR_MD_FUNC		0x18
#define	CPR_MD_QSAV_PC		0x28
#define	CPR_MD_QSAV_SP		0x30
#define	CPR_MD_PRI		0x38
#define	CPR_MD_SEC		0x3c


#ifndef _ASM

#define	CPR_MAX_TRANSIZE MMU_PAGESIZE

#define	CPRBOOT	"-F cprbooter cprboot"
#define	CPRBOOT_PATH "/platform/sun4u/cprboot"
#define	CPRBOOT_START 0xedd00000 /* must match value in mapfile.cprboot */

#define	PN_TO_ADDR(pn)  ((u_longlong_t)(pn) << MMU_PAGESHIFT)
#define	ADDR_TO_PN(pa)	((pa) >> MMU_PAGESHIFT)

#define	prom_map_plat(addr, pa, size) \
	if (prom_map(addr, pa, size) == 0) { \
		errp("PROM_MAP failed: paddr=0x%x%8.8x\n", \
		    (int)(pa >> 32), (int)(pa)); \
		return (-1); \
	}

typedef	u_longlong_t	physaddr_t;

extern pfn_t va_to_pfn(caddr_t);
extern int i_cpr_write_machdep(vnode_t *);
extern void i_cpr_machdep_setup(void);
extern void i_cpr_save_machdep_info(void);
extern void i_cpr_enable_intr(void);
extern void i_cpr_enable_clkintr(void);
extern void i_cpr_disable_clkintr(void);
extern void i_cpr_set_tbr(void);
extern void i_cpr_stop_intr(void);
extern void i_cpr_handle_xc(int);
extern void i_cpr_resume_setup(void *, csu_md_t *);
extern void cpr_bzero(register char *, register int);
extern int i_cpr_prom_pages(int);
extern int i_cpr_reuseinit(void);
extern int i_cpr_reusefini(void);
extern int i_cpr_check_cprinfo(void);
extern int i_cpr_reusable_supported(void);

#endif /* _ASM */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_CPR_IMPL_H */
