/*
 * Decompiled with CFR 0.152.
 */
package javax.management.snmp.manager;

import java.net.InetAddress;
import java.util.Vector;
import javax.management.snmp.SnmpPduFactory;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpQManager;
import javax.management.snmp.manager.SnmpRequest;

class SendQ
extends Vector {
    final long sendQ_pollMargin = 0L;
    boolean isBeingDestroyed = false;

    SendQ(int n, int n2) {
        super(n, n2);
    }

    public synchronized void addRequest(SnmpRequest snmpRequest) {
        long l = snmpRequest.getAbsNextPollTime();
        int n = this.size();
        while (n > 0) {
            if (l < this.getRequestAt(n - 1).getAbsNextPollTime()) break;
            --n;
        }
        if (n == this.size()) {
            this.addElement(snmpRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpRequest, n);
        }
    }

    public synchronized SnmpPduFactory findPduFactory(InetAddress inetAddress, int n) {
        SnmpPduFactory snmpPduFactory = null;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2 && snmpPduFactory == null) {
            SnmpRequest snmpRequest = this.getRequestAt(n3);
            SnmpPeer snmpPeer = snmpRequest.getPeer();
            if (snmpPeer.getDestAddr().equals(inetAddress) && snmpPeer.getDestPort() == n) {
                snmpPduFactory = snmpPeer.getPduFactory();
            }
            ++n3;
        }
        return snmpPduFactory;
    }

    public synchronized Vector getAllOutstandingRequest(long l) {
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        while (this.waitUntilReady()) {
            long l2 = System.currentTimeMillis() + l;
            int n = this.size();
            while (n > 0) {
                SnmpRequest snmpRequest = this.getRequestAt(n - 1);
                if (snmpRequest.getAbsNextPollTime() > l2) break;
                vector.addElement(snmpRequest);
                --n;
            }
            if (vector.isEmpty()) continue;
            this.elementCount -= vector.size();
            return vector;
        }
        return null;
    }

    public synchronized SnmpRequest getOutstandingRequest() {
        this.waitUntilReady();
        SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
        --this.elementCount;
        return snmpRequest;
    }

    public SnmpRequest getRequestAt(int n) {
        return (SnmpRequest)this.elementAt(n);
    }

    synchronized void introduceSleep(long l) {
        long l2 = System.currentTimeMillis();
        while (true) {
            try {
                this.wait(l);
                if (System.currentTimeMillis() - l2 < l) continue;
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized String printAllRequest(long l) {
        if (this.isEmpty()) {
            return "------- SendQ empty.......";
        }
        int n = this.size();
        StringBuffer stringBuffer = new StringBuffer("\n------------------------ Requests in SendQ -> " + n);
        int n2 = 0;
        while (n2 < n) {
            SnmpRequest snmpRequest = this.getRequestAt(n2);
            stringBuffer.append("\n" + n2 + ". (" + snmpRequest.toString() + " RemainingTimeToSend = " + snmpRequest.timeRemainingForAction(l) + "  ) ................................\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public synchronized SnmpRequest removeRequest(long l) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            SnmpRequest snmpRequest = this.getRequestAt(n2);
            if (l == (long)snmpRequest.getRequestId()) {
                this.removeElementAt(n2);
                return snmpRequest;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void waitOnThisQueue(long l) {
        if (l == 0L && !this.isEmpty() && SnmpQManager.isDebugOn()) {
            SnmpQManager.debug("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on newq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l = 0L;
            if (!this.isEmpty()) {
                long l2 = System.currentTimeMillis();
                SnmpRequest snmpRequest = (SnmpRequest)this.lastElement();
                l = snmpRequest.getAbsNextPollTime() - l2;
                if (l <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l);
        }
        return false;
    }
}

