/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.diskmgr.client.DiskMgrContextHelpListener;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.admin.diskmgr.common.FdiskData;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class ChangeFdiskDialog
extends VOptionPane {
    public static final int HELP_CACHE_SIZE = 2;
    DiskData diskData;
    ResourceBundle bundle;
    VDiskMgr theApp;
    GenInfoPanel infoPanel;
    Vector helpCache;
    DiskMgrContextHelpListener helpListener;
    GridBagConstraints gbc;
    Vector vPartitions;
    JButton okButton;
    JButton cancelButton;
    JTable table;
    String[] columns = new String[3];
    String[][] rowData;
    FdiskData oldActive = null;
    FdiskData newActive = null;

    public ChangeFdiskDialog(VDiskMgr vDiskMgr, DiskData diskData) {
        this.theApp = vDiskMgr;
        this.diskData = diskData;
        this.vPartitions = this.diskData.getVPartitions();
        this.bundle = vDiskMgr.getResourceBundle();
        this.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ChangeActiveTitle"));
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.helpCache = new Vector(2);
        this.helpListener = new DiskMgrContextHelpListener(vDiskMgr, this.helpCache, this.infoPanel, "fdisk_change");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.helpListener), true);
        this.gbc = new GridBagConstraints();
        JComponent jComponent = this.getContentPane();
        jComponent.setLayout(new GridBagLayout());
        JPanel jPanel = this.buildContentPanel();
        Constraints.constrain((Container)jComponent, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        JComponent jComponent2 = this.getButtonPane();
        jComponent2.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.buildButtonPanel();
        Constraints.constrain((Container)jComponent2, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        ButtonListener buttonListener = new ButtonListener();
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OK"));
        this.okButton = new JButton(string);
        this.okButton.addActionListener(buttonListener);
        Constraints.constrain((Container)jPanel, (Component)this.okButton, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Cancel"));
        this.cancelButton = new JButton(string);
        this.cancelButton.addActionListener(buttonListener);
        Constraints.constrain((Container)jPanel, (Component)this.cancelButton, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        return jPanel;
    }

    private JPanel buildContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ChangeActiveText"), 30);
        Constraints.constrain((Container)jPanel, (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
        this.columns[0] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ChangeActiveDisk");
        this.columns[1] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ChangeActiveFdisk");
        this.columns[2] = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"ChangeActiveUsedFor");
        this.buildRowData();
        this.table = new JTable(this.rowData, this.columns);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.helpListener = new DiskMgrContextHelpListener(this.theApp, this.helpCache, this.infoPanel, "fdisk_change_active");
        this.theApp.addHelpListener(this.helpListener, jScrollPane);
        JTableHeader jTableHeader = this.table.getTableHeader();
        Dimension dimension = new Dimension(((JComponent)jTableHeader).getPreferredSize().width, (((JComponent)jTableHeader).getPreferredSize().height + 1) * (this.vPartitions.size() + 1));
        jScrollPane.setMinimumSize(dimension);
        Constraints.constrain((Container)jPanel, (Component)jScrollPane, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)12, (int)12);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        return jPanel;
    }

    private void buildRowData() {
        FdiskData fdiskData;
        Enumeration enumeration = this.vPartitions.elements();
        Vector<FdiskData> vector = new Vector<FdiskData>();
        while (enumeration.hasMoreElements()) {
            fdiskData = (FdiskData)enumeration.nextElement();
            if (!fdiskData.getActive()) {
                vector.addElement(fdiskData);
                continue;
            }
            this.oldActive = fdiskData;
        }
        this.rowData = new String[this.vPartitions.size()][3];
        enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            fdiskData = (FdiskData)enumeration.nextElement();
            this.rowData[n][0] = this.diskData.getDiskName();
            this.rowData[n][1] = Short.toString(fdiskData.getPartition());
            this.rowData[n][2] = fdiskData.getUsedForString();
            ++n;
        }
    }

    public void doCancel() {
        this.getParentFrame().dispose();
    }

    public void doOK() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            this.doCancel();
            return;
        }
        Thread thread = new Thread(){
            JFrame parent;
            {
                this.parent = ChangeFdiskDialog.this.getParentFrame();
            }

            public void run() {
                ChangeFdiskDialog.this.theApp.waitOn();
                ((Component)this.parent).setVisible(false);
                if (ChangeFdiskDialog.this.oldActive != null) {
                    ChangeFdiskDialog.this.oldActive.setActive(false);
                }
                ChangeFdiskDialog.this.newActive = ChangeFdiskDialog.this.getFdiskData();
                ChangeFdiskDialog.this.newActive.setActive(true);
                try {
                    ChangeFdiskDialog.this.theApp.getDiskMgr().fdiskDisk(ChangeFdiskDialog.this.diskData);
                    ChangeFdiskDialog.this.theApp.getTree().getCurrentContent().refresh();
                    ChangeFdiskDialog.this.doCancel();
                }
                catch (DiskMgrException diskMgrException) {
                    ((Component)this.parent).setVisible(true);
                    ChangeFdiskDialog.this.theApp.reportErrorException((Exception)((Object)diskMgrException), this.parent);
                }
                ChangeFdiskDialog.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    private FdiskData getFdiskData() {
        FdiskData fdiskData = null;
        String string = this.rowData[this.table.getSelectedRow()][1];
        Integer n = new Integer(string);
        Enumeration enumeration = this.vPartitions.elements();
        while (enumeration.hasMoreElements()) {
            fdiskData = (FdiskData)enumeration.nextElement();
            if (fdiskData.getPartition() != n.intValue()) continue;
            return fdiskData;
        }
        return fdiskData;
    }

    private JFrame getParentFrame() {
        return (JFrame)this.getContainer();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ChangeFdiskDialog.this.okButton) {
                ChangeFdiskDialog.this.doOK();
            } else {
                ChangeFdiskDialog.this.doCancel();
            }
        }
    }
}

