/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mib2mof;

import com.sun.wbem.compiler.mib2mof.ASTMib;
import com.sun.wbem.compiler.mib2mof.ASTNamedType;
import com.sun.wbem.compiler.mib2mof.Enumerated;
import com.sun.wbem.compiler.mib2mof.IdentifierHandler;
import com.sun.wbem.compiler.mib2mof.Node;
import com.sun.wbem.compiler.mib2mof.Parser;
import com.sun.wbem.compiler.mib2mof.ParserTreeConstants;
import com.sun.wbem.compiler.mib2mof.SemanticException;
import com.sun.wbem.compiler.mib2mof.SyntaxHandler;
import java.util.Vector;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser, int n) {
        this(n);
        this.parser = parser;
    }

    public StringBuffer computeValue(Vector vector) throws SemanticException {
        return new StringBuffer();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
    }

    public SimpleNode getChildOfType(int n) {
        if (this.children == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.children.length) {
            if (((SimpleNode)this.children[n2]).id == n) {
                return (SimpleNode)this.children[n2];
            }
            ++n2;
        }
        return null;
    }

    public String getCimSnmpSyntax() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                String string;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && (string = simpleNode.getCimSnmpSyntax()).length() != 0) {
                    return string;
                }
                ++n;
            }
        }
        return "";
    }

    public String getDefValInitializer(String string, ASTNamedType aSTNamedType, String string2) {
        return new String();
    }

    public Enumerated getEnumeratedBITSDef() {
        if (!this.isEnumeratedBITSType()) {
            return new Enumerated();
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                Enumerated enumerated;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && !(enumerated = simpleNode.getEnumeratedBITSDef()).isEmpty()) {
                    return enumerated;
                }
                ++n;
            }
        }
        return new Enumerated();
    }

    public Enumerated getEnumeratedDef() {
        if (!this.isEnumeratedType()) {
            return new Enumerated();
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                Enumerated enumerated;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && !(enumerated = simpleNode.getEnumeratedDef()).isEmpty()) {
                    return enumerated;
                }
                ++n;
            }
        }
        return new Enumerated();
    }

    public long getFixedLength() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                long l;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && (l = simpleNode.getFixedLength()) != -1L) {
                    return l;
                }
                ++n;
            }
        }
        return -1L;
    }

    public String getMbeanSyntax() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                String string;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && (string = simpleNode.getMbeanSyntax()).length() != 0) {
                    return string;
                }
                ++n;
            }
        }
        return "";
    }

    public ASTMib getMib() {
        if (this.parent == null || !(this.parent instanceof SimpleNode)) {
            return null;
        }
        if (this.id == 1) {
            return (ASTMib)this;
        }
        return ((SimpleNode)this.parent).getMib();
    }

    public String getMofSyntax() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                String string;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && (string = simpleNode.getMofSyntax()).length() != 0) {
                    return string;
                }
                ++n;
            }
        }
        return "";
    }

    public SimpleNode getResolver() {
        return null;
    }

    public String getSnmpSyntax() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                String string;
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && (string = simpleNode.getSnmpSyntax()).length() != 0) {
                    return string;
                }
                ++n;
            }
        }
        return "";
    }

    public boolean isEnumeratedBITSType() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && simpleNode.isEnumeratedBITSType()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isEnumeratedType() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null && simpleNode.isEnumeratedType()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public void jjtClose() {
    }

    public static Node jjtCreate(int n) {
        return new SimpleNode(n);
    }

    public static Node jjtCreate(Parser parser, int n) {
        return new SimpleNode(parser, n);
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtOpen() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public void resolve(IdentifierHandler identifierHandler, String string) {
    }

    public void resolve(SyntaxHandler syntaxHandler) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.resolve(syntaxHandler);
                }
                ++n;
            }
        }
    }

    public void setResolver(SimpleNode simpleNode) {
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(string) + this.toString();
    }

    public void validateIndexNames(IdentifierHandler identifierHandler) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.validateIndexNames(identifierHandler);
                }
                ++n;
            }
        }
    }
}

