/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.client;

import com.sun.opencard.cmd.OCFDisable;
import com.sun.opencard.cmd.OCFEnable;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.gui.client.plugin.ClientPluginGuiCtx;
import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginException;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import com.sun.smartcard.mgt.util.ResourceManager;
import java.util.Properties;
import java.util.ResourceBundle;

public class CDEClientPlugin
implements SmartCardPlugin {
    private boolean enableSmartCard;
    private boolean ignoreCardRemoval;
    private boolean reauthAfterCardRemoval;
    private int cardRemovalTimeout;
    private int cardRemovalTimeoutMax = 120;
    private int reauthTimeout;
    private int reauthTimeoutMax = 120;
    private int cardRemovalLogoutWait;
    private int cardRemovalLogoutWaitMax = 120;
    private static final String useSmartCardProp = "root.useSmartCard";
    private static final String ignoreCardRemovalProp = "root.ignoreCardRemoval";
    private static final String reauthAfterCardRemovalProp = "root.reauthAfterCardRemoval";
    private static final String cardRemovalTimeoutProp = "root.cardRemovalTimeout";
    private static final String reauthTimeoutProp = "root.reauthTimeout";
    private static final String cardRemovalLogoutWaitProp = "root.cardRemovalLogoutWait";
    private PluginSlider cardRemovalTimeoutSlider;
    private PluginSlider reauthTimeoutSlider;
    private PluginSlider cardRemovalLogoutWaitSlider;
    private PluginCheckBox ignoreCardRemovalCheckbox;
    private PluginCheckBox reauthAfterCardRemovalCheckbox;
    private ClientPluginGuiCtx pgc;
    private Properties cfgProps;
    private static ResourceBundle toolBundle = null;
    private boolean debug;

    public CDEClientPlugin(Properties p) throws PluginException {
        this.debug = System.getProperty("debug") != null;
        System.out.println("WRONG CONSTRUCTOR!");
    }

    public CDEClientPlugin(Properties p, ClientPluginGuiCtx guicontext) throws PluginException {
        boolean bl = this.debug = System.getProperty("debug") != null;
        if (this.debug) {
            System.out.println("\n======= CDEClientPlugin =========================================");
        }
        toolBundle = ResourceManager.getBundle((String)"com.sun.smartcard.gui.ListResourceBundle.ScConsoleResources", this.getClass());
        this.cfgProps = p;
        this.pgc = guicontext;
        if (this.pgc == null) {
            throw new PluginException("Error with ClientPluginGuiCtx (null)");
        }
        this.pgc.setCallback((SmartCardPlugin)this);
        Smartcard dtloginSC = null;
        Smartcard dtsessionSC = null;
        try {
            dtloginSC = new Smartcard("dtlogin");
            dtsessionSC = new Smartcard("dtsession");
        }
        catch (Exception e) {
            if (this.debug) {
                this.pgc.popupError("OCF Server Error", e.toString());
            }
            if (dtloginSC != null) {
                dtloginSC.cleanup();
            }
            if (dtsessionSC != null) {
                dtsessionSC.cleanup();
            }
            throw new PluginException(e.toString());
        }
        this.enableSmartCard = this.areSmartcardsEnabled(dtloginSC, dtsessionSC);
        this.cfgProps.setProperty("enabled", this.enableSmartCard ? "True" : "False");
        this.cardRemovalTimeout = this.getIntPropValue(dtsessionSC, cardRemovalTimeoutProp);
        this.reauthTimeout = this.getIntPropValue(dtsessionSC, reauthTimeoutProp);
        this.cardRemovalLogoutWait = this.getIntPropValue(dtsessionSC, cardRemovalLogoutWaitProp);
        this.ignoreCardRemoval = this.getBoolPropValue(dtsessionSC, ignoreCardRemovalProp);
        this.reauthAfterCardRemoval = this.getBoolPropValue(dtsessionSC, reauthAfterCardRemovalProp);
        dtloginSC.cleanup();
        dtsessionSC.cleanup();
        if (this.debug) {
            System.out.println("[Constructor] CDEClientPlugin Parameters:\n          enableSmartCard = " + this.enableSmartCard + "\n" + "       cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "        ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "   reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "            reauthTimeout = " + this.reauthTimeout + "\n" + "    cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        PluginTab tab1 = this.pgc.addTab(this.resourceString("CDEClientPluginTimeouts"));
        this.cardRemovalTimeoutSlider = tab1.addSlider(String.valueOf(this.resourceString("CDEClientPluginRemovalTimeout")) + " (seconds)", 0, this.cardRemovalTimeoutMax);
        this.cardRemovalTimeoutSlider.setValue(this.cardRemovalTimeout);
        this.reauthTimeoutSlider = tab1.addSlider(String.valueOf(this.resourceString("CDEClientPluginReauthTimeout")) + " (seconds)", 0, this.reauthTimeoutMax);
        this.reauthTimeoutSlider.setValue(this.reauthTimeout);
        this.cardRemovalLogoutWaitSlider = tab1.addSlider(String.valueOf(this.resourceString("CDEClientPluginLoginTimeout")) + " (seconds)", 0, this.cardRemovalLogoutWaitMax);
        this.cardRemovalLogoutWaitSlider.setValue(this.cardRemovalLogoutWait);
        PluginTab tab2 = this.pgc.addTab(this.resourceString("CDEClientPluginOptions"));
        this.ignoreCardRemovalCheckbox = tab2.addCheckBox(this.resourceString("CDEClientPluginIgnoreCardRemoval"));
        if (this.ignoreCardRemoval) {
            this.ignoreCardRemovalCheckbox.setChecked();
        } else {
            this.ignoreCardRemovalCheckbox.setUnchecked();
        }
        this.reauthAfterCardRemovalCheckbox = tab2.addCheckBox(this.resourceString("CDEClientPluginReauthenticate"));
        if (this.reauthAfterCardRemoval) {
            this.reauthAfterCardRemovalCheckbox.setChecked();
        } else {
            this.reauthAfterCardRemovalCheckbox.setUnchecked();
        }
    }

    public void activeState(boolean state) {
    }

    private boolean areSmartcardsEnabled(Smartcard sc1, Smartcard sc2) {
        String propValue2;
        String propValue1;
        try {
            propValue1 = sc1.getClientProperty(useSmartCardProp);
            propValue2 = sc2.getClientProperty(useSmartCardProp);
        }
        catch (Exception exception) {
            propValue2 = "False";
            propValue1 = "False";
        }
        boolean b1 = Boolean.valueOf(propValue1);
        boolean b2 = Boolean.valueOf(propValue2);
        return b1 || b2;
    }

    public void buttonAction(PluginButton b) {
    }

    public boolean cancelOperation() {
        return true;
    }

    public void checkBoxAction(PluginCheckBox cb) {
        if (cb == this.ignoreCardRemovalCheckbox) {
            this.ignoreCardRemoval = this.ignoreCardRemovalCheckbox.getState();
        }
        if (cb == this.reauthAfterCardRemovalCheckbox) {
            this.reauthAfterCardRemoval = this.reauthAfterCardRemovalCheckbox.getState();
        }
    }

    public void comboAction(PluginComboBox cb) {
    }

    private void disablePAMsmartcard() {
        try {
            new OCFDisable().disablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Disabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private void enablePAMsmartcard() {
        try {
            new OCFEnable().enablePAMForSC();
        }
        catch (Exception e) {
            this.pgc.popupError("Error Enabling PAM for Smart Card Authentication", e.toString());
        }
    }

    private boolean getBoolPropValue(Smartcard sc, String propName) {
        String propValue;
        try {
            propValue = sc.getClientProperty(propName);
        }
        catch (Exception exception) {
            propValue = null;
        }
        if (propValue == null) {
            propValue = this.cfgProps.getProperty(propName);
        }
        return Boolean.valueOf(propValue);
    }

    private int getIntPropValue(Smartcard sc, String propName) {
        String propValue;
        try {
            propValue = sc.getClientProperty(propName);
        }
        catch (Exception exception) {
            propValue = null;
        }
        if (propValue == null) {
            propValue = this.cfgProps.getProperty(propName);
        }
        return Integer.parseInt(propValue);
    }

    public Properties okButtonPushed(boolean activeState) {
        if (this.debug) {
            System.out.println("[OK|Apply] CDEClientPlugin Parameters:\n              activeState = " + activeState + "\n" + "          enableSmartCard = " + this.enableSmartCard + "\n" + "       cardRemovalTimeout = " + this.cardRemovalTimeout + "\n" + "        ignoreCardRemoval = " + this.ignoreCardRemoval + "\n" + "   reauthAfterCardRemoval = " + this.reauthAfterCardRemoval + "\n" + "            reauthTimeout = " + this.reauthTimeout + "\n" + "    cardRemovalLogoutWait = " + this.cardRemovalLogoutWait);
        }
        boolean stateChange = activeState != this.enableSmartCard;
        this.enableSmartCard = activeState;
        this.cfgProps.setProperty("enabled", this.enableSmartCard ? "True" : "False");
        this.saveCDESettings();
        if (stateChange) {
            if (this.enableSmartCard) {
                this.enablePAMsmartcard();
            } else {
                this.disablePAMsmartcard();
            }
        }
        return this.cfgProps;
    }

    public void passwordAction(PluginPassword pp) {
    }

    private String resourceString(String key) {
        return ResourceManager.getString((String)key, (ResourceBundle)toolBundle);
    }

    private void saveCDESettings() {
        Smartcard dtsessionSC;
        Smartcard dtloginSC;
        block4: {
            dtloginSC = null;
            dtsessionSC = null;
            try {
                dtloginSC = new Smartcard("dtlogin");
                dtsessionSC = new Smartcard("dtsession");
                dtsessionSC.setClientProperty(cardRemovalTimeoutProp, Integer.toString(this.cardRemovalTimeout));
                dtsessionSC.setClientProperty(reauthTimeoutProp, Integer.toString(this.reauthTimeout));
                dtsessionSC.setClientProperty(cardRemovalLogoutWaitProp, Integer.toString(this.cardRemovalLogoutWait));
                dtsessionSC.setClientProperty(ignoreCardRemovalProp, this.ignoreCardRemoval ? "True" : "False");
                dtsessionSC.setClientProperty(reauthAfterCardRemovalProp, this.reauthAfterCardRemoval ? "True" : "False");
                String enabled = this.enableSmartCard ? "True" : "False";
                dtloginSC.setClientProperty(useSmartCardProp, enabled);
                dtsessionSC.setClientProperty(useSmartCardProp, enabled);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("saveCDESettings failed: " + e.toString());
                }
                this.pgc.popupError("Error Saving CDE Settings", "There was an error saving your settings.\nCheck ocfserv and try again.");
                if (dtloginSC != null) {
                    dtloginSC.cleanup();
                }
                if (dtsessionSC == null) break block4;
                dtsessionSC.cleanup();
            }
        }
        dtloginSC.cleanup();
        dtsessionSC.cleanup();
    }

    public void sliderAction(PluginSlider sl) {
        if (sl == this.cardRemovalTimeoutSlider) {
            this.cardRemovalTimeout = this.cardRemovalTimeoutSlider.getValue();
        }
        if (sl == this.reauthTimeoutSlider) {
            this.reauthTimeout = this.reauthTimeoutSlider.getValue();
        }
        if (sl == this.cardRemovalLogoutWaitSlider) {
            this.cardRemovalLogoutWait = this.cardRemovalLogoutWaitSlider.getValue();
        }
    }

    public void textAction(PluginTextField tf) {
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }
}

