/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.terminal;

import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.ScTerminalPropertyFormatException;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import com.sun.smartcard.gui.client.plugin.TerminalPluginGuiCtx;
import com.sun.smartcard.mgt.util.ResourceManager;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class DefaultTerminalPlugin
implements SmartCardPlugin {
    private PluginTextField tfFactory;
    private String tfFactoryDefault;
    private PluginTextField tfName;
    private String tfnameDefault;
    private PluginTextField tfModel;
    private String tfModelDefault;
    private boolean modelMutable;
    private PluginTextField tfPort;
    private PluginComboBox cbPort;
    private String portDefault;
    private boolean anyPortOK;
    private TerminalPluginGuiCtx pgc;
    private boolean unsavedChanges = false;
    private boolean active = false;
    private boolean activeDefault = false;
    private boolean addNewTerminal = false;
    private boolean singleListOnly = true;
    private boolean debug = System.getProperty("debug") != null;
    private Properties defaultTerminalProperties;
    private static ResourceBundle toolBundle = null;

    public DefaultTerminalPlugin(Properties p) {
        this(p, null);
    }

    public DefaultTerminalPlugin(Properties p, TerminalPluginGuiCtx guicontext) {
        toolBundle = ResourceManager.getBundle((String)"com.sun.smartcard.gui.ListResourceBundle.ScConsoleResources", this.getClass());
        this.pgc = guicontext;
        this.pgc.setCallback((SmartCardPlugin)this);
        this.defaultTerminalProperties = p;
        Properties cfgProps = this.pgc.getCfg();
        if (this.debug) {
            System.out.println("\n======= DefaultTerminalPlugin =========================================");
            System.out.println("cfgProps: [" + ((Hashtable)cfgProps).toString() + "]");
            if (p != null) {
                System.out.println("DefaultTerminalPlugin: properties exist: [" + ((Hashtable)p).toString() + "]");
            } else {
                System.out.println("DefaultTerminalPlugin: no properties passed");
            }
        }
        if (p != null && p.getProperty("active") != null || cfgProps.getProperty("active") != null) {
            this.activeDefault = true;
            this.active = true;
        }
        if (p != null) {
            this.setDefaultsFromProperties(p);
        } else {
            this.setDefaultsFromProperties(cfgProps);
            this.addNewTerminal = true;
        }
        if (this.debug) {
            System.out.println("\nDefaultTerminalPlugin: addNewTerminal = [" + this.addNewTerminal + "] " + " active = [" + this.active + "] " + " activeDefault = [" + this.activeDefault + "]");
        }
        String devDirectory = cfgProps.getProperty("devdirectory", "/dev");
        Enumeration readerDevs = null;
        if (cfgProps.getProperty("porttype", "notserial").equals("serial")) {
            readerDevs = this.getAllDeviceNames(devDirectory);
        } else if (cfgProps.getProperty("porttype", "notinternal").equals("internal")) {
            readerDevs = this.getFilteredDeviceNames(devDirectory, "scmi2c");
        }
        this.modelMutable = cfgProps.getProperty("modelmutable", "false").equals("false") ^ true;
        this.anyPortOK = cfgProps.getProperty("anyportok", "true").equals("true");
        PluginTab tab1 = this.pgc.addTab(this.resourceString("DefaultTerminalPluginBasicConfig"));
        this.tfName = tab1.addTextField(this.resourceString("DefaultTerminalPluginUniqueName"));
        this.tfName.setText(this.tfnameDefault);
        this.tfModel = tab1.addTextField(this.resourceString("DefaultTerminalPluginModelName"));
        this.tfModel.setText(this.tfModelDefault);
        this.tfModel.setEditable(this.modelMutable);
        if (readerDevs != null) {
            this.cbPort = tab1.addComboBox(this.resourceString("DefaultTerminalPluginDevicePort"), this.anyPortOK);
            while (readerDevs.hasMoreElements()) {
                String readerDev = (String)readerDevs.nextElement();
                this.cbPort.addEntry(readerDev);
                if (this.portDefault != null) continue;
                this.portDefault = readerDev;
            }
            this.cbPort.setSelectedItem((Object)this.portDefault);
        } else {
            if (this.portDefault == null) {
                this.portDefault = new String("");
            }
            this.tfPort = tab1.addTextField(this.resourceString("DefaultTerminalPluginDevicePort"));
            this.tfPort.setText(this.portDefault);
        }
        PluginTab tab2 = this.pgc.addTab(this.resourceString("DefaultTerminalPluginAdvancedConfig"));
        this.tfFactory = tab2.addTextField(this.resourceString("DefaultTerminalPluginCTF"));
        this.tfFactory.setText(this.tfFactoryDefault);
    }

    public void activeState(boolean state) {
        this.active = state;
        if (this.debug) {
            System.out.println("DefaultTerminalPlugin.activeState: active = [" + this.active + "]");
        }
    }

    public void buttonAction(PluginButton b) {
    }

    public boolean cancelOperation() {
        if (this.debug) {
            System.out.println("DefaultTerminalPlugin.cancelOperation");
        }
        this.checkUnsavedChanges();
        if (this.unsavedChanges) {
            String ync = this.pgc.popupQuestion(this.resourceString("DefaultTerminalPluginUnsavedTitle"), this.resourceString("DefaultTerminalPluginUnsavedText"));
            if (this.debug) {
                System.out.println("DefaultTerminalPlugin.cancelOperation: ync = [" + ync + "]");
            }
            if (!ync.equals("YES")) {
                return false;
            }
        }
        return true;
    }

    public void checkBoxAction(PluginCheckBox cb) {
    }

    public boolean checkDeviceName(String terminalPort) {
        this.pgc.enableBusyCursor();
        boolean onActiveList = this.pgc.activeDeviceExists(terminalPort);
        boolean onInactiveList = this.pgc.inactiveDeviceExists(terminalPort);
        boolean nameChanged = terminalPort.equals(this.portDefault) ^ true;
        this.pgc.disableBusyCursor();
        boolean dupOnActive = false;
        boolean dupOnInactive = false;
        if (this.addNewTerminal || nameChanged) {
            if (onActiveList) {
                dupOnActive = true;
            }
            if (onInactiveList) {
                dupOnInactive = true;
            }
        } else if (this.active != this.activeDefault) {
            if (this.active && onActiveList) {
                dupOnActive = true;
            }
            if (!this.active && onInactiveList) {
                dupOnInactive = true;
            }
        }
        if (dupOnActive || dupOnInactive) {
            String conflictList = dupOnActive ? "ACTIVE" : "INACTIVE";
            this.pgc.popupError("Duplicate Name", "This device name: [" + terminalPort + "] already exists on the " + conflictList + " list");
            return false;
        }
        return true;
    }

    public boolean checkTerminalName(String terminalName) {
        this.pgc.enableBusyCursor();
        boolean onActiveList = this.pgc.activeTerminalExists(terminalName);
        boolean onInactiveList = this.pgc.inactiveTerminalExists(terminalName);
        boolean nameChanged = terminalName.equals(this.tfnameDefault) ^ true;
        this.pgc.disableBusyCursor();
        boolean dupOnActive = false;
        boolean dupOnInactive = false;
        if (this.addNewTerminal || nameChanged) {
            if (onActiveList) {
                dupOnActive = true;
            }
            if (onInactiveList) {
                dupOnInactive = true;
            }
        } else if (this.active != this.activeDefault) {
            if (this.active && onActiveList) {
                dupOnActive = true;
            }
            if (!this.active && onInactiveList) {
                dupOnInactive = true;
            }
        }
        if (dupOnActive || dupOnInactive) {
            String conflictList = dupOnActive ? "ACTIVE" : "INACTIVE";
            this.pgc.popupError("Duplicate Name", "This terminal name: [" + terminalName + "] already exists on the " + conflictList + " list");
            return false;
        }
        return true;
    }

    public void checkUnsavedChanges() {
        String terminalFactory = this.tfFactory.getText();
        String terminalName = this.tfName.getText();
        String terminalModel = this.tfModel.getText();
        String terminalPort = this.cbPort != null ? this.cbPort.getSelectedEntry() : this.tfPort.getText();
        Properties ap = new Properties();
        ap.setProperty("factory", terminalFactory);
        ap.setProperty("name", terminalName);
        ap.setProperty("model", terminalModel);
        ap.setProperty("port", terminalPort);
        this.checkUnsavedChanges(ap);
    }

    public void checkUnsavedChanges(Properties ap) {
        String terminalFactory = ap.getProperty("factory");
        String terminalName = ap.getProperty("name");
        String terminalModel = ap.getProperty("model");
        String terminalPort = ap.getProperty("port");
        this.unsavedChanges = !terminalFactory.equals(this.tfFactoryDefault) || !terminalName.equals(this.tfnameDefault) || !terminalModel.equals(this.tfModelDefault) || !terminalPort.equals(this.portDefault);
        if (this.active != this.activeDefault) {
            this.unsavedChanges = true;
        }
        if (this.addNewTerminal) {
            this.unsavedChanges = true;
        }
        if (this.debug) {
            System.out.println("DefaultTerminalPlugin.checkUnsavedChanges: unsavedChanges = " + this.unsavedChanges);
        }
    }

    public void comboAction(PluginComboBox cb) {
    }

    private Enumeration getAllDeviceNames(String devDir) {
        File devDirFile = new File(devDir);
        File[] devFiles = devDirFile.listFiles();
        if (devFiles == null) {
            return null;
        }
        Vector<String> devNames = new Vector<String>();
        int fn = 0;
        while (fn < devFiles.length) {
            if (this.debug) {
                System.out.println("getPath(): [" + devFiles[fn].getPath() + "]\n" + " isFile(): [" + devFiles[fn].isFile() + "]");
            }
            if (!(devFiles[fn].isFile() || devFiles[fn].isDirectory() || devFiles[fn].isHidden())) {
                devNames.add(devFiles[fn].getPath());
            }
            ++fn;
        }
        if (devNames.isEmpty()) {
            return null;
        }
        return devNames.elements();
    }

    private Enumeration getFilteredDeviceNames(String devDir, String nodePrefix) {
        File devDirFile = new File(devDir);
        File[] devFiles = devDirFile.listFiles();
        if (devFiles == null) {
            return null;
        }
        Vector<String> devNames = new Vector<String>();
        int fn = 0;
        while (fn < devFiles.length) {
            String fileName;
            if (this.debug) {
                System.out.println("getPath(): [" + devFiles[fn].getPath() + "]\n" + " isFile(): [" + devFiles[fn].isFile() + "]");
            }
            if (!devFiles[fn].isFile() && !devFiles[fn].isDirectory() && !devFiles[fn].isHidden() && (fileName = devFiles[fn].getName()).startsWith(nodePrefix)) {
                devNames.add(devFiles[fn].getPath());
            }
            ++fn;
        }
        if (devNames.isEmpty()) {
            return null;
        }
        return devNames.elements();
    }

    public Properties okButtonPushed(boolean activeState) {
        this.pgc.enableBusyCursor();
        this.active = activeState;
        String terminalName = this.tfName.getText();
        String terminalModel = this.tfModel.getText();
        String terminalPort = this.cbPort != null ? this.cbPort.getSelectedEntry() : this.tfPort.getText();
        String terminalFactory = this.tfFactory.getText();
        Properties ap = new Properties();
        ap.setProperty("name", terminalName);
        ap.setProperty("model", terminalModel);
        ap.setProperty("port", terminalPort);
        ap.setProperty("factory", terminalFactory);
        this.checkUnsavedChanges(ap);
        if (this.debug) {
            System.out.println("OK Button pushed.          name: [" + terminalName + "]\n" + "         model: [" + terminalModel + "]\n" + "          port: [" + terminalPort + "]\n" + "       factory: [" + terminalFactory + "]\n" + "        active: [" + this.active + "]\n" + "unsavedChanges: [" + this.unsavedChanges + "]\n" + "addNewTerminal: [" + this.addNewTerminal + "]\n" + "        active: [" + this.active + "]\n" + " activeDefault: [" + this.activeDefault + "]\n" + "unsavedChanges: [" + this.unsavedChanges + "]");
        }
        if (!this.unsavedChanges) {
            this.pgc.disableBusyCursor();
            return ap;
        }
        try {
            this.pgc.checkTerminalPropertyFormat(ap);
        }
        catch (ScTerminalPropertyFormatException stpfe) {
            this.pgc.disableBusyCursor();
            this.pgc.popupError("Error in Terminal Properties", stpfe.getMessage());
            return null;
        }
        if (!this.checkTerminalName(terminalName)) {
            return null;
        }
        if (!this.checkDeviceName(terminalPort)) {
            return null;
        }
        if (!this.addNewTerminal) {
            this.pgc.removeTerminal(this.tfnameDefault, this.activeDefault);
        }
        try {
            this.pgc.addTerminal(ap, this.active);
        }
        catch (ScTerminalPropertyFormatException stpfe) {
            this.pgc.disableBusyCursor();
            this.pgc.popupWarning("Terminal Property Format Error", stpfe.getMessage());
            if (!this.addNewTerminal) {
                try {
                    this.pgc.enableBusyCursor();
                    this.pgc.addTerminal(this.defaultTerminalProperties, this.activeDefault);
                }
                catch (ScTerminalPropertyFormatException stpfe2) {
                    this.pgc.disableBusyCursor();
                    this.pgc.popupError("Can't Recover Previous Terminal State", stpfe2.getMessage());
                }
            }
            this.pgc.disableBusyCursor();
            return null;
        }
        this.activeDefault = this.active;
        this.addNewTerminal = false;
        this.setDefaultsFromProperties(ap);
        this.pgc.disableBusyCursor();
        return ap;
    }

    public void passwordAction(PluginPassword pp) {
    }

    private String resourceString(String key) {
        return ResourceManager.getString((String)key, (ResourceBundle)toolBundle);
    }

    public void setDefaultsFromProperties(Properties p) {
        this.tfFactoryDefault = p.getProperty("factory");
        this.tfnameDefault = p.getProperty("name");
        this.tfModelDefault = p.getProperty("model");
        this.portDefault = p.getProperty("port");
    }

    public void sliderAction(PluginSlider sl) {
    }

    public void textAction(PluginTextField tf) {
        String tfn = "(unknown)";
        if (tf == this.tfName) {
            tfn = "name";
        } else if (tf == this.tfModel) {
            tfn = "model";
        } else if (tf == this.tfPort) {
            tfn = "port";
        } else if (tf == this.tfFactory) {
            tfn = "factory";
        }
        if (this.debug) {
            System.out.println("DefaultTerminalPlugin.textAction: Updated: [" + tfn + "] " + "Contents: [" + tf.getText() + "]");
        }
    }

    public void toggleButtonAction(boolean toggleButtonState) {
    }
}

