/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.VException;
import com.sun.management.viper.VService;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.server.repository.ViperAdminInterface;
import java.rmi.RemoteException;
import java.util.Vector;

public class ViperAdminImpl
extends VService
implements ViperAdminInterface {
    private Vector serviceInfoList = null;
    private Vector toolInfoList = null;
    private Vector libraryInfoList = null;
    private Vector userInfoList = null;
    private Vector serverStatusInfo = null;

    private static String baseName(String string) {
        int n = string.indexOf(64);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public int getConnectionListSize() throws RemoteException, VException {
        int n = this.getUsageInformation().size();
        return n;
    }

    public Vector getLibraryList() throws RemoteException {
        return this.getViperLibraryList();
    }

    public int getLibraryListSize() throws RemoteException {
        int n = this.getViperLibraryList().size();
        return n;
    }

    public Vector getServerStatus() throws RemoteException, VException {
        this.serverStatusInfo = new Vector();
        String string = SMCVersion.getFullVersion();
        if (string == null) {
            string = "";
        }
        this.serverStatusInfo.addElement(string);
        string = System.getProperty("viper.servlet.port");
        if (string == null) {
            string = "";
        }
        this.serverStatusInfo.addElement(string);
        string = System.getProperty("os.version");
        if (string == null) {
            string = "";
        }
        this.serverStatusInfo.addElement(string);
        string = ViperServer.getServerStartDate().toString();
        if (string == null) {
            string = "";
        }
        this.serverStatusInfo.addElement(string);
        int n = this.getUsageInformation().size();
        this.serverStatusInfo.addElement(new Integer(n).toString());
        return this.serverStatusInfo;
    }

    public Vector getServiceList() throws RemoteException {
        return this.getViperServiceList();
    }

    public int getServiceListSize() throws RemoteException {
        int n = this.getViperServiceList().size();
        return n;
    }

    public Vector getToolList() throws RemoteException {
        return this.getViperToolList();
    }

    public int getToolListSize() throws RemoteException {
        int n = this.getViperToolList().size();
        return n;
    }

    public Vector getUsageInformation() throws RemoteException, VException {
        ConnectionInfo[] connectionInfoArray = ViperServer.getUsageInfo();
        if (connectionInfoArray.length > 0) {
            this.userInfoList = new Vector(connectionInfoArray.length);
            int n = 0;
            while (n < connectionInfoArray.length) {
                Vector<Object> vector = new Vector<Object>(5);
                VCallerImpl vCallerImpl = connectionInfoArray[n].getUserId();
                String string = "";
                if (vCallerImpl != null) {
                    string = String.valueOf(vCallerImpl.getPrimaryName()) + " (" + vCallerImpl.getUid() + ")";
                }
                vector.addElement(string);
                if (vCallerImpl != null) {
                    vector.addElement(vCallerImpl.getAuthenHost());
                } else {
                    vector.addElement("Unknown");
                }
                vector.addElement(connectionInfoArray[n].getUserLogonTime());
                string = "";
                Vector vector2 = connectionInfoArray[n].getLoadedServices();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    string = n2 == vector2.size() - 1 ? String.valueOf(string) + (String)vector2.elementAt(n2) : String.valueOf(string) + (String)vector2.elementAt(n2) + ", ";
                    ++n2;
                }
                vector.addElement(string.trim());
                string = "";
                vector2 = connectionInfoArray[n].getLoadedTools();
                int n3 = 0;
                while (n3 < vector2.size()) {
                    string = n3 == vector2.size() - 1 ? String.valueOf(string) + (String)vector2.elementAt(n3) : String.valueOf(string) + (String)vector2.elementAt(n3) + ", ";
                    ++n3;
                }
                vector.addElement(string.trim());
                this.userInfoList.addElement(vector);
                ++n;
            }
        }
        return this.userInfoList;
    }

    public Vector getViperLibraryList() {
        LibInfoImpl[] libInfoImplArray = VRegistry.readAllLibJars();
        if (libInfoImplArray != null && libInfoImplArray.length > 0 && libInfoImplArray.length > 0) {
            this.libraryInfoList = new Vector(libInfoImplArray.length);
            int n = 0;
            while (n < libInfoImplArray.length) {
                Vector<Object> vector = new Vector<Object>(4);
                vector.addElement(ViperAdminImpl.baseName(libInfoImplArray[n].getJarName()));
                vector.addElement(ViperAdminImpl.pseudoBeanName(libInfoImplArray[n].getJarName()));
                vector.addElement(libInfoImplArray[n].getRegistrarDate());
                String string = "";
                String[] stringArray = libInfoImplArray[n].getNativeLibs();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    string = n2 == stringArray.length - 1 ? String.valueOf(string) + ViperAdminImpl.baseName(stringArray[n2]) : String.valueOf(string) + ViperAdminImpl.baseName(stringArray[n2]) + ",";
                    ++n2;
                }
                vector.addElement(string);
                this.libraryInfoList.addElement(vector);
                ++n;
            }
        }
        return this.libraryInfoList;
    }

    private Vector getViperServiceList() {
        boolean bl = false;
        ServiceInfoImpl[] serviceInfoImplArray = VRegistry.readServices();
        if (serviceInfoImplArray != null && serviceInfoImplArray.length > 0) {
            this.serviceInfoList = new Vector(serviceInfoImplArray.length);
            int n = 0;
            while (n < serviceInfoImplArray.length) {
                Vector<Object> vector = new Vector<Object>(8);
                vector.addElement(serviceInfoImplArray[n].getClassName());
                vector.addElement(serviceInfoImplArray[n].getVersion());
                vector.addElement(serviceInfoImplArray[n].getRegistrarDate());
                vector.addElement(serviceInfoImplArray[n].getResourceBaseName());
                String string = "";
                String[] stringArray = serviceInfoImplArray[n].getLoadDependencies();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        string = n2 == stringArray.length ? String.valueOf(string) + stringArray[n2] : String.valueOf(string) + stringArray[n2] + ",";
                        ++n2;
                    }
                }
                vector.addElement(string);
                if (serviceInfoImplArray[n].isDaemon()) {
                    vector.addElement(new Boolean(true));
                } else {
                    vector.addElement(new Boolean(false));
                }
                if (serviceInfoImplArray[n].isSingleton()) {
                    vector.addElement(new Boolean(true));
                } else {
                    vector.addElement(new Boolean(false));
                }
                String string2 = "";
                String[] stringArray2 = serviceInfoImplArray[n].getNativeLibs();
                if (stringArray2 != null) {
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        string2 = n3 == stringArray2.length - 1 ? String.valueOf(string2) + ViperAdminImpl.baseName(stringArray2[n3]) : String.valueOf(string2) + ViperAdminImpl.baseName(stringArray2[n3]) + ",";
                        ++n3;
                    }
                }
                vector.addElement(string2);
                LibInfoImpl[] libInfoImplArray = serviceInfoImplArray[n].getAttachments();
                String string3 = "";
                int n4 = 0;
                while (n4 < libInfoImplArray.length) {
                    string3 = n4 == libInfoImplArray.length - 1 ? String.valueOf(string3) + ViperAdminImpl.baseName(libInfoImplArray[n4].getJarName()) : String.valueOf(string3) + ViperAdminImpl.baseName(libInfoImplArray[n4].getJarName()) + ",";
                    ++n4;
                }
                vector.addElement(string3);
                this.serviceInfoList.addElement(vector);
                ++n;
            }
        }
        return this.serviceInfoList;
    }

    private Vector getViperToolList() {
        ToolInfoImpl[] toolInfoImplArray = VRegistry.readTools();
        if (toolInfoImplArray != null && toolInfoImplArray.length > 0) {
            this.toolInfoList = new Vector(toolInfoImplArray.length);
            int n = 0;
            while (n < toolInfoImplArray.length) {
                Vector<Object> vector = new Vector<Object>(5);
                vector.addElement(toolInfoImplArray[n].getClassName());
                vector.addElement(toolInfoImplArray[n].getVersion());
                vector.addElement(toolInfoImplArray[n].getRegistrarDate());
                vector.addElement(toolInfoImplArray[n].getResourceBaseName());
                String[] stringArray = toolInfoImplArray[n].getNativeLibs();
                String string = "";
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        string = n2 == stringArray.length - 1 ? String.valueOf(string) + ViperAdminImpl.baseName(stringArray[n2]) : String.valueOf(string) + ViperAdminImpl.baseName(stringArray[n2]) + ",";
                        ++n2;
                    }
                }
                vector.addElement(string);
                LibInfoImpl[] libInfoImplArray = toolInfoImplArray[n].getAttachments();
                String string2 = "";
                int n3 = 0;
                while (n3 < libInfoImplArray.length) {
                    string2 = n3 == libInfoImplArray.length - 1 ? String.valueOf(string2) + ViperAdminImpl.baseName(libInfoImplArray[n3].getJarName()) : String.valueOf(string2) + ViperAdminImpl.baseName(libInfoImplArray[n3].getJarName()) + ",";
                    ++n3;
                }
                vector.addElement(string2);
                this.toolInfoList.addElement(vector);
                ++n;
            }
        }
        return this.toolInfoList;
    }

    private static String pseudoBeanName(String string) {
        int n = string.indexOf(64);
        if (n > 0) {
            int n2 = string.substring(0, n).indexOf(47);
            if (n2 < 0) {
                return string.substring(0, n);
            }
            return string.substring(0, n).substring(n2 + 1);
        }
        return string;
    }
}

