/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.common.EventDispatcher;
import com.sun.opencard.common.EventListener;
import com.sun.opencard.common.ObjectCloseListener;
import java.util.HashMap;

public abstract class ClosableObject {
    private EventDispatcher eventDispatcher;
    private HashMap listeners;
    private boolean isActive;

    protected ClosableObject(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.listeners = new HashMap();
        this.isActive = true;
    }

    public void addCloseListener(final ObjectCloseListener objectCloseListener) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (!this.isActive) {
                Object var3_3 = null;
                return;
            }
            this.listeners.put(objectCloseListener, new EventListener(){

                public void dispatchEvent(Object object) {
                    objectCloseListener.objectClosed((ClosableObject)object);
                }
            });
        }
    }

    protected void close() {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.isActive = false;
            this.eventDispatcher.enqueueEvent(this, ((HashMap)this.listeners.clone()).values());
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void removeCloseListener(ObjectCloseListener objectCloseListener) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.remove(objectCloseListener);
        }
    }
}

