/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.UnsupportedEncodingException;
import opencard.core.OpenCardConstants;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;

public class CardFileAppID
extends CardFilePathComponent
implements OpenCardConstants {
    private boolean asByteSequence = false;

    public CardFileAppID(String string) {
        super(string);
        if (string.startsWith("#")) {
            this.asByteSequence = true;
            if ((string.length() - 1) % 2 != 0) {
                throw new IllegalArgumentException("odd number of characters");
            }
        }
    }

    public boolean equals(Object object) {
        byte[] byArray;
        if (!(object instanceof CardFileAppID)) {
            return false;
        }
        byte[] byArray2 = this.toByteArray();
        if (byArray2.length != (byArray = ((CardFileAppID)object).toByteArray()).length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.toByteArray();
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = ((n & 0xFF000000) >>> 21) + (n << 8) + byArray[n2];
            ++n2;
        }
        return n;
    }

    public byte[] toByteArray() {
        if (!this.asByteSequence) {
            try {
                return this.comp.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CardIOException("cannot retrieve byte representation for \"" + this.comp + "\" via " + "8859_1" + "encoding");
            }
        }
        int n = (this.comp.length() - 1) / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(Integer.parseInt(this.comp.substring(n2 * 2 + 1, n2 * 2 + 3), 16) & 0xFF);
            ++n2;
        }
        return byArray;
    }
}

