/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.email;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.email.EmailContent;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AdminEmailDialog
extends AdminDialog {
    public static final int MAX_CHAR_MEM_LIST = 1000;
    public static final int LEN_INCLUDE = 9;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField emailTextField;
    private JTextArea emailMemTextArea;
    private GenInfoPanel infoPanel;
    private JPanel blankPanel;
    private boolean bAddingNewAlias = false;
    private EmailAliasObj thisEmailObj = null;
    private String strOrigAliasname = "";
    private VUserMgr theApp;
    private ResourceBundle bundle;
    private EmailContent emailContent;
    private ActionString actionString;
    private Boolean applyInProgress = new Boolean(false);

    public AdminEmailDialog(VUserMgr vUserMgr, EmailContent emailContent) {
        this(vUserMgr, emailContent, null);
    }

    public AdminEmailDialog(VUserMgr vUserMgr, EmailContent emailContent, EmailAliasObj emailAliasObj) {
        super((Frame)vUserMgr.getFrame(), "", false);
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.emailContent = emailContent;
        if (emailAliasObj == null) {
            this.bAddingNewAlias = true;
            ((Dialog)((Object)this)).setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"new_email_title"));
        } else {
            this.bAddingNewAlias = false;
            this.strOrigAliasname = emailAliasObj.getAliasName();
            ((Dialog)((Object)this)).setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"email_props"));
            AdminCommonTools.CMN_HandleOutput((String)("Setting emailObj: " + emailAliasObj));
            AdminCommonTools.CMN_HandleOutput((String)("This emailObj: " + this.thisEmailObj));
            this.thisEmailObj = emailAliasObj;
        }
        this.infoPanel = this.getInfoPanel();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createEmailPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.okButton.setEnabled(false);
        if (vUserMgr.getUserMgr().hasUserMgrWriteAuth()) {
            this.okButton.setEnabled(true);
        }
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        ((Window)((Object)this)).pack();
        Vector vector = new Vector(6);
        if (this.bAddingNewAlias) {
            this.emailTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_add_alias")));
            this.emailMemTextArea.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_add_members")));
            this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_add")), true);
        } else {
            this.emailTextField.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_prop_alias")));
            this.emailMemTextArea.addFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_prop_members")));
            this.setDefaultFocusListener((FocusListener)((Object)new UMgrContextHelpListener(vUserMgr, vector, this.infoPanel, "email_prop")), true);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)((Object)this)).setLocation(dimension.width / 2 - ((Component)((Object)this)).getSize().width / 2, dimension.height / 2 - ((Component)((Object)this)).getSize().height / 2);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Window)((Object)AdminEmailDialog.this)).dispose();
            }
        };
        ((Window)((Object)this)).addWindowListener(windowAdapter);
    }

    static /* synthetic */ boolean access$4(AdminEmailDialog adminEmailDialog) {
        return adminEmailDialog.bAddingNewAlias;
    }

    private JPanel createEmailPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.setUpLabel(jLabel, "alias_name");
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0, (int)30, (int)24, (int)10, (int)0);
        if (this.bAddingNewAlias) {
            this.emailTextField = new JTextField(15);
            this.emailMemTextArea = new JTextArea(9, 33);
        } else {
            this.emailTextField = new JTextField(this.thisEmailObj.getAliasName(), 15);
            this.emailMemTextArea = new JTextArea(this.thisEmailObj.getAliasExpansion(), 9, 33);
        }
        this.emailTextField.setMinimumSize(this.emailTextField.getPreferredSize());
        jLabel.setLabelFor(this.emailTextField);
        Constraints.constrain((Container)jPanel, (Component)this.emailTextField, (int)1, (int)0, (int)1, (int)1, (int)0, (int)16, (double)1.0, (double)0.0, (int)30, (int)16, (int)10, (int)0);
        JLabel jLabel2 = new JLabel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"alias_mem"));
        this.setUpLabel(jLabel2, "alias_mem");
        Constraints.constrain((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (int)2, (int)1, (int)0, (int)16, (double)1.0, (double)0.0, (int)20, (int)24, (int)10, (int)0);
        this.emailMemTextArea.setLineWrap(true);
        this.emailMemTextArea.setWrapStyleWord(true);
        jLabel2.setLabelFor(this.emailMemTextArea);
        JScrollPane jScrollPane = new JScrollPane(this.emailMemTextArea);
        Constraints.constrain((Container)jPanel, (Component)jScrollPane, (int)0, (int)2, (int)2, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (int)10, (int)24, (int)10, (int)15);
        return jPanel;
    }

    private boolean doSyntaxEndsMatchUp(String string) {
        ErrorDialog errorDialog;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        while (n6 < string.length()) {
            if (string.charAt(n6) == '<') {
                ++n;
            } else if (string.charAt(n6) == '>') {
                ++n2;
            } else if (string.charAt(n6) == '(') {
                ++n3;
            } else if (string.charAt(n6) == ')') {
                ++n4;
            } else if (string.charAt(n6) == '\"') {
                ++n5;
            }
            ++n6;
        }
        if (n != n2) {
            errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_bracket_mismatch"));
            bl = false;
        }
        if (n3 != n4) {
            errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_paren_mismatch"));
            bl = false;
        }
        if (n5 % 2 != 0) {
            errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_quote_mismatch"));
            bl = false;
        }
        return bl;
    }

    private boolean isCommaUsageOK(String string) {
        boolean bl = true;
        String string2 = "";
        String[] stringArray = this.parseOutAddresses(string);
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            if ((string2 = string2.trim()) == null || string2.equals("")) {
                bl = false;
            }
            ++n;
        }
        if (string.charAt(0) == ',' || string.charAt(string.length() - 1) == ',') {
            bl = false;
        }
        return bl;
    }

    public boolean isCreateEmailOK() {
        boolean bl = true;
        String string = this.emailMemTextArea.getText();
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        EmailAliasObj emailAliasObj = new EmailAliasObj(this.emailTextField.getText());
        emailAliasObj.setAliasExpansion(string);
        try {
            this.theApp.getUserMgr().addEmailAlias(emailAliasObj);
            Vector<EmailAliasObj> vector = new Vector<EmailAliasObj>();
            vector.addElement(emailAliasObj);
            if (this.emailContent != null) {
                this.emailContent.appendToResultsPane(vector);
            }
        }
        catch (Exception exception) {
            bl = false;
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), exception.getLocalizedMessage());
            Boolean bl2 = this.applyInProgress;
            synchronized (bl2) {
                this.applyInProgress = Boolean.FALSE;
            }
            this.theApp.waitOff();
        }
        return bl;
    }

    public boolean isEmailSyntaxOK() {
        String[] stringArray = new String[]{"0", " ", "@", ".", "-", "_", "<", ">", "(", ")", "\""};
        String[] stringArray2 = new String[]{"0", "@", ".", "-", "_", "/", "\\", ":", "\"", "|", ",", " ", "\t", "\n", "\r"};
        String string = this.emailTextField.getText();
        String string2 = this.emailMemTextArea.getText();
        if (this.emailTextField.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_add"));
            return false;
        }
        if (!CheckSyntax.isStringOK((String)this.emailTextField.getText(), (String[])stringArray)) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_chars"));
            return false;
        }
        if (!Character.isLetter(this.emailTextField.getText().charAt(0)) && this.emailTextField.getText().charAt(0) != '<') {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_name1"));
            return false;
        }
        if (string.equalsIgnoreCase("postmaster") && this.emailMemTextArea.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_postmaster_null"));
            return false;
        }
        if (string.equalsIgnoreCase("MAILER-DAEMON") && this.emailMemTextArea.getText().equals("")) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_maildaemon_null"));
            return false;
        }
        if (!this.doSyntaxEndsMatchUp(string)) {
            return false;
        }
        if ((string2 = string2.trim()) == null || string2.equals("")) {
            return true;
        }
        if (string2.length() > 1000) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_members1"));
            return false;
        }
        if (!this.isCommaUsageOK(string2)) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_bad_comma"));
            return false;
        }
        if (!CheckSyntax.isStringOK((String)this.emailMemTextArea.getText(), (String[])stringArray2)) {
            ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_members2"));
            return false;
        }
        return this.isValidDeliverySyntax(this.emailMemTextArea.getText());
    }

    public boolean isModifyEmailOK() {
        EmailAliasObj emailAliasObj = this.thisEmailObj;
        EmailAliasObj emailAliasObj2 = (EmailAliasObj)emailAliasObj.clone();
        String[] stringArray = new String[]{"0", "@", ".", "-"};
        String string = this.emailTextField.getText();
        String string2 = this.emailMemTextArea.getText();
        boolean bl = false;
        if (!emailAliasObj.getAliasName().equals(string)) {
            bl = true;
        }
        if (bl || !emailAliasObj.getAliasExpansion().equals(string2)) {
            emailAliasObj2.setAliasName(string);
            string2 = string2.replace('\n', ' ');
            string2 = string2.replace('\r', ' ');
            emailAliasObj2.setAliasExpansion(string2);
            EmailAliasObj emailAliasObj3 = null;
            try {
                if (!emailAliasObj2.equals(emailAliasObj)) {
                    emailAliasObj3 = this.theApp.getUserMgr().modifyEmailAlias(emailAliasObj2, emailAliasObj);
                }
                if (bl) {
                    Content content = this.theApp.getTree().getCurrentContent();
                    Vector vector = content.getSelected();
                    VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                    vScopeNode.setText(string);
                    vScopeNode.setPayload((Object)emailAliasObj3);
                    VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)content.getTreeNode());
                    this.theApp.fireConsoleAction(vConsoleEvent);
                }
            }
            catch (Exception exception) {
                new ErrorDialog(this.theApp.getFrame(), exception.getLocalizedMessage());
                Boolean bl2 = this.applyInProgress;
                synchronized (bl2) {
                    this.applyInProgress = Boolean.FALSE;
                }
                this.theApp.waitOff();
                return false;
            }
        }
        return true;
    }

    private boolean isValidDeliverySyntax(String string) {
        boolean bl = true;
        String string2 = "";
        String[] stringArray = this.parseOutAddresses(string);
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            string2 = stringArray[n];
            string2 = string2.trim();
            char c = string2.charAt(0);
            char c2 = '\u0000';
            if (string2.length() > 1) {
                c2 = string2.charAt(1);
            }
            if (c == '/' && c2 == '\u0000') {
                ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_bad_file_path"));
                return false;
            }
            if (c == '/') {
                if (!CheckSyntax.isHomeDirPathnameOK((String)string2)) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_bad_file_path"));
                    return false;
                }
            } else if (c == '|' || c == '\"' && c2 == '|') {
                n2 = string2.charAt(string2.length() - 1);
                char c3 = c2;
                String string3 = "";
                if (c == '|') {
                    string3 = string2.substring(1);
                    string3 = string3.trim();
                    c3 = string3.charAt(0);
                }
                if (c == '\"' && n2 != 34) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_quote_err"));
                    return false;
                }
                if (c == '|' && (c2 == '\"' || c3 == '\"') && n2 != 34) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_quote_err"));
                    return false;
                }
                if (c != '\"' && c2 != '\"' && c3 != '\"' && n2 == 34) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_quote_err"));
                    return false;
                }
                if (c != '\"' && c2 != '\"' && c3 != '\"') {
                    if (string2.indexOf(32, 0) != -1) {
                        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_need_quotes"));
                        return false;
                    }
                    String string4 = string2.substring(1);
                    if (!CheckSyntax.isHomeDirPathnameOK((String)(string4 = string4.trim()))) {
                        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_bad_path"));
                        return false;
                    }
                }
            } else if (c == ':') {
                if (!string2.startsWith(":include:")) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_bad_mailing_list"));
                    return false;
                }
                String string5 = string2.substring(9);
                if (!CheckSyntax.isHomeDirPathnameOK((String)(string5 = string5.trim()))) {
                    ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_bad_mailing_list_path"));
                    return false;
                }
            } else {
                string2 = string2.trim();
                n2 = 0;
                while (n2 < string2.length()) {
                    if (!(string2.charAt(n2) != ' ' && string2.charAt(n2) != '\t' || string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"')) {
                        ErrorDialog errorDialog = new ErrorDialog(this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_email_expans_bad_quoting"));
                        return false;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    public void onEnterKey() {
    }

    private String[] parseOutAddresses(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        Vector<String> vector = new Vector<String>();
        string3 = string;
        string3 = string3.trim();
        n = string3.indexOf(44);
        while (n != -1) {
            string2 = string3.substring(0, n);
            string2 = string2.trim();
            vector.addElement(string2);
            string3 = string3.substring(n + 1);
            string3 = string3.trim();
            n = string3.indexOf(44);
        }
        if (n == -1) {
            vector.addElement(string3);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void setUpLabel(JLabel jLabel, String string) {
        this.actionString = new ActionString(this.bundle, string);
        jLabel.setText(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        static /* synthetic */ AdminEmailDialog access$0(OKCancelButtonListener oKCancelButtonListener) {
            return oKCancelButtonListener.AdminEmailDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block14: {
                try {
                    if (actionEvent.getSource() == AdminEmailDialog.this.okButton) {
                        Object object = AdminEmailDialog.this.applyInProgress;
                        synchronized (object) {
                            if (AdminEmailDialog.this.applyInProgress.booleanValue()) {
                                Object var3_5 = null;
                                return;
                            }
                            AdminEmailDialog.this.applyInProgress = Boolean.TRUE;
                        }
                        object = new Thread(this){
                            private final /* synthetic */ OKCancelButtonListener this$1;
                            {
                                this.this$1 = oKCancelButtonListener;
                            }

                            public void run() {
                                AdminEmailDialog.access$3(OKCancelButtonListener.access$0(this.this$1)).waitOn();
                                if (OKCancelButtonListener.access$0(this.this$1).isEmailSyntaxOK()) {
                                    if (AdminEmailDialog.access$4(OKCancelButtonListener.access$0(this.this$1)) && OKCancelButtonListener.access$0(this.this$1).isCreateEmailOK()) {
                                        ((Window)((Object)OKCancelButtonListener.access$0(this.this$1))).dispose();
                                    } else if (!AdminEmailDialog.access$4(OKCancelButtonListener.access$0(this.this$1)) && OKCancelButtonListener.access$0(this.this$1).isModifyEmailOK()) {
                                        ((Window)((Object)OKCancelButtonListener.access$0(this.this$1))).dispose();
                                    }
                                }
                                Boolean bl = AdminEmailDialog.access$1(OKCancelButtonListener.access$0(this.this$1));
                                synchronized (bl) {
                                    AdminEmailDialog.access$2(OKCancelButtonListener.access$0(this.this$1), Boolean.FALSE);
                                }
                                AdminEmailDialog.access$3(OKCancelButtonListener.access$0(this.this$1)).waitOff();
                            }
                        };
                        ((Thread)object).start();
                        break block14;
                    }
                    Boolean bl = AdminEmailDialog.this.applyInProgress;
                    synchronized (bl) {
                        if (AdminEmailDialog.this.applyInProgress.booleanValue()) {
                            Object var3_6 = null;
                            return;
                        }
                    }
                    ((Window)((Object)AdminEmailDialog.this)).dispose();
                }
                catch (Exception exception) {
                    new ErrorDialog(AdminEmailDialog.this.theApp.getFrame(), exception.getLocalizedMessage());
                    Boolean bl = AdminEmailDialog.this.applyInProgress;
                    synchronized (bl) {
                        AdminEmailDialog.this.applyInProgress = Boolean.FALSE;
                    }
                    AdminEmailDialog.this.theApp.waitOff();
                }
            }
        }
    }
}

