/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.templates;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListFetchAdapter;
import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.usermgr.client.AppData;
import com.sun.admin.usermgr.client.Content;
import com.sun.admin.usermgr.client.ServiceWrapper;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.templates.AddTemplDlg;
import com.sun.admin.usermgr.client.templates.ConfDelTemplPanel;
import com.sun.admin.usermgr.client.templates.UMgrTemplMenuBar;
import com.sun.admin.usermgr.client.templates.UMgrTemplTBar;
import com.sun.admin.usermgr.common.TemplateObj;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.util.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.tree.MutableTreeNode;

public class TemplContent
extends Content {
    private static String[][] columnHeaders = null;
    private ResourceBundle bundle;
    private ListProperties listProperties;
    private ImageIcon smallUsersIcon;
    private ImageIcon largeUsersIcon;
    private UMgrTemplMenuBar templMenuBar;
    private UMgrTemplTBar templToolBar;
    TemplContent templContent;
    VUserMgr theApp;

    public TemplContent(VUserMgr vUserMgr) {
        super(vUserMgr);
        this.theApp = vUserMgr;
        this.templContent = this;
        this.bundle = vUserMgr.getResourceBundle();
        this.sortPreferencesKey = String.valueOf(this.getClass().getName()) + ".sortPreferences";
        this.templMenuBar = new UMgrTemplMenuBar(vUserMgr, this);
        this.templToolBar = new UMgrTemplTBar(vUserMgr, this);
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.templMenuBar);
        this.rootNode.setToolBar((JToolBar)this.templToolBar);
        this.smallUsersIcon = vUserMgr.loadImageIcon("user_temp_16.gif", "");
        this.largeUsersIcon = vUserMgr.loadImageIcon("user_temp_32.gif", "");
    }

    public void appendToResultsPane(Vector vector) {
        TemplateObj templateObj;
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        String string = ResourceManager.getLocalizedTextFile((String)"html/utemp.html", this.theApp.getClass());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            templateObj = (TemplateObj)enumeration.nextElement();
            VScopeNode vScopeNode = new VScopeNode(null, null, null, null, null, this.templMenuBar.getPopupMenu(), this.smallUsersIcon, this.largeUsersIcon, templateObj.getTName(), null, null, -1, (Object)templateObj);
            vScopeNode.setHTMLText(string);
            vScopeNode.setColumnValues(TemplContent.getColumnValues(this.bundle, templateObj));
            vScopeNode.setDescription(templateObj.getTDescription());
            this.rootNode.add((MutableTreeNode)vScopeNode);
            this.vDataCache.addElement(templateObj);
        }
        templateObj = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.getTreeNode());
        this.theApp.fireConsoleAction((VConsoleEvent)templateObj);
    }

    public void clear(boolean bl) {
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.templMenuBar);
        this.rootNode.setToolBar((JToolBar)this.templToolBar);
        this.getTreeNode().setInternalRoot(this.rootNode);
        if (bl) {
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
            this.theApp.fireConsoleAction(vConsoleEvent);
        }
        this.bRefresh = true;
    }

    public void cloneTempl() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                TemplContent.this.theApp.waitOn();
                Vector vector = TemplContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                TemplateObj templateObj = (TemplateObj)vScopeNode.getPayload();
                TemplateObj templateObj2 = (TemplateObj)templateObj.clone();
                AddTemplDlg addTemplDlg = new AddTemplDlg(TemplContent.this.theApp, templateObj2, TemplContent.this.templContent, true);
                ((Component)((Object)addTemplDlg)).setVisible(true);
                TemplContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void createProperties() {
        Thread thread = new Thread(){

            public void run() {
                TemplContent.this.theApp.waitOn();
                AddTemplDlg addTemplDlg = new AddTemplDlg(TemplContent.this.theApp, null, TemplContent.this.templContent, false);
                ((Component)((Object)addTemplDlg)).setVisible(true);
                TemplContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void deleteSelected() {
        ConfDelTemplPanel confDelTemplPanel = new ConfDelTemplPanel(this.theApp);
        String string = new String(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_templ"));
        final Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        VScopeNode vScopeNode = (VScopeNode)enumeration.nextElement();
                        TemplateObj templateObj = (TemplateObj)vScopeNode.getPayload();
                        String string = templateObj.getTName();
                        TemplContent.this.theApp.getUserMgr().deleteTemplate(string);
                        TemplContent.this.theApp.setAllTemplsCache(null);
                        TemplContent.this.templContent.removeFromResultsPane(templateObj);
                    }
                    catch (Exception exception) {
                        TemplContent.this.theApp.reportErrorException(exception);
                    }
                }
            }
        };
        WarningDialog warningDialog = new WarningDialog(this.theApp.getFrame(), string, (JPanel)confDelTemplPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"warning_delete"));
    }

    public String[][] getColumnHeaders() {
        Object[][] objectArray = new Object[][]{{ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_templ_desc"), new Integer(32)}, {ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_templ_last_mod"), new Integer(16)}, {ResourceStrings.getString((ResourceBundle)this.bundle, (String)"table_templ_mod_by"), new Integer(16)}};
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(objectArray);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, TemplateObj templateObj) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 1;
        String string = columnHeaders[n++][0];
        Date date = templateObj.getModDateTime();
        if (date == null) {
            date = new Date();
        }
        hashtable.put(string, date);
        string = columnHeaders[n++][0];
        String string2 = templateObj.getTUserName();
        if (string2 == null) {
            string2 = "";
        }
        hashtable.put(string, string2);
        return hashtable;
    }

    private int getDisplayChunkSize() {
        return 0;
    }

    public ListProperties getListProperties() {
        return this.listProperties;
    }

    public UMgrTemplMenuBar getMenuBar() {
        return this.templMenuBar;
    }

    private int getServerChunkSize() {
        return 0;
    }

    public UMgrTemplTBar getToolBar() {
        return this.templToolBar;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public void refresh() {
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear(false);
        this.theApp.setStatusBar("");
        MyListFetch myListFetch = new MyListFetch(this.getServerChunkSize(), this.getDisplayChunkSize());
        myListFetch.addListFetchListener(new ListFetchListener(){

            public synchronized void batchReady(ListFetchEvent listFetchEvent) {
                Vector vector = listFetchEvent.getBatch();
                if (vector == null) {
                    TemplContent.this.theApp.waitOff();
                    return;
                }
                TemplContent.this.updateStatusBar();
                TemplContent.this.appendToResultsPane(vector);
            }

            public synchronized void errorException(Exception exception) {
                TemplContent.this.theApp.reportErrorException(exception);
            }
        });
        this.theApp.waitOn();
        ((Thread)((Object)myListFetch)).start();
        this.bRefresh = true;
    }

    private void removeFromResultsPane(TemplateObj templateObj) {
        int n = 0;
        while (n < this.rootNode.getChildCount()) {
            VScopeNode vScopeNode = (VScopeNode)this.rootNode.getChildAt(n);
            TemplateObj templateObj2 = (TemplateObj)vScopeNode.getPayload();
            if (templateObj2 == templateObj) {
                this.rootNode.remove((MutableTreeNode)vScopeNode);
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode);
                this.theApp.fireConsoleAction(vConsoleEvent);
                break;
            }
            ++n;
        }
    }

    public void renameSelected() {
    }

    public void setListProperties(ListProperties listProperties) {
        this.listProperties = listProperties;
    }

    public void updateStatusBar() {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"TemplListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setStatusBar(string2);
    }

    public void viewProperties() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                TemplContent.this.theApp.waitOn();
                Vector vector = TemplContent.this.getSelected();
                VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
                TemplateObj templateObj = (TemplateObj)vScopeNode.getPayload();
                try {
                    templateObj = TemplContent.this.theApp.getUserMgr().getTemplate(templateObj.getTName());
                }
                catch (AdminException adminException) {
                    TemplContent.this.theApp.reportErrorException((Exception)((Object)adminException));
                    return;
                }
                AddTemplDlg addTemplDlg = new AddTemplDlg(TemplContent.this.theApp, templateObj, TemplContent.this.templContent, false);
                ((Component)((Object)addTemplDlg)).setVisible(true);
                TemplContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"templates");
    }

    private class MyListFetch
    extends ListFetchAdapter {
        ServiceWrapper userMgr;
        AppData appData = null;
        ListProperties listProps;

        public MyListFetch(int n, int n2) {
            super(n, n2);
        }

        public String getTracePrefix() {
            return ResourceStrings.getString((ResourceBundle)TemplContent.this.bundle, (String)"templates");
        }

        public Vector listAll() throws AdminException {
            Vector vector = new Vector();
            try {
                vector = TemplContent.this.theApp.getUserMgr().getAllTemplates();
                TemplContent.this.theApp.setAllTemplsCache(vector);
            }
            catch (Exception exception) {
                TemplContent.this.theApp.reportErrorException(exception);
            }
            return vector;
        }
    }
}

