/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import palm.conduit.Record;

public abstract class AbstractRecord
implements Record,
Serializable {
    int recId;
    int recIndex;
    int categoryIndex;
    boolean isDeleted = false;
    boolean isModified = false;
    boolean isNew = false;
    boolean isArchived = false;
    boolean isPrivate = false;
    static final int YEAR_SHIFT_FACTOR = 9;
    static final int MONTH_SHIFT_FACTOR = 5;
    static final int HOUR_SHIFT_FACTOR = 8;
    static final int FIRST_YEAR = 1904;

    static byte[] _getBytes(Record rec) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        rec.writeData(dataOut);
        dataOut.flush();
        dataOut.close();
        return byteOut.toByteArray();
    }

    public boolean equals(Object obj) {
        byte[] recBytes;
        byte[] bytes;
        try {
            Record rec = (Record)obj;
            bytes = AbstractRecord._getBytes(this);
            recBytes = AbstractRecord._getBytes(rec);
        }
        catch (IOException iOException) {
            return false;
        }
        if (bytes.length != recBytes.length) {
            return false;
        }
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] != recBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int fromMinutes(int time) throws IOException {
        int hours = 0;
        int minutes = 0;
        hours = time / 60;
        minutes = time % 60;
        return hours << 8 | minutes;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public int getId() {
        return this.recId;
    }

    public int getIndex() {
        return this.recIndex;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    String nullIfEmpty(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    public static String readCString(DataInputStream in) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        do {
            if ((c = in.read()) == 0) continue;
            buf.append((char)c);
        } while (c > 0);
        return buf.toString();
    }

    public abstract void readData(DataInputStream var1) throws IOException;

    public static Date readDate(DataInputStream in) throws IOException {
        short date = in.readShort();
        if (date == -1) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int year = ((date & 0xFE00) >>> 9) + 1904;
        int month = ((date & 0x1E0) >>> 5) - 1;
        int day = date & 0x1F;
        cal.set(year, month, day, 0, 0, 0);
        return cal.getTime();
    }

    public void setCategoryIndex(int categoryIndex) {
        this.categoryIndex = categoryIndex;
    }

    public void setId(int recId) {
        this.recId = recId;
    }

    public void setIndex(int recIndex) {
        this.recIndex = recIndex;
    }

    public void setIsArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    public void setIsDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setIsModified(boolean isModified) {
        this.isModified = isModified;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    static String stringWithoutCarriageReturns(String aString) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int c = aString.length();
        while (i < c) {
            char ch = aString.charAt(i);
            if (ch != '\r' || i + 1 >= c || aString.charAt(i + 1) != '\n') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public String sunwNullIfEmpty(String s) {
        return this.nullIfEmpty(s);
    }

    public static Date sunwReadDate(DataInputStream in) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(AbstractRecord.readDate(in));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String sunwStringWithoutCarriageReturns(String aString) {
        return AbstractRecord.stringWithoutCarriageReturns(aString);
    }

    public String toFormattedString() {
        return "AbstractRecord: {\n  record id: " + this.getId() + "\n" + "  record index: " + this.getIndex() + "\n" + "  category index: " + this.getCategoryIndex() + "\n" + "  is deleted: " + this.isDeleted() + "\n" + "  is modified: " + this.isModified() + "\n" + "  is new: " + this.isNew() + "\n" + "  is archived: " + this.isArchived() + "\n" + "  isPrivate: " + this.isPrivate() + "\n" + "}\n";
    }

    public static int toMinutes(int time) throws IOException {
        int hours = 0;
        int minutes = 0;
        if (time != -1) {
            hours = (time & 0xFF00) >> 8;
            minutes = time & 0xFF;
        }
        return hours * 60 + minutes;
    }

    public String toString() {
        return "<record id: " + this.getId() + "> <record index: " + this.getIndex() + "> <is deleted: " + this.isDeleted() + "> <is new: " + this.isNew() + "> <is archived: " + this.isArchived() + "> <isPrivate: " + this.isPrivate() + ">";
    }

    public static void writeCString(DataOutputStream in, String string) throws IOException {
        in.write(string.getBytes());
        in.write(0);
    }

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public static void writeDate(DataOutputStream out, Date date) throws IOException {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int year = cal.get(1) - 1904;
            int d = year << 9 | month << 5 | day;
            out.writeShort(d);
        } else {
            out.writeShort(-1);
        }
    }
}

