/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InternalTerminalManager;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.NoSuchTerminalException;
import com.sun.smartcard.scf.SessionInfo;
import com.sun.smartcard.scf.Terminal;
import com.sun.smartcard.scf.TerminalManager;
import com.sun.smartcard.scf.spi.SessionProvider;
import com.sun.smartcard.scf.spi.SessionProviderFactory;
import com.sun.smartcard.util.GetEnv;

public class Session {
    public static final String INFO_TERMINAL_NAMES = "terminalnames";
    static final int TIMEOUT_MAX = 2147483;
    private static final String DEFAULT_FACTORY = "com.sun.smartcard.scfimpl.OCFSessionProviderFactory";
    private static SessionProviderFactory factory;
    private final Logger logger = Logger.createLogger("Session");
    private boolean isActive = false;
    private TerminalManager terminalManager;
    private InternalTerminalManager internalTerminalManager;
    private SessionProvider sessionProvider;
    private SessionInfo sessionInfo = null;

    private Session() {
    }

    void activate() {
        this.isActive = true;
    }

    public void close() {
        this.logger.log("close", "");
        if (this.isActive) {
            this.isActive = false;
            this.terminalManager.close();
            this.internalTerminalManager.close();
            this.sessionProvider.close();
        }
    }

    public Object getInfo(String string) throws InvalidStateException, CommException, InternalException {
        this.verifyState();
        return this.sessionInfo.get(string);
    }

    public static Session getSession() throws CommException, InternalException {
        Object object;
        if (factory == null) {
            object = System.getProperty("com.sun.smartcard.scf.sessionfactory");
            if (object == null) {
                object = DEFAULT_FACTORY;
            }
            try {
                Class<?> clazz = Class.forName((String)object);
                factory = (SessionProviderFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalException(classNotFoundException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new InternalException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalException(illegalAccessException.getMessage());
            }
        }
        object = new Session();
        super.init(factory.getSessionProvider());
        ((Session)object).activate();
        return object;
    }

    public Terminal getTerminal(String string) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        this.logger.log("getTerminal", "");
        this.verifyState();
        if (string == null && (string = GetEnv.getEnv("SCF_DEFAULT_TERMINAL")) == null) {
            String[] stringArray = (String[])this.getInfo(INFO_TERMINAL_NAMES);
            if (stringArray.length == 0) {
                throw new NoSuchTerminalException("No terminals available.");
            }
            string = stringArray[0];
        }
        return this.terminalManager.getTerminal(string);
    }

    private void init(SessionProvider sessionProvider) {
        this.isActive = false;
        this.sessionProvider = sessionProvider;
        this.internalTerminalManager = new InternalTerminalManager();
        this.internalTerminalManager.init(this.sessionProvider);
        this.internalTerminalManager.activate();
        this.terminalManager = new TerminalManager();
        this.terminalManager.init(this.internalTerminalManager);
        this.terminalManager.activate();
        this.sessionInfo = new SessionInfo();
        this.sessionInfo.init(this.sessionProvider);
    }

    private void verifyState() throws InvalidStateException {
        if (!this.isActive) {
            throw new InvalidStateException();
        }
    }
}

