/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.process;

import com.sun.wbem.solarisprovider.process.ProcessManagerRunCmd;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ProcessResourceLimits
implements Serializable {
    private static final String[] ENV_ARGS = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
    private static final String PLIMIT = "/usr/bin/plimit";
    private static final String delimiter = " \t\n\r\f";
    private String MaxFileSizeLimit = null;
    private String CurrentFileSizeLimit = null;
    private String MaxHeapSizeLimit = null;
    private String CurrHeapSizeLimit = null;
    private String MaxStackSizeLimit = null;
    private String CurrStackSizeLimit = null;
    private String MaxCPUTIMELimit = null;
    private String CurrentCPUTIMELimit = null;
    private String MaxFileDescriptorLimit = null;
    private String CurrFileDescriptorLimit = null;
    private String MaxCoreFileSizeLimit = null;
    private String CurrCoreFileSizeLimit = null;
    private String MaxVirtualMemorySizeLimit = null;
    private String CurrVirtualMemorySizeLimit = null;

    public ProcessResourceLimits(String string) {
        Vector vector = null;
        vector = this.getProcessResourceLimits(string);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (n == 2) {
                    this.setCPUTIMELimits((String)vector.elementAt(2));
                } else if (n == 3) {
                    this.setFileSizeLimits((String)vector.elementAt(3));
                } else if (n == 4) {
                    this.setHeapSizeLimits((String)vector.elementAt(4));
                } else if (n == 5) {
                    this.setStackSizeLimits((String)vector.elementAt(5));
                } else if (n == 6) {
                    this.setCoreFileSizeLimits((String)vector.elementAt(6));
                } else if (n == 7) {
                    this.setFileDescriptorLimits((String)vector.elementAt(7));
                } else if (n == 8) {
                    this.setVirtualMemorySizeLimits((String)vector.elementAt(8));
                }
                ++n;
            }
        }
    }

    public String getCurrCoreFileSizeLimit() {
        return this.CurrCoreFileSizeLimit;
    }

    public String getCurrFileDescriptorLimit() {
        return this.CurrFileDescriptorLimit;
    }

    public String getCurrHeapSizeLimit() {
        return this.CurrHeapSizeLimit;
    }

    public String getCurrStackSizeLimit() {
        return this.CurrStackSizeLimit;
    }

    public String getCurrVirtualMemorySizeLimit() {
        return this.CurrVirtualMemorySizeLimit;
    }

    public String getCurrentCPUTIMELimit() {
        return this.CurrentCPUTIMELimit;
    }

    public String getCurrentFileSizeLimit() {
        return this.CurrentFileSizeLimit;
    }

    public String getMaxCPUTIMELimit() {
        return this.MaxCPUTIMELimit;
    }

    public String getMaxCoreFileSizeLimit() {
        return this.MaxCoreFileSizeLimit;
    }

    public String getMaxFileDescriptorLimit() {
        return this.MaxFileDescriptorLimit;
    }

    public String getMaxFileSizeLimit() {
        return this.MaxFileSizeLimit;
    }

    public String getMaxHeapSizeLimit() {
        return this.MaxHeapSizeLimit;
    }

    public String getMaxStackSizeLimit() {
        return this.MaxStackSizeLimit;
    }

    public String getMaxVirtualMemorySizeLimit() {
        return this.MaxVirtualMemorySizeLimit;
    }

    private Vector getProcessResourceLimits(String string) {
        String string2 = "-km";
        Vector vector = null;
        String[] stringArray = new String[]{PLIMIT, string2, string};
        ProcessManagerRunCmd processManagerRunCmd = new ProcessManagerRunCmd(stringArray, ENV_ARGS);
        if (processManagerRunCmd.getResult() != 0) {
            processManagerRunCmd.dispose();
        } else {
            vector = processManagerRunCmd.getOutput();
            processManagerRunCmd.dispose();
        }
        return vector;
    }

    private void initProcessResourceLimits() {
        this.MaxFileSizeLimit = null;
        this.CurrentFileSizeLimit = null;
        this.MaxHeapSizeLimit = null;
        this.CurrHeapSizeLimit = null;
        this.MaxStackSizeLimit = null;
        this.CurrStackSizeLimit = null;
        this.MaxCPUTIMELimit = null;
        this.CurrentCPUTIMELimit = null;
        this.MaxFileDescriptorLimit = null;
        this.CurrFileDescriptorLimit = null;
        this.MaxCoreFileSizeLimit = null;
        this.CurrCoreFileSizeLimit = null;
        this.MaxVirtualMemorySizeLimit = null;
        this.CurrVirtualMemorySizeLimit = null;
    }

    public void printData() {
        System.out.println(String.valueOf(this.MaxFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrentFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxHeapSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrHeapSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxStackSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrStackSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxCPUTIMELimit) + "\t");
        System.out.println(String.valueOf(this.CurrentCPUTIMELimit) + "\t");
        System.out.println(String.valueOf(this.MaxFileDescriptorLimit) + "\t");
        System.out.println(String.valueOf(this.CurrFileDescriptorLimit) + "\t");
        System.out.println(String.valueOf(this.MaxCoreFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrCoreFileSizeLimit) + "\t");
        System.out.println(String.valueOf(this.MaxVirtualMemorySizeLimit) + "\t");
        System.out.println(String.valueOf(this.CurrVirtualMemorySizeLimit) + "\n");
    }

    private void setCPUTIMELimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrCPUTIMELimit(stringTokenizer.nextToken());
                this.setMaxCPUTIMELimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setCoreFileSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrCoreFileSizeLimit(stringTokenizer.nextToken());
                this.setMaxCoreFileSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setCurrCPUTIMELimit(String string) {
        this.CurrentCPUTIMELimit = string;
    }

    private void setCurrCoreFileSizeLimit(String string) {
        this.CurrCoreFileSizeLimit = string;
    }

    private void setCurrFileDescriptorLimit(String string) {
        this.CurrFileDescriptorLimit = string;
    }

    private void setCurrFileSizeLimit(String string) {
        this.CurrentFileSizeLimit = string;
    }

    private void setCurrHeapSizeLimit(String string) {
        this.CurrHeapSizeLimit = string;
    }

    private void setCurrStackSizeLimit(String string) {
        this.CurrStackSizeLimit = string;
    }

    private void setCurrVirtualMemorySizeLimit(String string) {
        this.CurrVirtualMemorySizeLimit = string;
    }

    private void setFileDescriptorLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrFileDescriptorLimit(stringTokenizer.nextToken());
                this.setMaxFileDescriptorLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setFileSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrFileSizeLimit(stringTokenizer.nextToken());
                this.setMaxFileSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setHeapSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrHeapSizeLimit(stringTokenizer.nextToken());
                this.setMaxHeapSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setMaxCPUTIMELimit(String string) {
        this.MaxCPUTIMELimit = string;
    }

    private void setMaxCoreFileSizeLimit(String string) {
        this.MaxCoreFileSizeLimit = string;
    }

    private void setMaxFileDescriptorLimit(String string) {
        this.MaxFileDescriptorLimit = string;
    }

    private void setMaxFileSizeLimit(String string) {
        this.MaxFileSizeLimit = string;
    }

    private void setMaxHeapSizeLimit(String string) {
        this.MaxHeapSizeLimit = string;
    }

    private void setMaxStackSizeLimit(String string) {
        this.MaxStackSizeLimit = string;
    }

    private void setMaxVirtualMemorySizeLimit(String string) {
        this.MaxVirtualMemorySizeLimit = string;
    }

    private void setStackSizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrStackSizeLimit(stringTokenizer.nextToken());
                this.setMaxStackSizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }

    private void setVirtualMemorySizeLimits(String string) {
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimiter);
        int n = stringTokenizer.countTokens();
        try {
            if (n >= 3) {
                stringTokenizer.nextToken();
                this.setCurrVirtualMemorySizeLimit(stringTokenizer.nextToken());
                this.setMaxVirtualMemorySizeLimit(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
    }
}

