/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.ApplicationSession;
import com.sun.web.core.Context;
import com.sun.web.core.HttpServletRequestFacade;
import com.sun.web.core.Response;
import com.sun.web.core.ServerSession;
import com.sun.web.core.ServerSessionManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpUtils;

public abstract class Request {
    protected Response response;
    protected HttpServletRequestFacade requestFacade;
    protected String scheme = "http";
    protected Context context;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable parameters = new Hashtable();
    protected Vector cookies = new Vector();
    protected String protocol;
    protected String requestURI;
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected String queryString;
    protected String method;
    protected int contentLength = -1;
    protected String contentType = "";
    protected String charEncoding = null;
    protected String authType;
    protected String remoteUser;
    protected String reqSessionId;
    protected ServerSession serverSession;
    protected boolean didReadFormData;

    public Request() {
        this.requestFacade = new HttpServletRequestFacade(this);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    Context getContext() {
        return this.context;
    }

    Vector getCookies() {
        return this.cookies;
    }

    public abstract long getDateHeader(String var1);

    HttpServletRequestFacade getFacade() {
        return this.requestFacade;
    }

    public abstract String getHeader(String var1);

    public abstract Enumeration getHeaderNames();

    public abstract ServletInputStream getInputStream() throws IOException;

    public abstract int getIntHeader(String var1);

    String getLookupPath() {
        return this.lookupPath;
    }

    public String getMethod() {
        return this.method;
    }

    public Enumeration getParameterNames() {
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return this.parameters.keys();
    }

    public String[] getParameterValues(String string) {
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return (String[])this.parameters.get(string);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public abstract BufferedReader getReader() throws IOException;

    public abstract String getRemoteAddr();

    public abstract String getRemoteHost();

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public abstract String getServerName();

    public abstract int getServerPort();

    public String getServletPath() {
        return this.servletPath;
    }

    public ApplicationSession getSession() {
        return this.getSession(true);
    }

    public ApplicationSession getSession(boolean bl) {
        if (this.context == null) {
            System.out.println("CONTEXT WAS NEVER SET");
            return null;
        }
        if (this.serverSession == null && bl) {
            this.serverSession = ServerSessionManager.getManager().getServerSession(this, this.response, true);
            this.serverSession.accessed();
        }
        ApplicationSession applicationSession = null;
        if (this.serverSession != null) {
            applicationSession = this.serverSession.getApplicationSession(this.context, bl);
        }
        return applicationSession;
    }

    private Hashtable mergeParameters(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable.size() == 0) {
            return hashtable2;
        }
        if (hashtable2.size() == 0) {
            return hashtable;
        }
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string = (String)enumeration.nextElement();
            String[] stringArray2 = (String[])hashtable.get(string);
            String[] stringArray3 = (String[])hashtable2.get(string);
            if (stringArray2 == null) {
                stringArray = stringArray3;
            } else {
                stringArray = new String[stringArray2.length + stringArray3.length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                System.arraycopy(stringArray3, 0, stringArray, stringArray2.length, stringArray3.length);
            }
            hashtable3.put(string, stringArray);
        }
        return hashtable3;
    }

    private void readFormData() {
        block2: {
            this.didReadFormData = true;
            if (this.contentType == null || !this.contentType.equals("application/x-www-form-urlencoded")) break block2;
            try {
                Hashtable hashtable = HttpUtils.parsePostData(this.contentLength, this.getInputStream());
                this.parameters = this.mergeParameters(this.parameters, hashtable);
            }
            catch (IOException iOException) {}
        }
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    protected void reset() {
        this.response = null;
        this.scheme = "http";
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.cookies.removeAllElements();
        this.method = null;
        this.protocol = null;
        this.requestURI = null;
        this.queryString = null;
        this.contentLength = -1;
        this.contentType = "";
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didReadFormData = false;
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public void setCharacterEncoding(String string) {
        this.charEncoding = string;
    }

    void setContext(Context context) {
        this.context = context;
        this.contextPath = context.getPath();
        this.lookupPath = this.requestURI.substring(this.contextPath.length(), this.requestURI.length());
        int n = this.lookupPath.indexOf("?");
        if (n > -1) {
            this.lookupPath = this.lookupPath.substring(0, n);
        }
        if (this.lookupPath.length() < 1) {
            this.lookupPath = "/";
        }
    }

    public void setPathInfo(String string) {
        this.pathInfo = string;
    }

    void setRequestedSessionId(String string) {
        this.reqSessionId = string;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    void setServerSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    void setServletPath(String string) {
        this.servletPath = string;
    }
}

