/*
 * Copyright 1987-2003 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Copyright (c) 1994-2003 by Fujitsu, Ltd.
 * All rights reserved.
 */

#ifndef _SYS_CPU_MODULE_H
#define	_SYS_CPU_MODULE_H

#pragma ident	"@(#)cpu_module.h	1.28	03/09/24 SMI"

#include <sys/pte.h>
#ifdef STINGRAY
#include <sys/mutex.h>
#endif /* STINGRAY */
#include <sys/async.h>
#include <sys/x_call.h>

#ifdef	__cplusplus
extern "C" {
#endif


#ifdef _KERNEL

/*
 * The are functions that are expected of the cpu modules.
 */

extern struct module_ops *moduleops;

/*
 * module initialization
 */
void	cpu_setup(void);
#ifdef STINGRAY
extern void	init_hw_regs(void);
#endif /* STINGRAY */

/*
 * set CPU implementation details
 */
void	cpu_fiximp(dnode_t dnode);

/*
 * virtual demap flushes (tlbs & virtual tag caches)
 */
void	vtag_flushpage(caddr_t addr, uint_t ctx);
void	vtag_flushctx(uint_t ctx);
void	vtag_flushall(void);
void	vtag_flushpage_tl1(uint64_t addr, uint64_t ctx);
void	vtag_flushctx_tl1(uint64_t ctx, uint64_t dummy);
void	vtag_flushall_tl1(uint64_t dummy1, uint64_t dummy2);

/*
 * virtual alias flushes (virtual address caches)
 */
void	vac_flushpage(pfn_t pf, int color);
void	vac_flushpage_tl1(uint64_t pf, uint64_t color);
void	vac_flushcolor(int color, pfn_t pf);
void	vac_flushcolor_tl1(uint64_t color, uint64_t dummy);

/*
 * sending x-calls
 */
#ifdef STINGRAY
/* FJC:30:XCALL */
void fj_send_mondo(xcfunc_t *func, uint64_t arg1, uint64_t arg2, int upaid);
#else /* Sun Ultra */
void	init_mondo(xcfunc_t *func, uint64_t arg1, uint64_t arg2);
void	send_one_mondo(int cpuid);
void	send_mondo_set(cpuset_t set);
#endif /* STINGRAY */

#ifdef _KAISER
/*
 * Kaiser may need the special pci function.
 */
int pci_ue_error(uint64_t *afsr, uint64_t *afar, u_short ecc_synd,
	u_short size, u_short offset, u_short id, u_short inst,
	async_func_t log_func);
#endif /* _KAISER */

/*
 * flush instruction cache if needed
 */
void	flush_instr_mem(caddr_t addr, size_t len);

/*
 * take pending fp traps if fpq present
 * this function is also defined in fpusystm.h
 */
void	syncfpu(void);

/*
 * Cpu-specific error and ecache handling routines
 */
void	ce_err(void);
void	ce_err_tl1(void);
void	async_err(void);
void	cpu_flush_ecache(void);
void	cpu_disable_errors(void);
/* It could be removed later if prom enables errors */
void	cpu_enable_errors(void);
void	cpu_ce_scrub_mem_err(struct async_flt *ecc);
void	cpu_ce_log_err(struct async_flt *ecc);
void	cpu_async_log_err(void *aflt);
int	cpu_aflt_size(void);
void	cpu_async_panic_callb(void);
void	cpu_check_allcpus(struct async_flt *aflt);
void	cpu_get_unum(int syncode, struct async_flt *aflt, char *unum,
		int cnt, int *len);
void	read_ecc_data(struct async_flt *ecc, short verbose, short ce_err);
/* add clr_datapath to aviod lint warning for ac_test.c temporarily */
void	clr_datapath(void);

/*
 * retrieve information from the specified tlb entry. these functions are
 * called by "cpr" module
 */
#ifdef STINGRAY
/* FJC:9:MMU.TLB */
/*
 * stingray has only one combined tlb's, instead of a itlb and dtlb in
 * ultrasparc
 */
void	mtlb_rd_entry(uint_t entry, tte_t *tte, uint64_t *va_tag);

#else
void	itlb_rd_entry(uint_t entry, tte_t *tte, uint64_t *va_tag);
void	dtlb_rd_entry(uint_t entry, tte_t *tte, uint64_t *va_tag);
#endif /* STINGRAY */

/*
 * this symbol appears as a second label for vtag_flushall
 * only for cpus that implement DEMAP_ALL_TYPE
 */
#pragma	weak demap_all

/*
 * change cpu speed
 */
void	cpu_change_speed(uint64_t divisor, uint64_t arg2);

/*
 * ecache scrub operations
 */
void cpu_init_ecache_scrub(void);
void cpu_idle_ecache_scrub(struct cpu *);
void cpu_busy_ecache_scrub(struct cpu *);

/*
 * Cpu private initialize/uninitialize, including ecache scrubber.
 */
void	cpu_init_private(struct cpu *);
void	cpu_uninit_private(struct cpu *);

#pragma weak cpu_mp_init
void	cpu_mp_init(void);

#pragma weak cpu_feature_init
void	cpu_feature_init(void);


/*
 * clock/tick register operations
 */
void	cpu_clearticknpt(void);
void	cpu_init_tick_freq(void);

/*
 * stick synchronization
 */
void	sticksync_slave(void);
void	sticksync_master(void);

/*
 * Check for Correctable Errors that may have occurred
 * while CEEN was disabled.
 */
void cpu_check_ce(int, uint64_t, caddr_t, uint_t);

#ifdef STINGRAY
/* FJC:33:RAS */
/*
 * Taiho/Kaiser ce_info is defined here. The original one is
 * in ecc.c.
 */
struct ce_info {
	char    name[UNUM_NAMLEN];
	short	intermittent_cnt;
	short	persistent_cnt;
	short	sticky_cnt;
#ifdef _COLUMBUS
	int 	bnum;
#endif /* _COLUMBUS */
};
#endif /* STINGRAY */

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_CPU_MODULE_H */
