/*
 * Copyright (c) 1998-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_USBA_H
#define	_SYS_USBA_H

#pragma ident	"@(#)usba.h	1.7	00/06/03 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#include <sys/note.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/cmn_err.h>
#include <sys/debug.h>
#include <sys/devops.h>
#include <sys/ddi.h>
#include <sys/sunddi.h>
#include <sys/stat.h>
#include <sys/devctl.h>
#include <sys/modctl.h>
#include <sys/conf.h>
#include <sys/open.h>
#include <sys/kmem.h>

typedef struct usb_opaque *usb_opaque_t;

/*
 * Header file for USBA
 * client driver interfaces
 */
#include <sys/usb/usbai.h>

/*
 * available class codes
 */
#define	AUDIO_CLASS_CODE	1
#define	COMM_CLASS_CODE		2
#define	HID_CLASS_CODE		3
#define	PHYS_CLASS_CODE		5
#define	PRINTER_CLASS_CODE	7
#define	MASS_STORAGE_CLASS_CODE 8	/* Mass storage class code */
#define	HUB_CLASS_CODE		9
#define	DATA_CLASS_CODE		10
#define	SECURITY_CLASS_CODE	13

#define	APP_CLASS_CODE		254


/*
 * sub class & protocol codes
 *
 * audio sub class
 */
#define	AUDIO_CONTROL_SUBCLASS		0x01
#define	AUDIO_STREAMING_SUBCLASS	0x02
#define	AUDIO_MIDI_STREAMING_SUBCLASS	0x03

/* comms subclass */
#define	COMM_DIRECT_LINE_SUBCLASS	0x01
#define	COMM_ABSTRACT_CTRL_SUBCLASS	0x02
#define	COMM_TELEPHONE_CTRL_SUBCLASS	0x03
#define	COMM_MULTI_CHNL_ISDN_SUBCLASS	0x04
#define	COMM_ISDN_SUBCLASS		0x05
#define	COMM_ETHERNET_SUBCLASS		0x06
#define	COMM_ATM_NETWORKING_SUBCLASS	0x07

/* hid subclass & protocols */
#define	HID_SUBCLASS		1

/* Boot protocol values for keyboard and mouse */
#define	HID_KEYBOARD_PROTOCOL	0x01	/* legacy keyboard */
#define	HID_MOUSE_PROTOCOL	0x02	/* legacy mouse */

/* printer sub class & protocol */
#define	PRINTER_SUBCLASS	1

#define	PRINTER_UNI_PROTOCOL	0x01	/* Unidirectional interface */
#define	PRINTER_BI_PROTOCOL	0x02	/* Bidirectional interface */

/* mass storage sub class & protocols */
#define	MS_RBC_T10_SUB_CLASS	0x1	/* flash */
#define	MS_SFF8020I_SUB_CLASS	0x2	/* CD-ROM */
#define	MS_QIC_157_SUB_CLASS	0x3	/* tape */
#define	MS_UFI_SUB_CLASS	0x4	/* USB Floppy Disk Drive   */
#define	MS_SFF8070I_SUB_CLASS	0x5	/* floppy */
#define	MS_SCSI_SUB_CLASS	0x6	/* transparent scsi */

#define	MS_CBI_WC_PROTOCOL	0x00 /* USB CBI Protocol with cmp intr */
#define	MS_CBI_PROTOCOL			0x01	/* USB CBI Protocol */
#define	MS_ISD_1999_SILICON_PROTOCOL	0x02	/* ZIP Protocol */
#define	MS_BULK_ONLY_PROTOCOL		0x50	/* USB Bulk Only Protocol */

/* app subclasses */
#define	APP_FIRMWARE_SUBCLASS	0x01	/* app spec f/w class */
#define	APP_IRDA_SUBCLASS	0x02	/* app spec IrDa class */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_USBA_H */
