/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_CPC_ULTRA_H
#define	_SYS_CPC_ULTRA_H

#pragma ident	"@(#)cpc_ultra.h	1.4	06/03/06 SMI"

#include <sys/inttypes.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_KERNEL)

#ifdef	STINGRAY

extern void sray_pmc_clear_enable(void);
extern void sray_pmc_clear_disable(void);
extern void sray_pmc_disable(void);
extern void sray_pmc_enable(void);
extern void sray_pmc_set_pm0_view(int view);
extern void sray_pmc_set_pm1_view(int view);
extern void sray_pmc_set_views(int view);
extern u_int sray_pmc_read_pm_reg0(void);
extern u_int sray_pmc_read_pm_reg1(void);
extern u_int sray_pmc_read_pm_reg2(void);
extern u_int sray_pmc_read_pm_reg3(void);
extern u_int sray_pmc_read_pm_reg4(void);
extern u_int sray_pmc_read_pm_reg5(void);
extern u_int sray_pmc_read_pm_reg6(void);
extern void sray_pmc_read_regs(uint32_t *);

#else

extern void ultra_setpcr(uint64_t);
extern uint64_t ultra_getpcr(void);
extern void ultra_setpic(uint64_t);
extern uint64_t ultra_getpic(void);

#endif	/* STINGRAY */

extern uint64_t ultra_gettick(void);

#endif	/* _KERNEL */

#ifdef __cplusplus
}
#endif

#endif	/* _SYS_CPC_ULTRA_H */
